set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9626489';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '3334441',
      1,
      0.022164,
      5,
      2,
      '0143',
      3.659263,
      1.031238,
      NULL,
      NULL,
      NULL,
      44.240767,
      NULL,
      5,
      1,
      2,
      ' 4- 8-1987',
      NULL,
      2.232271,
      16,
      58.962250,
      1.031199,
      '10-16-1984',
      ' 5- 6-1977',
      ' 2- 0-2003',
      3.396159,
      0.471816,
      0,
      NULL,
      1.369186,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      5.235602,
      2,
      15.895428,
      27.663651,
      NULL,
      36,
      2.204623,
      NULL,
      4.434055,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935734,
      2,
      0,
      2,
      4,
      NULL,
      NULL,
      2.877341,
      1,
      11.773298,
      6.724066,
      8.440934,
      2,
      1.298826,
      7.195530,
      1.909626,
      9,
      0,
      1,
      0.967500,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.759168,
      2.997762,
      NULL,
      0,
      1,
      NULL,
      3.268542,
      0.932916,
      0.161415,
      0,
      2,
      NULL,
      NULL,
      0,
      1.362762,
      NULL,
      1,
      0,
      1.783427,
      5,
      2,
      2.831871,
      3.850160,
      NULL,
      4,
      1.422004,
      NULL,
      NULL,
      NULL,
      0.460470,
      NULL,
      NULL,
      NULL,
      0,
      1.192156,
      1,
      4.650826,
      10.811652,
      6,
      0,
      4,
      4,
      NULL,
      0,
      0.978221,
      6.925620,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0.124803,
      NULL,
      0,
      2.673380,
      0.443689,
      NULL,
      1,
      NULL,
      NULL,
      2.815876,
      3,
      0.245669,
      1,
      3,
      1.465475,
      3,
      4.219785,
      1.025584,
      2,
      8,
      3.983656,
      6.482116,
      8.706420,
      9.297078,
      1.563941,
      NULL,
      NULL,
      2.090715,
      ' 3- 0-1977',
      122.748514,
      ' 3-22-2000',
      199,
      3.039412,
      2,
      NULL,
      3.139681,
      NULL,
      NULL,
      NULL,
      1,
      1.230907,
      1,
      NULL,
      7.026339,
      1.583656,
      0,
      0.661272,
      5,
      NULL,
      0.623046,
      2,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.523568,
      NULL,
      4,
      1,
      1,
      1.697021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      3,
      0.275705,
      3,
      1.375118,
      NULL,
      NULL,
      3,
      NULL,
      3,
      9.925602,
      3,
      0,
      NULL,
      NULL,
      NULL,
      7.578336,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.113948,
      0.409660,
      0,
      0.184176,
      1.863483,
      1,
      2,
      55.640374,
      0.844303,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      2,
      2.900786,
      NULL,
      NULL,
      3,
      0.613680,
      NULL,
      1.323798,
      NULL,
      1.519073,
      2,
      3,
      1,
      1,
      0,
      1.724206,
      1.066533,
      1.810303,
      4.245725,
      1,
      1.222538,
      1.873107,
      1,
      1,
      3.453179,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.874853,
      NULL,
      3,
      25,
      63,
      4.205406,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.981563,
      '',
      '',
      NULL,
      2,
      NULL,
      30,
      26,
      0.886904,
      0,
      3.408508,
      5,
      3,
      3,
      3.263637,
      0.768555,
      1.966833,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.115120,
      2.842554,
      1,
      0,
      NULL,
      0.448830,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.005745,
      NULL,
      NULL,
      NULL,
      3.065935,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410238,
      1,
      1.663275,
      2,
      0.720083,
      1,
      2,
      3,
      0.084375,
      1.966605,
      2,
      1,
      0,
      3.317547,
      1.617900,
      1.297445,
      3,
      2.538358,
      0.259211,
      1.351540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.042676,
      0,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834795,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.237927,
      0.659982,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.687634,
      2,
      4,
      1,
      2.602153,
      0.300009,
      3.259914,
      1,
      3.704118,
      3,
      0.407656,
      4,
      NULL,
      NULL,
      NULL,
      1.390360,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.450644,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911236,
      NULL,
      NULL,
      1.455735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.186731,
      4,
      4.289096,
      1.432269,
      3,
      1.800720,
      2.088115,
      0,
      NULL,
      NULL,
      2.773111,
      1,
      NULL,
      0,
      1,
      2,
      2.700336,
      NULL,
      0,
      1,
      NULL,
      0.751693,
      NULL,
      NULL,
      NULL,
      3.851798,
      0.441920,
      0.518489,
      2.054875,
      1.173870,
      7.451788,
      NULL,
      1.912964,
      4.393307,
      1,
      NULL,
      3.136697,
      2.343964,
      5,
      1.002291,
      0.317396,
      1.601045,
      0.742751,
      1.856564,
      1,
      NULL,
      NULL,
      1.710571,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      3.874322,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.903778,
      3,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.206476,
      NULL,
      NULL,
      NULL,
      1.528685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.375004,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.512145,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      3.242162,
      1.817403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      2,
      1.547027,
      NULL,
      NULL,
      1,
      NULL,
      0.391178,
      0,
      1,
      1,
      1.769950,
      0,
      0.393612,
      NULL,
      NULL,
      NULL,
      1.801566,
      0,
      0.235895,
      0.927387,
      1.482847,
      0.798881,
      1.161292,
      0.520209,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.504151,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.720126,
      NULL,
      1,
      1,
      3.436096,
      1,
      NULL,
      1,
      NULL,
      1.113707,
      0,
      NULL,
      1.398465,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      0.599737,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.238571,
      NULL,
      NULL,
      0.581178,
      0.188459,
      NULL,
      1,
      0,
      NULL,
      0.267347,
      1,
      NULL,
      0.515545,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.381001,
      NULL,
      1.131666,
      NULL,
      0,
      NULL,
      0.835750,
      3,
      NULL,
      0.543039,
      NULL,
      NULL,
      65,
      19.842506,
      2.727761,
      NULL,
      NULL,
      '02433',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


