set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '2',
      NULL,
      NULL,
      '2232123',
      1,
      1,
      2,
      0,
      '0142',
      2.472367,
      0.749077,
      NULL,
      NULL,
      ' 4- 2-2002',
      14.617580,
      NULL,
      3.074737,
      1.204683,
      NULL,
      ' 6- 9-1975',
      18,
      NULL,
      311,
      30.731361,
      NULL,
      NULL,
      ' 3-11-1998',
      NULL,
      0,
      1,
      NULL,
      0.580696,
      0.781008,
      1,
      3,
      1.741426,
      NULL,
      NULL,
      NULL,
      2,
      3.209235,
      22.161209,
      18,
      NULL,
      17,
      1.801670,
      NULL,
      7,
      1,
      2.791534,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.960313,
      NULL,
      NULL,
      3,
      2,
      0.850909,
      0.671385,
      5.285401,
      1,
      4,
      1.144200,
      NULL,
      1,
      NULL,
      0,
      1.022940,
      3.578027,
      0.579874,
      1.390307,
      4,
      0,
      2.536746,
      NULL,
      3.484206,
      0,
      NULL,
      NULL,
      1.517393,
      NULL,
      NULL,
      2,
      1.052524,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      0.625499,
      NULL,
      1,
      1,
      0,
      0,
      0.966132,
      0,
      0,
      0.100635,
      0,
      0.269062,
      0.686095,
      NULL,
      NULL,
      1,
      2.178236,
      3,
      1,
      NULL,
      NULL,
      1.793241,
      NULL,
      NULL,
      0,
      0,
      7,
      1.583389,
      0,
      7.392610,
      3,
      1,
      NULL,
      2,
      0,
      NULL,
      1.254717,
      0.417109,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      8,
      NULL,
      3.020337,
      3.125854,
      1,
      3.331543,
      0,
      NULL,
      1.197579,
      5.552059,
      1.843633,
      4.543360,
      1,
      0.828535,
      2,
      1,
      NULL,
      8,
      0.084685,
      2,
      2.707732,
      1.837772,
      NULL,
      3.201705,
      3.194000,
      3,
      ' 2-10-1989',
      NULL,
      ' 6- 2-1998',
      3,
      1,
      NULL,
      0.026627,
      3.615380,
      1.750908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      0.577578,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.716543,
      NULL,
      1.100975,
      2.272881,
      0,
      2.571243,
      1,
      0.877842,
      3,
      NULL,
      4,
      6.341455,
      1.205465,
      0.412147,
      0.068953,
      1.801513,
      NULL,
      3,
      0.299433,
      2,
      5,
      3,
      4.191117,
      NULL,
      NULL,
      NULL,
      NULL,
      0.515958,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.070375,
      1,
      0.115214,
      NULL,
      0.493868,
      0,
      1,
      NULL,
      23.591045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846369,
      0,
      0.498132,
      2,
      0,
      1,
      0,
      NULL,
      0,
      1.865857,
      NULL,
      NULL,
      3,
      0,
      0,
      0.992067,
      0.161726,
      1.861725,
      1.432626,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      3.822103,
      NULL,
      1.098612,
      0.000970,
      4.457365,
      1,
      5.196624,
      0,
      0,
      NULL,
      NULL,
      3.018240,
      0,
      1.842590,
      25,
      3.083361,
      2,
      NULL,
      6.068457,
      6.741840,
      84.733141,
      1,
      NULL,
      2.448876,
      '00020',
      NULL,
      '',
      0.068161,
      '42120',
      '',
      '',
      1,
      '2114',
      '',
      NULL,
      0,
      34.891223,
      NULL,
      18.785249,
      1.876801,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.102077,
      NULL,
      NULL,
      1.597794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.612700,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.327882,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.802702,
      NULL,
      NULL,
      1.718948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406682,
      NULL,
      NULL,
      0.567926,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.262374,
      NULL,
      NULL,
      1.308258,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.384704,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.243718,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.159330,
      NULL,
      NULL,
      1.979106,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.708496,
      NULL,
      NULL,
      0.276687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739041,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.964104,
      2,
      1.183371,
      NULL,
      NULL,
      1.929125,
      NULL,
      2,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.432642,
      5.723330,
      4,
      0.668871,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.274944,
      0.096163,
      1.736065,
      1,
      NULL,
      1.516368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.573599,
      NULL,
      1.738311,
      0.180505,
      0.437242,
      0,
      0.406065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.762530,
      0,
      2.433799,
      0,
      1,
      0,
      NULL,
      NULL,
      1.050680,
      NULL,
      0.017016,
      1.568596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883888,
      NULL,
      1,
      782.014936,
      5.848713,
      0,
      1.714801,
      NULL,
      1,
      0.397379,
      0.410587,
      NULL,
      1,
      0.967777,
      0,
      0,
      NULL,
      1.080983,
      1.198594,
      1.062149,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.325585,
      0.342593,
      1.352503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.482610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.613157,
      NULL,
      3.022516,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.089095,
      0.679447,
      3.468826,
      9.537123,
      8,
      1.246259,
      NULL,
      NULL,
      NULL,
      0.147117,
      NULL,
      0,
      0.592965,
      NULL,
      0.982995,
      2,
      3.021177,
      NULL,
      1,
      2.089734,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012038,
      1.481164,
      NULL,
      1.010781,
      0.767353,
      NULL,
      2,
      2.509666,
      NULL,
      1,
      0.830051,
      NULL,
      1,
      1.839231,
      NULL,
      0.530658,
      1.954572,
      NULL,
      0.113448,
      1,
      NULL,
      0.455111,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.598082,
      NULL,
      0.201516,
      NULL,
      0.222822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      83.867335,
      NULL,
      1,
      NULL,
      '12004',
      '03332',
      '',
      0.411857,
      '13313',
      '',
      '',
      3,
      '0040',
      '',
      NULL);
commit;
end;
/


