set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018848';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1010032',
      2,
      0.733581,
      2,
      1,
      NULL,
      3,
      0.939221,
      NULL,
      NULL,
      ' 1-23-1977',
      41.915421,
      NULL,
      NULL,
      2,
      0.296066,
      ' 9-28-2001',
      33.303152,
      NULL,
      88.368489,
      142,
      2.405519,
      ' 0-12-2000',
      ' 4- 8-1993',
      '10-11-1977',
      NULL,
      3.896872,
      2,
      0.875211,
      0,
      NULL,
      1,
      0,
      1.796428,
      NULL,
      10.590872,
      15,
      2.265020,
      NULL,
      37,
      0,
      22,
      1,
      4,
      2.950158,
      1,
      NULL,
      1,
      1.193235,
      1,
      1.439482,
      1.476252,
      0.672703,
      0.674931,
      NULL,
      0.994385,
      1,
      2,
      2,
      2,
      1,
      1,
      0,
      0,
      1.107554,
      0.677210,
      1.497339,
      0,
      0,
      0.582593,
      1.881699,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.323604,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.037115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.681578,
      1.936442,
      NULL,
      NULL,
      0.084103,
      0,
      1.662275,
      1.307278,
      3,
      1,
      1.244940,
      1.299423,
      1.081202,
      0.382540,
      0.389463,
      1.781364,
      1.422200,
      2.498645,
      2.338719,
      3.232574,
      0.520319,
      0,
      1,
      1.900303,
      1,
      0,
      0.019757,
      0,
      0,
      3.139522,
      NULL,
      NULL,
      1.624273,
      1,
      0.070769,
      NULL,
      1,
      0,
      7.760645,
      0,
      1,
      5.828308,
      5,
      1.893852,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.510215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1.135097,
      1,
      1.933594,
      1.391250,
      0,
      1.578698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.312180,
      NULL,
      2.476027,
      1.295811,
      1.330429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023091,
      0,
      0.735774,
      NULL,
      NULL,
      NULL,
      0.132035,
      1.587074,
      1,
      0,
      1,
      5.800901,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.535570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.041175,
      1,
      1.450195,
      1,
      1.609727,
      0,
      34.035561,
      1,
      3,
      16.311746,
      NULL,
      82.637915,
      2.507555,
      0.394562,
      0,
      NULL,
      0,
      3,
      0,
      2.788164,
      2.219526,
      2,
      2.332734,
      1,
      3.735300,
      3,
      0,
      1,
      NULL,
      0.244289,
      1,
      1.138824,
      1.040233,
      1,
      0,
      0.044282,
      0,
      NULL,
      1.385727,
      1,
      0,
      1.016060,
      3.411720,
      1,
      8.948865,
      10.356689,
      2,
      2.473072,
      9.714024,
      0,
      5.907394,
      0.219117,
      2,
      3,
      NULL,
      0,
      57,
      0.448677,
      1,
      NULL,
      NULL,
      51.097305,
      73.020432,
      5,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.705834,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2.204867,
      4.368070,
      65,
      37,
      2,
      40,
      4.259953,
      2,
      1,
      0.948653,
      1.636995,
      1.561049,
      1,
      NULL,
      NULL,
      1.216616,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.755338,
      NULL,
      NULL,
      0,
      1,
      0.211608,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.968696,
      0.482719,
      0.859917,
      NULL,
      NULL,
      2.852410,
      1.821424,
      0,
      1,
      0.903614,
      1.480678,
      1.999709,
      0.051664,
      NULL,
      NULL,
      NULL,
      1.499978,
      NULL,
      NULL,
      NULL,
      1.130331,
      0.823380,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.912659,
      1,
      1,
      1,
      0.782116,
      0,
      1,
      0.975998,
      0.097915,
      0.179937,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.877630,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.992466,
      0,
      1,
      1.783846,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.477106,
      NULL,
      NULL,
      0.425210,
      1.880872,
      0,
      0.904059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.524821,
      1,
      1,
      0,
      0,
      1.508628,
      0.672260,
      1,
      6.220678,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.211559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.234167,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.717983,
      NULL,
      NULL,
      NULL,
      1.151874,
      1.960232,
      NULL,
      NULL,
      0,
      3.784592,
      NULL,
      NULL,
      NULL,
      2.238679,
      0,
      0,
      3.382018,
      2,
      3.268443,
      NULL,
      0,
      2.877500,
      0.432942,
      2,
      4.482410,
      NULL,
      NULL,
      1,
      0.634596,
      5,
      3.516607,
      3,
      3,
      1.113232,
      1,
      0.963535,
      0,
      1,
      2.999465,
      NULL,
      NULL,
      2.990013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.510632,
      NULL,
      NULL,
      1.169457,
      NULL,
      NULL,
      3.269034,
      2.910481,
      1.617999,
      1.436853,
      0.798496,
      3.517531,
      0,
      NULL,
      NULL,
      6,
      5.827001,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.512357,
      1.821968,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.252295,
      1.634422,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.941243,
      NULL,
      NULL,
      NULL,
      1.256290,
      0.154775,
      NULL,
      NULL,
      0.005319,
      0,
      NULL,
      NULL,
      0.370393,
      1.092689,
      NULL,
      NULL,
      NULL,
      0.019753,
      NULL,
      NULL,
      1,
      0.027585,
      NULL,
      NULL,
      0,
      0.128273,
      NULL,
      NULL,
      1.640607,
      1.520364,
      NULL,
      NULL,
      0.136819,
      1,
      NULL,
      NULL,
      2.467257,
      2.835405,
      NULL,
      NULL,
      1.022578,
      NULL,
      NULL,
      NULL,
      0.226502,
      NULL,
      3,
      1.071895,
      NULL,
      NULL,
      1.814434,
      NULL,
      NULL,
      0,
      NULL,
      1.857584,
      1.856368,
      NULL,
      NULL,
      0.572228,
      NULL,
      NULL,
      1,
      NULL,
      0.916800,
      399,
      14.404581,
      1.179398,
      NULL,
      1.903833,
      NULL,
      NULL,
      NULL,
      1,
      0.127756,
      1.775329,
      0,
      1,
      0,
      NULL,
      1.669660,
      0.632244,
      1.029214,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481561,
      1.624641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153258,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.806269,
      1.241788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.804835,
      0.288220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.489579,
      NULL,
      2.610783,
      NULL,
      170.254053,
      NULL,
      NULL,
      NULL,
      1.645642,
      NULL,
      1,
      1,
      0,
      17,
      14,
      1,
      NULL,
      NULL,
      NULL,
      0.255306,
      0.729365,
      0.817776,
      0.197741,
      2.672694,
      0,
      2,
      1,
      4.013145,
      2.768090,
      2.935183,
      0,
      1,
      NULL,
      NULL,
      0,
      1.636469,
      1.877487,
      NULL,
      0.371730,
      1,
      0,
      0.204014,
      1.439115,
      1.260231,
      NULL,
      1.814027,
      1,
      0.738174,
      1.609160,
      0.166892,
      NULL,
      1,
      1,
      NULL,
      0.172325,
      1.492628,
      0,
      NULL,
      3,
      1.063481,
      1.596801,
      0.444693,
      0.121880,
      0,
      1,
      1.765764,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.401751,
      0,
      NULL,
      0.626815,
      1.031083,
      2,
      0.413805,
      NULL,
      NULL,
      50.376986,
      138.814460,
      NULL,
      2.807478,
      2,
      '44030',
      '',
      NULL,
      1,
      '32010',
      '',
      '',
      NULL,
      '1402',
      NULL,
      '');
commit;
end;
/


