set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8829507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      NULL,
      '3422003',
      NULL,
      1.400548,
      4,
      2,
      '1234',
      2.653399,
      0.487236,
      NULL,
      NULL,
      '11-29-1978',
      25,
      NULL,
      0,
      1,
      3.793333,
      ' 2-10-1984',
      23.913988,
      2,
      90.288351,
      32.028174,
      1.106203,
      ' 5- 6-1985',
      ' 4-13-1976',
      ' 5-19-1981',
      3.424664,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0.534611,
      1.199295,
      12,
      11.265842,
      12,
      1,
      5,
      6,
      NULL,
      0.168155,
      NULL,
      3,
      11.684596,
      0,
      1,
      0.525127,
      0,
      1,
      1,
      1.995946,
      NULL,
      1,
      NULL,
      1.264404,
      2.754894,
      4.366332,
      NULL,
      0,
      4.717579,
      1.568281,
      NULL,
      0.245763,
      2.105216,
      1,
      0,
      7.509327,
      5,
      5,
      3,
      0,
      2.252268,
      1.556310,
      5.462350,
      2,
      1,
      0.685467,
      NULL,
      NULL,
      3,
      2.529913,
      4.317853,
      10,
      1,
      0.443159,
      1.374034,
      0,
      2.667108,
      1.526434,
      1.393927,
      0,
      2.133892,
      2.558719,
      1,
      NULL,
      0.050440,
      3.070706,
      2,
      NULL,
      1.340326,
      1,
      0.866538,
      1.804546,
      0,
      2.588381,
      1,
      5,
      0,
      1.847705,
      NULL,
      NULL,
      3.126733,
      2.755254,
      2,
      1,
      1.248555,
      1.265722,
      0,
      1,
      1,
      0,
      0,
      1.057363,
      0.233213,
      1,
      3.485708,
      0.412489,
      3,
      0.841253,
      0,
      1.254374,
      0,
      0,
      NULL,
      0,
      4,
      0,
      NULL,
      1.348709,
      0.178896,
      0,
      7.069011,
      5.602706,
      4.732086,
      5,
      2.990639,
      NULL,
      2,
      0,
      1.404602,
      NULL,
      6,
      3,
      NULL,
      1.977072,
      6,
      8,
      7,
      4,
      1.389216,
      2,
      1,
      ' 8- 5-1984',
      NULL,
      ' 5-15-1995',
      1.518071,
      1,
      1.235386,
      0.831042,
      0,
      0.087157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.054017,
      1,
      5.303144,
      NULL,
      0.624618,
      NULL,
      0.271303,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      0.999547,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.192953,
      3.675506,
      1.021759,
      NULL,
      0,
      6,
      1.401247,
      1.317392,
      NULL,
      NULL,
      2,
      10,
      3,
      5,
      7,
      4.185224,
      0,
      '11-25-1997',
      NULL,
      ' 3-18-1990',
      20,
      0,
      0,
      0.285860,
      0.576661,
      0.084274,
      0.335311,
      1.472823,
      1,
      1.298916,
      NULL,
      NULL,
      91,
      NULL,
      0.785577,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.922924,
      0,
      NULL,
      NULL,
      0,
      3,
      2.841807,
      3,
      2.362765,
      1.782420,
      3.986952,
      0,
      2,
      2.235207,
      1.223287,
      0,
      NULL,
      4.179933,
      3,
      1,
      NULL,
      0,
      0,
      1.950871,
      0.624470,
      0,
      0,
      3.205810,
      0.712332,
      NULL,
      8,
      NULL,
      1,
      1.703496,
      8,
      1.770481,
      2,
      2,
      7,
      1,
      1.245144,
      NULL,
      62.419813,
      1,
      2,
      NULL,
      2,
      28,
      51.087315,
      NULL,
      1,
      0,
      '43323',
      '',
      '',
      3,
      '23400',
      '',
      '',
      1,
      '',
      '',
      '',
      1.908196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.160985,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.138182,
      NULL,
      NULL,
      NULL,
      0.502231,
      0,
      0.311672,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.441119,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      0.463944,
      NULL,
      0,
      NULL,
      0.361301,
      NULL,
      0.100370,
      1.860947,
      NULL,
      0.786733,
      NULL,
      0.577412,
      1.704854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.538823,
      3,
      NULL,
      5.118343,
      6.251613,
      3.202332,
      1.122385,
      2.318532,
      15,
      1,
      3.562820,
      NULL,
      NULL,
      0.228878,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.920184,
      NULL,
      2,
      0.323119,
      NULL,
      1.826651,
      1.641380,
      NULL,
      1,
      0,
      NULL,
      2,
      1.180605,
      NULL,
      3.431838,
      1,
      NULL,
      0,
      0.584949,
      NULL,
      0.637348,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.731965,
      0.127557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.724447,
      NULL,
      0.231798,
      NULL,
      3,
      NULL,
      1.362790,
      NULL,
      3.384980,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.281328,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      12,
      NULL,
      NULL,
      1.779189,
      NULL,
      1.511722,
      NULL,
      0.592862,
      NULL,
      NULL,
      1.002504,
      9,
      NULL,
      NULL,
      NULL,
      9,
      0.084347,
      4,
      NULL,
      3.722292,
      '32414',
      '',
      NULL,
      2,
      '04421',
      '',
      NULL,
      1.153934,
      '',
      '',
      NULL);
commit;
end;
/


