set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8101660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      '3240',
      1.722354,
      1,
      2,
      11.917972,
      ' 8-12-1999',
      7,
      NULL,
      NULL,
      2,
      0,
      ' 7- 3-1997',
      NULL,
      1,
      2,
      13,
      4.280363,
      NULL,
      NULL,
      ' 4-20-1982',
      NULL,
      0,
      1.055987,
      0.052104,
      1.569115,
      1,
      2,
      1.723246,
      1,
      67.088636,
      7.677040,
      6.643236,
      15.337956,
      25,
      3.091627,
      7.858962,
      22.641407,
      5.617400,
      11,
      NULL,
      0,
      NULL,
      0.260884,
      0,
      0.902015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.140256,
      NULL,
      2,
      3,
      0,
      NULL,
      0,
      2.899428,
      NULL,
      0.235098,
      0,
      1,
      1.248254,
      0,
      1.149832,
      NULL,
      0,
      1,
      NULL,
      0,
      1.866291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.661742,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670989,
      NULL,
      NULL,
      0.333202,
      0,
      1,
      0.598993,
      NULL,
      0.654885,
      0.975677,
      0,
      0.882907,
      1,
      1,
      1.851862,
      NULL,
      1.769457,
      NULL,
      0.702744,
      NULL,
      1.903037,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.945585,
      1.836767,
      1,
      1,
      0.661862,
      0,
      0,
      0,
      0,
      0,
      8,
      0.412318,
      3,
      0,
      3,
      4,
      0.669509,
      NULL,
      0.481239,
      NULL,
      0,
      NULL,
      244,
      ' 7- 6-1977',
      161,
      2.910961,
      NULL,
      1.298608,
      2.035552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.286428,
      0.073885,
      NULL,
      0.031884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.625006,
      2.300394,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.423834,
      2.886083,
      1,
      1.668511,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.907801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.181633,
      0,
      0.931508,
      1,
      1.552156,
      1,
      1,
      1.244841,
      NULL,
      0.375525,
      1.892904,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.615972,
      3.370479,
      2.303880,
      3,
      1.796286,
      1,
      NULL,
      0.495054,
      NULL,
      3,
      1.115158,
      1.593429,
      3.604958,
      5,
      0.663473,
      1.557938,
      6.698628,
      0.175839,
      0.554470,
      0,
      1,
      NULL,
      0,
      0.665468,
      NULL,
      NULL,
      NULL,
      1,
      0.289426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      16,
      NULL,
      NULL,
      NULL,
      2,
      0.150639,
      0,
      '23040',
      '',
      NULL,
      1.502751,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2.335355,
      15,
      11,
      21.760815,
      0.329958,
      25.270830,
      7.191023,
      3.284624,
      0.605883,
      0,
      5.716155,
      6,
      NULL,
      NULL,
      NULL,
      1.462936,
      NULL,
      NULL,
      1.590548,
      3,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791563,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.189810,
      5.719448,
      0,
      0.591235,
      0.123432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175086,
      NULL,
      NULL,
      1.896499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.524326,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.523517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.191063,
      0.125500,
      NULL,
      3,
      3,
      8.556557,
      1.765685,
      1.404861,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      3,
      1.476284,
      NULL,
      0.097104,
      1,
      0.338201,
      17.949607,
      1,
      5,
      1.851193,
      NULL,
      NULL,
      NULL,
      1.399412,
      NULL,
      NULL,
      0.499354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.389408,
      13,
      1.702046,
      NULL,
      NULL,
      0,
      NULL,
      0.813663,
      0,
      NULL,
      NULL,
      3.044693,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246100,
      1.051820,
      3.584399,
      NULL,
      10.699807,
      4.475862,
      4,
      6.905052,
      5,
      15,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.131345,
      8,
      8.071054,
      8.265328,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      1.672680,
      1,
      NULL,
      NULL,
      3.515644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606458,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.125149,
      NULL,
      NULL,
      3.331813,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.944987,
      NULL,
      NULL,
      0.711361,
      1.003353,
      1.463785,
      0,
      1,
      1.667655,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.211208,
      NULL,
      NULL,
      NULL,
      2.273196,
      NULL,
      NULL,
      NULL,
      16.872753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.347722,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.104789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.976026,
      30.422992,
      NULL,
      1,
      NULL,
      NULL,
      0.819834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.293842,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3417.048507,
      96,
      1,
      0,
      0,
      1.470143,
      0,
      0.232843,
      1.500482,
      NULL,
      0.212958,
      NULL,
      1,
      0.590207,
      1.920502,
      0,
      0.906495,
      1.789644,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      11,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      16.935102,
      17.943472,
      NULL,
      0.581259,
      4.708697,
      NULL,
      15,
      9,
      NULL,
      3,
      12.722682,
      NULL,
      0.492612,
      0.686154,
      NULL,
      6.639528,
      0.397986,
      NULL,
      NULL,
      0.185879,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.608574,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994973,
      NULL,
      0.326731,
      NULL,
      1,
      NULL,
      0,
      9.279844,
      7.014675,
      1,
      0,
      3,
      11.545638,
      NULL,
      2.436797,
      0.621363,
      0,
      NULL,
      '',
      NULL,
      1.916075,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '');
commit;
end;
/


