set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-8-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04',
      '13',
      11,
      24,
      '3333410',
      2.881392,
      1,
      4,
      0,
      '0311',
      NULL,
      1,
      NULL,
      NULL,
      ' 6-18-1999',
      NULL,
      44,
      NULL,
      NULL,
      0,
      ' 0-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10- 4-2000',
      ' 2-11-1974',
      ' 6- 7-1984',
      1,
      1,
      0.100036,
      1,
      NULL,
      1.327281,
      1.472669,
      1,
      0.491275,
      12.894633,
      7.527619,
      2.177809,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      0.611696,
      1.909771,
      1,
      NULL,
      NULL,
      1.289777,
      0,
      NULL,
      3,
      1,
      NULL,
      2.546022,
      1.016542,
      0,
      3.127553,
      NULL,
      NULL,
      NULL,
      3,
      0.633938,
      4.646752,
      1.038774,
      3.179742,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.801827,
      NULL,
      NULL,
      2,
      1,
      1,
      1.885169,
      0,
      0.148033,
      2.882093,
      0.049977,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.044835,
      3.151239,
      3.880294,
      0.851220,
      1,
      4,
      NULL,
      1,
      1.966197,
      1.856555,
      1.584896,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703455,
      1.702640,
      1.114732,
      0,
      0.579954,
      0,
      NULL,
      1.304913,
      0,
      0,
      1.212464,
      0.192153,
      1,
      NULL,
      0.143042,
      0.511871,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685652,
      5,
      1,
      2.391571,
      6.363631,
      0.505023,
      1,
      NULL,
      1.719057,
      0.924594,
      7.110978,
      NULL,
      4,
      8.451421,
      5.243051,
      NULL,
      NULL,
      2,
      NULL,
      1.058830,
      2,
      1.029525,
      ' 1-19-1992',
      177,
      ' 0- 6-1982',
      1.225027,
      0.257699,
      1.032658,
      NULL,
      0.054823,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205214,
      1.621132,
      2.380004,
      0.235738,
      1.693269,
      1.503984,
      NULL,
      0.042243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.311001,
      0,
      3.696332,
      NULL,
      NULL,
      1.343471,
      NULL,
      3.398636,
      NULL,
      NULL,
      NULL,
      4.823530,
      1.697369,
      NULL,
      NULL,
      1.250800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.610074,
      0,
      1,
      1.768081,
      NULL,
      0.982296,
      1,
      13.380234,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.247096,
      0,
      NULL,
      1,
      NULL,
      1,
      0.430542,
      1,
      NULL,
      2,
      1.805896,
      3.440676,
      1,
      NULL,
      NULL,
      1.570762,
      1.924200,
      NULL,
      0.566139,
      0.609658,
      0.711497,
      1,
      0,
      0,
      1.926875,
      0.118421,
      NULL,
      2,
      0,
      9.613889,
      9.380025,
      0,
      3.851401,
      0,
      NULL,
      2.581143,
      3.693209,
      NULL,
      1.696952,
      3,
      1.680589,
      58.765406,
      1,
      NULL,
      30.047989,
      NULL,
      NULL,
      NULL,
      4.297959,
      2,
      NULL,
      NULL,
      '11420',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      3,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.232109,
      1,
      NULL,
      0.072659,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.296177,
      NULL,
      1,
      197.600990,
      3.699720,
      2.222226,
      1,
      NULL,
      NULL,
      0.593528,
      0.346585,
      0.826729,
      0.151573,
      0.247468,
      0.814422,
      1.777540,
      1,
      NULL,
      0,
      1,
      0,
      3,
      1,
      0.348436,
      NULL,
      0.935107,
      NULL,
      0,
      NULL,
      1.561185,
      NULL,
      3.548832,
      NULL,
      53.180165,
      NULL,
      3.675558,
      NULL,
      3.370716,
      NULL,
      NULL,
      1,
      NULL,
      1.891115,
      NULL,
      1.606469,
      NULL,
      0,
      NULL,
      1.694591,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.831400,
      NULL,
      NULL,
      NULL,
      1.306099,
      NULL,
      NULL,
      NULL,
      0.636561,
      NULL,
      1.120524,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.350951,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508637,
      1.130490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.715936,
      1.000706,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.363992,
      NULL,
      0,
      NULL,
      0.837660,
      NULL,
      1.693326,
      NULL,
      1,
      1.353422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.294302,
      NULL,
      2,
      NULL,
      1.503992,
      NULL,
      293,
      NULL,
      3.110725,
      NULL,
      1,
      0,
      2,
      NULL,
      3,
      NULL,
      60.723862,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.689714,
      3,
      1.395110,
      0,
      0.337649,
      2,
      3.523007,
      3,
      0,
      3,
      0,
      0,
      1,
      NULL,
      0,
      1.042277,
      NULL,
      1,
      1.779703,
      NULL,
      0.833124,
      1.090982,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.317557,
      NULL,
      0,
      0.701811,
      NULL,
      1.162116,
      NULL,
      NULL,
      1.729414,
      3.194741,
      NULL,
      0,
      1,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.706031,
      NULL,
      1.036566,
      NULL,
      0.739337,
      NULL,
      0,
      5.883995,
      2.531148,
      1.597905,
      NULL,
      NULL,
      11,
      24,
      0.585233,
      5.471740,
      4,
      NULL,
      NULL,
      '',
      1.653816,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


