set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9803416';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.564558,
      4,
      5,
      2.533221,
      2.308624,
      1,
      3,
      0,
      '433',
      '10444432',
      7.171036,
      2,
      '4313120',
      2.948682,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.388901,
      NULL,
      NULL,
      NULL,
      20,
      51,
      NULL,
      0.041576,
      1,
      ' 8- 8-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0.088454,
      NULL,
      NULL,
      ' 8-26-1986',
      2,
      0.587047,
      NULL,
      0.493782,
      0.442046,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      11.142289,
      0.298583,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.729126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.270396,
      NULL,
      15,
      3,
      7.199692,
      1.235614,
      0.274194,
      NULL,
      0,
      1.210114,
      8.577559,
      NULL,
      NULL,
      1,
      0,
      1.211960,
      8,
      1.894795,
      NULL,
      1.765259,
      0,
      1.521159,
      NULL,
      NULL,
      1.716832,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866257,
      0,
      1,
      2,
      0,
      2,
      1.113828,
      1,
      NULL,
      NULL,
      1.337993,
      NULL,
      NULL,
      1,
      0.240933,
      0.454930,
      0,
      NULL,
      0.608491,
      2,
      1.596376,
      0.381464,
      0.138137,
      1.491896,
      1.104706,
      1,
      0,
      0,
      NULL,
      1,
      1.124850,
      1.008977,
      NULL,
      0.145065,
      1.679742,
      0.801899,
      0.549183,
      NULL,
      0,
      0,
      1,
      1,
      0.307093,
      1.782028,
      2,
      NULL,
      0.293861,
      1,
      0,
      NULL,
      1.096783,
      3,
      5.253964,
      NULL,
      3,
      0.924772,
      NULL,
      3,
      0,
      5,
      3,
      NULL,
      NULL,
      ' 3-25-1992',
      3,
      2,
      2.283139,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.166961,
      2,
      1.635323,
      1.917211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.399578,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038700,
      NULL,
      1.585448,
      0,
      2,
      3.915654,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      4,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1.619989,
      0.374985,
      0.297921,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.623107,
      2.823945,
      0.013119,
      3.218224,
      1,
      2,
      3.959996,
      0.050261,
      2.057025,
      2.616000,
      2,
      1.953730,
      3,
      NULL,
      0,
      NULL,
      1.963421,
      NULL,
      1.410677,
      0.230152,
      1.008215,
      0.048123,
      1.325951,
      NULL,
      NULL,
      NULL,
      1.240830,
      NULL,
      0,
      NULL,
      0.601070,
      1.127118,
      5,
      10.419622,
      NULL,
      2,
      0.067134,
      2,
      NULL,
      NULL,
      NULL,
      67,
      0.225851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.503234,
      3,
      '20121',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.913185,
      NULL,
      NULL,
      '',
      3.681764,
      32,
      NULL,
      19.155975,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.224156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.555207,
      1,
      NULL,
      NULL,
      1.924493,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.859632,
      0.268594,
      NULL,
      0.134176,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.917361,
      NULL,
      NULL,
      NULL,
      2,
      1.079624,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.009367,
      NULL,
      NULL,
      0.295056,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.925499,
      NULL,
      NULL,
      0.072547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906003,
      NULL,
      0,
      3,
      NULL,
      1.635838,
      0,
      5.908645,
      1,
      NULL,
      1,
      1.724667,
      1.797277,
      NULL,
      NULL,
      1.918744,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.551016,
      2,
      1,
      1.461954,
      NULL,
      0.763310,
      1.158696,
      NULL,
      1,
      3.230963,
      0,
      3.884509,
      1,
      2.047591,
      2,
      NULL,
      NULL,
      1,
      3.755234,
      NULL,
      0,
      7.990625,
      NULL,
      0.323296,
      NULL,
      NULL,
      NULL,
      1.206861,
      NULL,
      0.807843,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.576559,
      NULL,
      1.139854,
      0.567671,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397725,
      NULL,
      NULL,
      0.175259,
      NULL,
      NULL,
      1.544445,
      NULL,
      NULL,
      1.124812,
      NULL,
      NULL,
      1.948117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869423,
      NULL,
      0.292479,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0.790506,
      1,
      1.918037,
      0.512346,
      1.114261,
      1,
      1,
      1.211384,
      1.636979,
      1.383651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.687320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.771231,
      NULL,
      5,
      0.895533,
      2.822892,
      2,
      3,
      7,
      NULL,
      0.876612,
      0,
      1,
      0.207626,
      NULL,
      0,
      0.328199,
      NULL,
      NULL,
      1.178306,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.398753,
      NULL,
      1,
      1.987489,
      NULL,
      0,
      0,
      NULL,
      0.893601,
      0.071735,
      NULL,
      NULL,
      1.800704,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      0.626248,
      NULL,
      NULL,
      68.204566,
      23.955619,
      0,
      5,
      3.825699,
      '00403',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


