set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000225';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      '1232243',
      1,
      0.781082,
      3,
      2,
      '3314',
      1,
      NULL,
      NULL,
      43.343166,
      '11- 6-1995',
      2,
      NULL,
      2.459528,
      NULL,
      0,
      ' 0- 8-2000',
      33,
      0,
      124.301771,
      67,
      3,
      NULL,
      NULL,
      ' 6-11-1974',
      2.815212,
      1,
      1.526412,
      0,
      0,
      NULL,
      2.656188,
      1.170129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.434716,
      3.381086,
      NULL,
      15,
      0.406854,
      5,
      NULL,
      1.583878,
      1,
      1,
      1,
      1.117726,
      1,
      0,
      NULL,
      1.401950,
      0,
      0.430090,
      4.047516,
      1,
      0,
      3,
      1.284755,
      1,
      5.071979,
      1.553093,
      1.104541,
      NULL,
      1,
      1,
      1,
      1,
      0.667012,
      0,
      2.177283,
      1,
      4.900959,
      1.005808,
      0,
      1.794425,
      NULL,
      NULL,
      1.736827,
      NULL,
      NULL,
      1.629266,
      0,
      1.624624,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.905506,
      0.382745,
      NULL,
      0,
      4,
      1,
      3,
      0,
      1,
      2,
      0.651386,
      3,
      0,
      0.892201,
      0.043400,
      0,
      0.668139,
      1,
      1,
      NULL,
      1.848760,
      1,
      1.697466,
      3,
      0.802461,
      0.713273,
      1,
      4.981112,
      1.211222,
      1,
      2,
      0.596848,
      NULL,
      NULL,
      1.831784,
      9,
      2.084179,
      5.038012,
      7.853302,
      0,
      NULL,
      NULL,
      5.134645,
      NULL,
      0,
      8,
      3,
      0.139775,
      ' 2-19-1976',
      260.645983,
      ' 8- 0-1993',
      42,
      3,
      0.262016,
      NULL,
      1.151505,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959068,
      0.033487,
      1,
      0,
      NULL,
      0,
      0,
      0.882898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360104,
      NULL,
      NULL,
      NULL,
      NULL,
      1.727414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.800089,
      NULL,
      NULL,
      NULL,
      0.835589,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.034449,
      0.692446,
      1,
      1.240361,
      0.445847,
      NULL,
      1,
      NULL,
      0.875207,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165861,
      2.851218,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1.967218,
      NULL,
      NULL,
      2,
      NULL,
      1.433029,
      3,
      2.146604,
      NULL,
      1.350519,
      0.515911,
      NULL,
      0.582963,
      NULL,
      0,
      0.656162,
      NULL,
      0,
      1,
      1.837023,
      1,
      NULL,
      2,
      1.687539,
      9,
      1,
      5.824173,
      0,
      10,
      5.282013,
      1,
      0.007275,
      NULL,
      NULL,
      1.440854,
      3,
      2.470328,
      1,
      1.284663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.406485,
      '11043',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.081333,
      '',
      '',
      '',
      2.358103,
      35.046921,
      89,
      42.710370,
      1,
      22,
      2.816381,
      NULL,
      2,
      0,
      0.086879,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.212393,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2.102385,
      NULL,
      NULL,
      NULL,
      NULL,
      2.170856,
      1.630530,
      NULL,
      NULL,
      NULL,
      1.511078,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      1,
      0.799091,
      NULL,
      NULL,
      2,
      3,
      7.416934,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.898803,
      NULL,
      NULL,
      NULL,
      0.271927,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.033128,
      NULL,
      NULL,
      1.920411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.281996,
      0.052291,
      3.682262,
      2,
      1.774873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      2.357498,
      0,
      2.840433,
      1.310642,
      NULL,
      NULL,
      4,
      4.865553,
      4.999874,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.796019,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.805694,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.681473,
      3,
      1.516981,
      6,
      5.562259,
      4.357373,
      1,
      3,
      3.682800,
      NULL,
      2.419605,
      NULL,
      1.042377,
      0,
      3,
      NULL,
      NULL,
      3.766453,
      2,
      3.673927,
      3.488700,
      1,
      NULL,
      1.338419,
      1,
      2.715717,
      NULL,
      0,
      1.974804,
      3.765673,
      NULL,
      2.133434,
      7.613188,
      3.408297,
      8.794288,
      4,
      1.894476,
      NULL,
      5,
      NULL,
      1.851721,
      NULL,
      0,
      NULL,
      3.413477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292753,
      NULL,
      NULL,
      1.516460,
      NULL,
      NULL,
      1.383000,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.422053,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.332191,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.229105,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.483418,
      1.778761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.570310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828315,
      1.190159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.812880,
      0.251144,
      NULL,
      NULL,
      2.384349,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.518259,
      2.509185,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      9,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.032651,
      NULL,
      1,
      NULL,
      0.895577,
      NULL,
      1.618961,
      1.265631,
      NULL,
      0,
      1,
      NULL,
      1.513350,
      NULL,
      0.921424,
      NULL,
      1,
      1,
      0.563389,
      1.556782,
      1,
      1.691134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.092003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.246929,
      1.282062,
      5,
      3.903006,
      NULL,
      3,
      12,
      1.558918,
      2,
      2,
      0,
      NULL,
      0.040105,
      1.626222,
      1,
      3.375993,
      0.829091,
      NULL,
      0.286257,
      0.805250,
      1,
      0.885649,
      0.067466,
      NULL,
      1,
      0,
      1.660327,
      2,
      2,
      0,
      2.117566,
      0.850774,
      3,
      NULL,
      0,
      2.382719,
      0,
      0.548412,
      0,
      0.067605,
      0.974389,
      3.122248,
      1,
      NULL,
      NULL,
      0.018501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.151161,
      1,
      1.481896,
      0,
      0.072097,
      0,
      2,
      11.736819,
      3,
      1.947420,
      NULL,
      96.697691,
      51,
      2,
      1.713677,
      1.870475,
      '24134',
      '',
      '',
      2,
      '43130',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


