set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9846199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      8,
      1,
      0,
      NULL,
      2.106055,
      NULL,
      4.592786,
      2.578995,
      '232',
      NULL,
      87,
      67,
      '1031044',
      0.029428,
      0,
      2,
      2,
      NULL,
      2,
      0.883285,
      NULL,
      NULL,
      ' 2-23-1990',
      31,
      NULL,
      NULL,
      0.520300,
      0.574883,
      ' 4- 0-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 8-1986',
      NULL,
      ' 2- 5-1994',
      2,
      1,
      2.806859,
      0.858324,
      1,
      1.524954,
      4.702985,
      0.125251,
      NULL,
      NULL,
      NULL,
      10.047351,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      8.084125,
      3.731203,
      NULL,
      NULL,
      6,
      0.647934,
      0.017438,
      1.351473,
      0,
      NULL,
      1.243603,
      NULL,
      1.808704,
      NULL,
      0,
      NULL,
      3.299888,
      3.662084,
      5,
      0,
      1.620425,
      NULL,
      0,
      5,
      6,
      0,
      1,
      NULL,
      0.107248,
      NULL,
      5,
      NULL,
      NULL,
      3.878223,
      0.673000,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.634763,
      1,
      0.961611,
      1.819689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104957,
      1,
      1.741070,
      1.340546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105876,
      1.884490,
      NULL,
      NULL,
      0,
      2.388019,
      3,
      1,
      NULL,
      0.040078,
      0.893310,
      1,
      0,
      0.497787,
      0.499890,
      1.781581,
      1.943508,
      1,
      1,
      NULL,
      0.568138,
      NULL,
      1.053218,
      0.589096,
      5,
      7,
      2,
      5.749687,
      1.707747,
      0.120050,
      5.443028,
      4,
      2.634341,
      NULL,
      1,
      NULL,
      0,
      0.096448,
      NULL,
      1.910917,
      1,
      NULL,
      NULL,
      6,
      1,
      1.268486,
      NULL,
      3.623400,
      ' 3-22-1989',
      435,
      NULL,
      6.864914,
      NULL,
      NULL,
      1.432871,
      1.009473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.524961,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.979555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.075534,
      1.841501,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.310341,
      0.943767,
      1.978123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083030,
      NULL,
      0,
      0.057843,
      0.554874,
      0.911753,
      1.379774,
      NULL,
      24.261754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186049,
      1.048669,
      1,
      2.080642,
      NULL,
      5,
      4.199537,
      4.553810,
      NULL,
      NULL,
      3.418572,
      3,
      1.207760,
      NULL,
      NULL,
      3,
      NULL,
      0.581291,
      1,
      3.155717,
      0.420593,
      0.868952,
      NULL,
      3.272727,
      0,
      0,
      0,
      0,
      1.156763,
      NULL,
      3,
      0,
      0.094155,
      6.986685,
      3.200991,
      0,
      1,
      7.042386,
      NULL,
      2.199723,
      0,
      3,
      2,
      0,
      NULL,
      3,
      0,
      18.443397,
      NULL,
      61,
      28.377276,
      3,
      5,
      4,
      '31432',
      '44104',
      '',
      2,
      '03441',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      28.033267,
      40.001784,
      8,
      1.379235,
      NULL,
      1.311890,
      0.472203,
      3,
      1.272319,
      NULL,
      1.436671,
      0,
      0.373630,
      2.942341,
      1.462675,
      NULL,
      NULL,
      1.196563,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.759800,
      NULL,
      NULL,
      3.881731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.135872,
      2.951509,
      0,
      0.770179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.438973,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.251300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.206981,
      NULL,
      NULL,
      1.994416,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.713666,
      1,
      2.721388,
      0.986377,
      NULL,
      3.366207,
      0.106743,
      0.641467,
      2,
      2.053898,
      NULL,
      0,
      2.340228,
      3.711741,
      3.656928,
      1.548324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.050490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.232794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.948390,
      0,
      3.570793,
      0,
      NULL,
      NULL,
      7,
      3.966434,
      5,
      NULL,
      0.767897,
      1,
      2,
      NULL,
      3,
      1,
      1,
      3.279739,
      2,
      2,
      2.532308,
      7,
      0,
      3,
      NULL,
      2.257800,
      NULL,
      1,
      NULL,
      NULL,
      1.718692,
      1.463453,
      NULL,
      NULL,
      1.675083,
      1.762157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610269,
      1,
      0,
      0.645951,
      1.790173,
      1.588977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.357054,
      NULL,
      1,
      1,
      NULL,
      4,
      1.655003,
      NULL,
      NULL,
      3,
      0.948494,
      0,
      0.097574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      362.894595,
      2.193484,
      NULL,
      1,
      1.998601,
      NULL,
      NULL,
      0,
      1.401833,
      NULL,
      0,
      1.776203,
      NULL,
      0,
      1,
      1.030963,
      0,
      NULL,
      NULL,
      0.878725,
      NULL,
      0.702623,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2.287325,
      NULL,
      NULL,
      NULL,
      81,
      NULL,
      NULL,
      35,
      14.087581,
      NULL,
      0.445666,
      3,
      NULL,
      1.426357,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.107373,
      NULL,
      1.331621,
      NULL,
      0,
      NULL,
      0.552008,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.850698,
      NULL,
      0.519401,
      NULL,
      0.006001,
      NULL,
      1.778083,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.500868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.026051,
      NULL,
      1.531331,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      1.932264,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.155723,
      NULL,
      NULL,
      NULL,
      0.591344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673013,
      3.417497,
      3.160559,
      0,
      0,
      NULL,
      NULL,
      3.570434,
      7,
      3.050778,
      3,
      1,
      1,
      0.427068,
      NULL,
      NULL,
      2.228889,
      NULL,
      1,
      3,
      NULL,
      1.570953,
      0.234740,
      NULL,
      0,
      NULL,
      NULL,
      3.004485,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.534645,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      2.855236,
      0.268026,
      0.819581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.933187,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.270912,
      2,
      NULL,
      0,
      NULL,
      NULL,
      56,
      NULL,
      0.355016,
      3,
      4.243501,
      '20400',
      NULL,
      '',
      NULL,
      '02441',
      '',
      '',
      2,
      NULL,
      '',
      '');
commit;
end;
/


