set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3003100',
      2,
      1.440899,
      NULL,
      3,
      '1420',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 5-2003',
      NULL,
      NULL,
      2.565763,
      NULL,
      3,
      ' 7- 6-1974',
      36,
      2.763163,
      186,
      13,
      1.182576,
      '11-14-1975',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.530752,
      0.800390,
      1.039708,
      NULL,
      NULL,
      1.455465,
      NULL,
      6,
      2.280915,
      5.306543,
      16.809554,
      19,
      0,
      NULL,
      5.293060,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324398,
      3.656826,
      0.167852,
      1,
      0.479988,
      0.065067,
      NULL,
      1,
      NULL,
      7,
      1.987624,
      0.001480,
      NULL,
      1,
      0,
      1,
      2.600822,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.341172,
      NULL,
      0.197965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144960,
      1,
      8,
      NULL,
      0,
      0,
      1.165070,
      NULL,
      NULL,
      0.833079,
      NULL,
      NULL,
      NULL,
      0,
      0.508637,
      4.548016,
      NULL,
      1.695412,
      0,
      1,
      0.569231,
      1,
      0.492018,
      0.152840,
      0.507506,
      NULL,
      0,
      0,
      NULL,
      0.240348,
      1,
      NULL,
      0.214653,
      2.843648,
      0,
      0.602127,
      NULL,
      0,
      1,
      5,
      1.519530,
      5.114647,
      NULL,
      1,
      0.444839,
      0,
      NULL,
      3.621533,
      3.321181,
      5.789288,
      2.464940,
      0.025463,
      6,
      4,
      NULL,
      3.250025,
      1,
      2,
      3,
      1.759634,
      ' 3-23-1985',
      160,
      ' 7-18-1988',
      85.894971,
      0.109068,
      0.210307,
      1.571719,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      3,
      1.356197,
      5,
      NULL,
      1,
      NULL,
      1,
      1.541794,
      NULL,
      NULL,
      3,
      1,
      0,
      3.292506,
      0.033985,
      3,
      3.928195,
      6.820782,
      2.615006,
      8.338399,
      5,
      1.034781,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.411738,
      NULL,
      1.282711,
      0,
      1,
      1,
      0,
      NULL,
      0,
      3.787290,
      1,
      NULL,
      NULL,
      NULL,
      3.799685,
      1.222873,
      3.879445,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.136465,
      NULL,
      NULL,
      0.938071,
      0,
      NULL,
      1.697923,
      NULL,
      1,
      NULL,
      0.504002,
      0.453467,
      1.594831,
      1.291165,
      NULL,
      NULL,
      0,
      1,
      1.889168,
      1,
      4,
      1,
      9.480476,
      1.250658,
      1,
      6,
      5.078867,
      6,
      5,
      1,
      0.813927,
      0.903464,
      0.408481,
      3.035809,
      NULL,
      0,
      1.609058,
      NULL,
      54,
      59.965415,
      13,
      NULL,
      0,
      1.704255,
      '01422',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.593126,
      46,
      77.310150,
      28.264057,
      1.147348,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      1.495529,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.752713,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.269158,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.755797,
      1,
      NULL,
      2,
      3,
      NULL,
      1.174783,
      NULL,
      NULL,
      0.832605,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.565254,
      NULL,
      NULL,
      1.960315,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.103702,
      0.973855,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.394193,
      0.315181,
      3.704310,
      3.144972,
      1.736100,
      NULL,
      NULL,
      0.762970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.834718,
      2.498016,
      3.423983,
      4.204809,
      1.549033,
      2,
      0.437310,
      NULL,
      NULL,
      1.733906,
      NULL,
      NULL,
      1.194569,
      NULL,
      NULL,
      1.243690,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.962679,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.053541,
      NULL,
      NULL,
      NULL,
      3.141739,
      3,
      5,
      NULL,
      3,
      1.390780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.668222,
      1.608983,
      3,
      2.091772,
      1.183888,
      NULL,
      6,
      NULL,
      1.212334,
      0.316524,
      NULL,
      0,
      3.780770,
      0.632221,
      3.042357,
      2,
      1,
      2,
      2.219912,
      NULL,
      4.830155,
      0.551264,
      4.896006,
      NULL,
      2.832646,
      0,
      NULL,
      0,
      0,
      1.219332,
      1,
      1,
      NULL,
      3.507405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007998,
      NULL,
      NULL,
      1.905909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.891660,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0.671054,
      1.917918,
      1.919626,
      NULL,
      0.786101,
      NULL,
      5.679535,
      7,
      NULL,
      NULL,
      NULL,
      0.978962,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.539384,
      NULL,
      NULL,
      1,
      2.933637,
      NULL,
      NULL,
      NULL,
      1.845150,
      NULL,
      NULL,
      NULL,
      1.144080,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      15.261008,
      2,
      NULL,
      NULL,
      3.337183,
      1,
      NULL,
      NULL,
      11,
      2.802946,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.374521,
      0.955450,
      NULL,
      NULL,
      19.619009,
      0,
      NULL,
      NULL,
      NULL,
      3.880565,
      NULL,
      NULL,
      2.927560,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.574954,
      1.614813,
      NULL,
      NULL,
      1.086193,
      NULL,
      NULL,
      NULL,
      0,
      14,
      NULL,
      NULL,
      NULL,
      0.570975,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.931789,
      1,
      39.221506,
      1.436474,
      0.129559,
      NULL,
      NULL,
      0,
      41,
      22,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.329050,
      NULL,
      1.956049,
      0,
      0.271996,
      1,
      0.295096,
      0,
      1.064835,
      1,
      1.436870,
      0.495322,
      1,
      0,
      0.787836,
      1,
      1.462740,
      NULL,
      0.691391,
      1.432815,
      0.778423,
      1.509795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.809466,
      5,
      4.039149,
      0,
      3.374884,
      0,
      13.301119,
      NULL,
      2.320737,
      NULL,
      1,
      3,
      NULL,
      1,
      1.749811,
      NULL,
      0,
      0.083629,
      NULL,
      0.846657,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0.741703,
      2,
      NULL,
      1.407821,
      0.822507,
      NULL,
      1.304127,
      1.993285,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.734121,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429667,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4.182779,
      0,
      5.458701,
      1.587858,
      NULL,
      NULL,
      51.286517,
      28,
      0.889623,
      1.015866,
      0,
      '31002',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


