set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9038736';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0323141',
      2.573823,
      1.200592,
      5,
      3,
      '1320',
      3,
      1.886976,
      NULL,
      NULL,
      ' 8-16-1974',
      31,
      NULL,
      5.146559,
      1.568126,
      10.060751,
      ' 3- 9-1979',
      NULL,
      0.988747,
      341.717178,
      NULL,
      1,
      NULL,
      ' 6- 1-1977',
      ' 8- 5-1998',
      1.005346,
      1,
      3,
      0.203563,
      NULL,
      1.155043,
      NULL,
      0.196191,
      0.703114,
      NULL,
      9,
      18.655957,
      NULL,
      4,
      4,
      NULL,
      16,
      3.921066,
      0,
      7.206503,
      2.775057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.237347,
      2.060604,
      0,
      5,
      1.653630,
      3,
      0.999133,
      1,
      1.713514,
      NULL,
      1.484055,
      0,
      1,
      0,
      4,
      1,
      0.183022,
      2,
      1,
      0.017522,
      NULL,
      NULL,
      1.697391,
      NULL,
      NULL,
      7,
      9,
      3,
      3,
      NULL,
      1,
      NULL,
      2,
      1.560894,
      2,
      2.562813,
      0,
      0.286771,
      0.485257,
      2.515684,
      1.816754,
      2.154373,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626243,
      NULL,
      1,
      1.892201,
      1,
      NULL,
      0,
      0.461713,
      1,
      NULL,
      NULL,
      0.824231,
      0.019205,
      1,
      1.705082,
      1,
      NULL,
      1,
      0,
      NULL,
      0.229718,
      1,
      1.416528,
      NULL,
      3,
      NULL,
      5,
      1,
      NULL,
      4,
      1.802420,
      1,
      1,
      3.196460,
      1.030372,
      0.693561,
      5,
      2,
      NULL,
      0.217058,
      1.912077,
      0.072097,
      6,
      8.061912,
      NULL,
      0,
      4,
      NULL,
      NULL,
      125,
      NULL,
      20,
      2,
      NULL,
      NULL,
      3.682490,
      4,
      7.254089,
      NULL,
      NULL,
      1.631021,
      1,
      4,
      0,
      8,
      1,
      11,
      5.141995,
      4,
      5,
      0.572459,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.721706,
      4.854826,
      0,
      0,
      2,
      0,
      8,
      5,
      0.609730,
      2.610805,
      0.019261,
      1,
      0,
      NULL,
      4,
      NULL,
      4,
      3.980531,
      2,
      8,
      NULL,
      1.570946,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.968874,
      0.754545,
      1,
      3.517921,
      1.318042,
      1.691930,
      1,
      37,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.971289,
      0.496437,
      3.968602,
      1,
      1,
      NULL,
      3,
      0.889708,
      NULL,
      1,
      3,
      0.287878,
      1.649776,
      NULL,
      10.863172,
      NULL,
      0.039821,
      1,
      NULL,
      1.569273,
      1.607858,
      1,
      1.294873,
      1,
      0.928370,
      0.443157,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.573434,
      NULL,
      8.611596,
      1,
      3,
      8,
      6,
      1.539579,
      2.342301,
      2,
      2,
      0.591894,
      2.268810,
      52.918684,
      1,
      3,
      NULL,
      18.467231,
      16,
      42.919216,
      6.698366,
      1.763126,
      1.936216,
      '31201',
      '42331',
      '12234',
      1,
      NULL,
      '',
      '',
      0.834151,
      '',
      '',
      '',
      2.620293,
      NULL,
      109,
      26,
      0,
      17.604160,
      0.012428,
      0,
      4,
      1,
      0.536280,
      0,
      0.516307,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.626362,
      NULL,
      NULL,
      0.923769,
      NULL,
      NULL,
      1.400852,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.396577,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.681744,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.017548,
      0.853543,
      3.005845,
      3.656181,
      0.127704,
      0,
      1.431056,
      3.312827,
      0.284011,
      0.405472,
      1.072790,
      1,
      3.239612,
      1.035933,
      2.714313,
      0,
      2.821449,
      2.150188,
      3.821956,
      1.145479,
      0.284934,
      1.641465,
      1.606653,
      3,
      0,
      NULL,
      NULL,
      1.825341,
      NULL,
      NULL,
      1.370242,
      NULL,
      NULL,
      5.324564,
      6,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.257730,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.753666,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.324866,
      NULL,
      NULL,
      1.226021,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738777,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      5,
      3,
      NULL,
      2,
      3,
      0.070777,
      1,
      NULL,
      NULL,
      1.419255,
      1,
      0,
      2.282811,
      3.812917,
      2.709302,
      0,
      2,
      2,
      4.728866,
      0.150254,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922391,
      3,
      3,
      2.647043,
      5.382566,
      7,
      4.070616,
      2,
      2,
      0.653389,
      3,
      3,
      3.835532,
      NULL,
      0,
      NULL,
      0.274223,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.189668,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.139575,
      NULL,
      NULL,
      0.460922,
      1.922100,
      NULL,
      1.449846,
      1,
      0.318751,
      1.561370,
      NULL,
      NULL,
      NULL,
      0.419438,
      NULL,
      NULL,
      1.477382,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.297776,
      NULL,
      NULL,
      NULL,
      0,
      0.825022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.674354,
      1.333302,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.616925,
      NULL,
      NULL,
      NULL,
      2.100502,
      NULL,
      NULL,
      NULL,
      1.133256,
      NULL,
      NULL,
      NULL,
      0.864728,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.113511,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.169172,
      1,
      NULL,
      NULL,
      3.678504,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.187327,
      3.372535,
      9.784792,
      2.216523,
      2,
      29.985525,
      2,
      1,
      1,
      1.351633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.259263,
      4,
      0,
      1,
      NULL,
      NULL,
      1.362576,
      NULL,
      1,
      1.309461,
      0,
      NULL,
      1,
      3,
      0.221335,
      1.675388,
      0,
      NULL,
      1,
      2.024534,
      2.576857,
      1.069836,
      3.887910,
      1,
      0,
      1.982602,
      NULL,
      2.914087,
      0,
      1.793994,
      0,
      NULL,
      1,
      0.300640,
      1.833075,
      NULL,
      1.906369,
      2.073993,
      NULL,
      34.066421,
      14.494015,
      2.819945,
      0,
      0.516286,
      NULL,
      1.456494,
      3,
      1,
      1,
      1,
      0,
      3,
      NULL,
      1,
      0,
      1,
      1.564969,
      1.340404,
      1.159624,
      1.846830,
      0.995698,
      NULL,
      0.192456,
      NULL,
      0,
      1,
      0.058742,
      0.703830,
      0,
      0,
      0.353641,
      0.061315,
      NULL,
      1,
      1.347986,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.763297,
      NULL,
      0.326638,
      NULL,
      NULL,
      NULL,
      0.941183,
      NULL,
      1.099208,
      NULL,
      1.060954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.921653,
      NULL,
      1.686209,
      NULL,
      0.343595,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.822677,
      NULL,
      NULL,
      NULL,
      1.396351,
      NULL,
      0.488965,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.884764,
      NULL,
      NULL,
      NULL,
      0.298529,
      2.703650,
      3.984477,
      2,
      0,
      3.895042,
      0.795379,
      37,
      37.652036,
      3.132232,
      0,
      0.027954,
      1,
      NULL,
      1.146289,
      2.553621,
      0.884696,
      8,
      NULL,
      NULL,
      NULL,
      3,
      7.092701,
      1.630959,
      4,
      1,
      4.464701,
      2,
      4.767314,
      3,
      NULL,
      NULL,
      0,
      3.545089,
      1.627012,
      1,
      1.767953,
      1.306510,
      1,
      0.516807,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.561593,
      0.400696,
      1,
      1.724466,
      0,
      1.766231,
      1.277501,
      1,
      0.999504,
      1,
      NULL,
      1,
      NULL,
      1.885384,
      1.746626,
      0.822789,
      1.941030,
      1.782335,
      0,
      0,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.781625,
      0,
      1.082447,
      2,
      8.300319,
      5.158267,
      0,
      NULL,
      NULL,
      1.603799,
      32.491780,
      5.445611,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


