set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100111';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1411410',
      0.348519,
      NULL,
      0,
      3,
      '4023',
      2.533911,
      1,
      NULL,
      NULL,
      '11- 5-1994',
      18.521798,
      NULL,
      0.291465,
      1.129249,
      0,
      '11- 9-1990',
      36,
      3.618004,
      145.195193,
      NULL,
      2.644148,
      ' 3-19-1993',
      ' 9-13-1988',
      NULL,
      3.181198,
      0,
      1.575474,
      NULL,
      NULL,
      1.565586,
      2,
      NULL,
      0.715935,
      1,
      1,
      4,
      NULL,
      NULL,
      19,
      NULL,
      23,
      0.372259,
      1.631969,
      4.945551,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.484767,
      NULL,
      NULL,
      1.688716,
      0.155161,
      NULL,
      NULL,
      0.032452,
      NULL,
      0,
      NULL,
      NULL,
      0.054162,
      3,
      0,
      10,
      6.302200,
      3.958781,
      NULL,
      NULL,
      0.454782,
      1.356005,
      4.371007,
      0.297240,
      NULL,
      3,
      1.515461,
      0.299332,
      NULL,
      NULL,
      1.754354,
      NULL,
      NULL,
      0,
      NULL,
      1.265397,
      0,
      0.638392,
      1.969853,
      1,
      3,
      2,
      1.297285,
      0.172036,
      0.719382,
      1,
      NULL,
      1.716107,
      3.541009,
      1.659354,
      1,
      NULL,
      1,
      0,
      3.571525,
      NULL,
      0.938352,
      0.746191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.093257,
      2.044586,
      1.584948,
      1.224845,
      1,
      0.343950,
      1.898297,
      0.148679,
      1.445043,
      0.294579,
      1.585735,
      1,
      0,
      NULL,
      NULL,
      1.075303,
      NULL,
      NULL,
      0,
      NULL,
      1.416530,
      2.446311,
      2,
      3,
      0.773844,
      5.614799,
      4.639452,
      8,
      NULL,
      NULL,
      4.257451,
      NULL,
      5.436406,
      NULL,
      NULL,
      6,
      NULL,
      7.049172,
      NULL,
      NULL,
      5.081463,
      NULL,
      5,
      1.742063,
      0,
      ' 2-13-2003',
      50.191414,
      ' 4- 3-1980',
      28.204633,
      1,
      1.472365,
      1.736056,
      2.815943,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.918079,
      0,
      2.005762,
      1,
      0.311994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.044902,
      6.693743,
      1,
      1,
      1.009963,
      2.122637,
      4.325671,
      9,
      0.370920,
      0,
      NULL,
      NULL,
      NULL,
      2.225630,
      0,
      2,
      5.506604,
      7.045485,
      0.239294,
      2,
      1,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.469538,
      2,
      1.670351,
      0.109151,
      0,
      0,
      6,
      0.767365,
      0.288917,
      NULL,
      NULL,
      NULL,
      2,
      0.365744,
      1.784991,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      2.155804,
      NULL,
      2.238896,
      2,
      3,
      1,
      NULL,
      1.749115,
      NULL,
      0,
      NULL,
      1,
      0,
      1.605885,
      0.999136,
      1.807106,
      0,
      0,
      0.823867,
      0,
      2,
      2,
      1.279675,
      NULL,
      9.486505,
      NULL,
      NULL,
      1,
      1,
      1.007745,
      NULL,
      3,
      3,
      2.983982,
      0,
      37,
      3.027253,
      0,
      NULL,
      NULL,
      40.929840,
      79,
      2.552962,
      1.093447,
      NULL,
      '03004',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.700950,
      NULL,
      '',
      '',
      0.065249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963878,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.451353,
      NULL,
      NULL,
      2,
      3.141734,
      2.575461,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.718183,
      14,
      0.731484,
      NULL,
      0,
      NULL,
      1.986875,
      1,
      0.063528,
      0,
      0.200075,
      1.654469,
      NULL,
      1.696955,
      0,
      NULL,
      0,
      0,
      1.821155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.696789,
      0.002512,
      9.695203,
      1.447894,
      NULL,
      1.864102,
      2,
      NULL,
      0,
      0.627213,
      0,
      3.903672,
      0.390547,
      NULL,
      1.948002,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.194483,
      1.053764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.547140,
      NULL,
      NULL,
      0,
      NULL,
      0.710646,
      0,
      NULL,
      0.421312,
      0.589879,
      NULL,
      0.521264,
      1,
      NULL,
      1.468532,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.973601,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.149029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864030,
      NULL,
      0.737378,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.802107,
      NULL,
      0,
      NULL,
      3.795353,
      1.567480,
      NULL,
      0.375697,
      NULL,
      2.388900,
      NULL,
      NULL,
      NULL,
      0.204953,
      0.253111,
      7,
      1,
      NULL,
      NULL,
      77.850557,
      134.334839,
      NULL,
      1,
      NULL,
      '43402',
      '',
      '',
      1,
      '22014',
      '',
      '',
      1.265936,
      NULL,
      NULL,
      '');
commit;
end;
/


