set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8123228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      3.242682,
      NULL,
      NULL,
      3,
      '0423',
      NULL,
      3.594431,
      3,
      NULL,
      ' 3-17-1999',
      NULL,
      NULL,
      NULL,
      1,
      1,
      ' 6-27-1987',
      8,
      0.217641,
      NULL,
      123,
      2,
      NULL,
      ' 8-29-2002',
      NULL,
      3,
      1.662824,
      3,
      1.910936,
      NULL,
      0,
      2.278992,
      3,
      NULL,
      NULL,
      NULL,
      5.148248,
      5,
      181,
      87.486309,
      9.742059,
      0,
      0,
      0,
      2,
      1,
      NULL,
      1.425029,
      0.070798,
      1.749953,
      0.943412,
      0.083185,
      0.290932,
      1.606633,
      1,
      0,
      13.173439,
      3.388743,
      1,
      2.785632,
      4.356613,
      1.186401,
      7,
      NULL,
      11.302301,
      1.164941,
      NULL,
      1.362661,
      NULL,
      1,
      NULL,
      0,
      7,
      0.539915,
      0,
      3.210997,
      1,
      0,
      NULL,
      NULL,
      1.967788,
      NULL,
      NULL,
      NULL,
      1.368595,
      0.924502,
      0,
      0,
      0,
      1.516598,
      1,
      1,
      0.304139,
      2.436781,
      2.540925,
      NULL,
      0,
      0,
      1,
      1.655780,
      1.893142,
      NULL,
      1.578167,
      NULL,
      1,
      7,
      NULL,
      5,
      5,
      0.488555,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351373,
      NULL,
      NULL,
      0,
      1,
      10.348976,
      3.890664,
      2,
      1,
      0,
      0.517963,
      3,
      1.478070,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.353680,
      0.871445,
      3.502958,
      4,
      6.707317,
      5,
      1,
      0,
      5,
      0,
      8,
      10,
      NULL,
      3,
      3.479901,
      2.939023,
      0,
      6,
      2,
      0,
      0,
      3.105482,
      2.972038,
      NULL,
      5.108583,
      2,
      1,
      ' 1-26-1994',
      NULL,
      ' 8- 3-1988',
      11.292768,
      3,
      1.139506,
      NULL,
      5.773681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.133063,
      2,
      1.172530,
      1.913200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.397742,
      5,
      NULL,
      0.548497,
      1.005934,
      0.037899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.078904,
      NULL,
      1,
      2.867318,
      2,
      NULL,
      0,
      0,
      0.422599,
      1.251658,
      11.850058,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.868243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      1.229147,
      1.703032,
      0.030266,
      3.409240,
      114,
      NULL,
      0,
      34.927887,
      NULL,
      NULL,
      1,
      1.830085,
      0,
      1.150575,
      0.318573,
      0.749837,
      2.799753,
      5.305605,
      NULL,
      3,
      5.208269,
      4,
      1,
      NULL,
      NULL,
      2.222857,
      NULL,
      1.254860,
      0,
      0,
      1,
      0.389361,
      0,
      1.885070,
      0,
      1,
      NULL,
      0,
      1,
      3,
      1.645427,
      0.801918,
      7,
      NULL,
      3,
      3.746329,
      1,
      NULL,
      2,
      2.326836,
      1.841591,
      2.711772,
      1.141310,
      NULL,
      NULL,
      2,
      0.515725,
      NULL,
      36.423946,
      19.885210,
      NULL,
      3.247443,
      1,
      0.155076,
      NULL,
      '',
      '',
      1.177806,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      13,
      74,
      14.150387,
      1.430202,
      NULL,
      1.350411,
      2.057415,
      1,
      0.746731,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      1,
      1.958955,
      NULL,
      1,
      1.944124,
      0.129312,
      0.365966,
      0.774249,
      NULL,
      NULL,
      2.504067,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.018381,
      2.825522,
      NULL,
      0.015983,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.226526,
      1,
      2,
      0.181481,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.878390,
      NULL,
      3.335313,
      0,
      NULL,
      NULL,
      1,
      0.285999,
      0.477744,
      2.235837,
      0,
      1,
      0.103735,
      1,
      2.075120,
      1.093962,
      0,
      NULL,
      3.148842,
      1,
      0.322365,
      NULL,
      NULL,
      0.228075,
      1,
      0,
      NULL,
      NULL,
      1.938174,
      NULL,
      NULL,
      2.182271,
      1,
      1.898208,
      1.804675,
      5,
      NULL,
      0.195876,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.570543,
      NULL,
      NULL,
      3.551087,
      3.258171,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.835350,
      7.943207,
      0.233073,
      NULL,
      0.088546,
      0.939153,
      0,
      NULL,
      0,
      7.826636,
      8,
      1,
      NULL,
      NULL,
      1.324141,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      0,
      7,
      6.256764,
      2,
      0.129198,
      0,
      2,
      NULL,
      4,
      2.972347,
      3,
      0.793970,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579123,
      NULL,
      NULL,
      1,
      5.606507,
      NULL,
      1.581939,
      2.947659,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.636706,
      0,
      NULL,
      3,
      1.469794,
      NULL,
      NULL,
      2.182368,
      3.001829,
      3,
      4.635678,
      0.440362,
      0,
      3.158118,
      1.506742,
      NULL,
      3.126252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987229,
      NULL,
      NULL,
      0.570433,
      NULL,
      NULL,
      1.273305,
      NULL,
      NULL,
      1.691616,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.658188,
      NULL,
      NULL,
      0.647138,
      3.763392,
      0,
      0.942537,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203352,
      0.413833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689240,
      NULL,
      NULL,
      NULL,
      2.508434,
      NULL,
      NULL,
      NULL,
      0,
      1.301047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.384869,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032871,
      NULL,
      NULL,
      NULL,
      2.025091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.396254,
      1.544031,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.090974,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6.392211,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.966121,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.276313,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.282497,
      82,
      NULL,
      0,
      1,
      1.064230,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.528045,
      1.024132,
      1,
      0,
      0,
      0.698856,
      1,
      1,
      1.432157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9.725020,
      0,
      3.027715,
      NULL,
      NULL,
      7.449113,
      0,
      0,
      NULL,
      1.408342,
      0,
      2,
      NULL,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.383405,
      1,
      NULL,
      2.352984,
      0,
      1,
      NULL,
      2.019166,
      1,
      NULL,
      0.724526,
      NULL,
      3,
      1,
      0,
      0.471294,
      0,
      NULL,
      1.344335,
      0,
      NULL,
      0.253500,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.355295,
      NULL,
      7,
      1.176730,
      4,
      0.395496,
      3,
      3.350862,
      23,
      52,
      1.927654,
      0,
      3.147951,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.430954,
      '',
      '',
      '');
commit;
end;
/


