set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2.426424,
      2,
      3,
      0,
      3.995782,
      2.990818,
      0,
      '214',
      '21232440',
      36,
      NULL,
      '2403204',
      5.446878,
      1.660155,
      0,
      1,
      '1303',
      2,
      NULL,
      NULL,
      NULL,
      '11-23-1996',
      193.144428,
      NULL,
      NULL,
      2.538613,
      1,
      ' 3-19-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0.265265,
      NULL,
      NULL,
      ' 4- 6-1974',
      NULL,
      NULL,
      3.984020,
      0.160028,
      1.781246,
      0,
      NULL,
      1.548059,
      1,
      2.886138,
      8.826377,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.837403,
      2.355832,
      0.200622,
      4.122335,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      3.096841,
      0.817037,
      0,
      NULL,
      2,
      6.678259,
      0.759657,
      0,
      3.079365,
      0,
      1.633754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.347342,
      5.723172,
      2,
      NULL,
      0.217302,
      0,
      2.821022,
      3,
      0,
      3.856437,
      3,
      1,
      1,
      2.306466,
      0,
      2.267916,
      NULL,
      3.454032,
      0,
      1.324458,
      1.818941,
      1,
      9,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.927802,
      NULL,
      2.683061,
      2,
      0.277151,
      1.547024,
      1.159283,
      NULL,
      1,
      0,
      0.383287,
      0.164285,
      NULL,
      1.110950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.260723,
      3.065869,
      NULL,
      1.030776,
      1.183592,
      1.983755,
      NULL,
      NULL,
      1,
      1,
      1.287025,
      1.713685,
      NULL,
      5,
      NULL,
      4,
      5,
      NULL,
      3,
      7.496242,
      6,
      0,
      10.408763,
      5.477980,
      1.003038,
      0,
      1.456905,
      NULL,
      '10-25-1977',
      334,
      ' 0- 8-1996',
      11,
      0.332292,
      NULL,
      1.915454,
      1.568703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      1.756809,
      3.098652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.554652,
      NULL,
      1.483845,
      NULL,
      1.171552,
      2,
      3,
      0.085094,
      0,
      NULL,
      NULL,
      NULL,
      1.702789,
      0.395806,
      5,
      NULL,
      0.562100,
      3.147914,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175958,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.475356,
      0,
      NULL,
      3.109552,
      1,
      1,
      1.780857,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      2.041736,
      1,
      1.996992,
      NULL,
      2,
      3.503806,
      NULL,
      0,
      0.015797,
      2,
      1.475501,
      0.766280,
      NULL,
      4.224917,
      0.981932,
      0,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.738605,
      0,
      0,
      0.436844,
      NULL,
      3.784362,
      0.296579,
      3,
      2,
      6.261774,
      8.743196,
      NULL,
      2,
      2,
      2,
      3,
      2,
      3.182396,
      2,
      4,
      2,
      1.567711,
      71,
      NULL,
      NULL,
      NULL,
      1.512387,
      2,
      0,
      '31300',
      '41210',
      '',
      1.157900,
      '',
      '',
      NULL,
      1.138372,
      '',
      '',
      '',
      2,
      32.492564,
      171.268464,
      24.254474,
      NULL,
      36.135969,
      14,
      5,
      NULL,
      NULL,
      1.661436,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.344035,
      NULL,
      NULL,
      NULL,
      1.633468,
      NULL,
      NULL,
      2.990866,
      0,
      2,
      3,
      1.844989,
      1.174452,
      3.194226,
      1,
      0.468680,
      1,
      0.154648,
      0,
      3,
      0.160292,
      0.204104,
      3.341158,
      0,
      0,
      NULL,
      6,
      7,
      0.957298,
      1.201277,
      NULL,
      NULL,
      NULL,
      3,
      0.756329,
      NULL,
      NULL,
      2,
      1,
      1.710727,
      3.900050,
      NULL,
      0,
      1,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      2,
      2,
      1.641558,
      2.858901,
      NULL,
      2.258694,
      2.066665,
      1,
      1,
      0,
      1.116187,
      NULL,
      1.409356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      2.006091,
      2.116411,
      2,
      1,
      0.897820,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0.009225,
      1.933300,
      1.482126,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      2,
      0.067904,
      NULL,
      0.578438,
      NULL,
      NULL,
      5.791789,
      0,
      1.124287,
      0.029643,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.783347,
      NULL,
      NULL,
      1,
      0,
      1,
      1.495752,
      NULL,
      NULL,
      0,
      4.676749,
      0,
      0,
      3.856061,
      7,
      0.987601,
      NULL,
      NULL,
      1,
      3,
      0.322003,
      1.833481,
      1,
      1,
      0.922143,
      2,
      1.771953,
      8.233887,
      5,
      3.639714,
      0,
      0.399467,
      2.083679,
      0,
      2,
      0,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.388480,
      7,
      4.999241,
      1.735278,
      NULL,
      NULL,
      0.039780,
      0,
      NULL,
      0.225922,
      1.494669,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875332,
      NULL,
      NULL,
      0.269496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.260339,
      NULL,
      NULL,
      0.984995,
      NULL,
      NULL,
      1.723737,
      NULL,
      NULL,
      0.663311,
      3.263590,
      0.710484,
      NULL,
      0.140515,
      3,
      1.499131,
      NULL,
      5,
      0,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.062258,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0.391499,
      NULL,
      NULL,
      2,
      1.109732,
      NULL,
      NULL,
      3.427166,
      0.030240,
      NULL,
      NULL,
      0,
      0.743911,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.862014,
      NULL,
      NULL,
      0.007398,
      NULL,
      NULL,
      NULL,
      0,
      1.120479,
      NULL,
      NULL,
      2,
      0.280720,
      NULL,
      NULL,
      1,
      1.259660,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      2.212330,
      2.680611,
      NULL,
      NULL,
      2,
      NULL,
      32,
      3,
      2.407097,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.519889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.419919,
      0.672548,
      2.408594,
      3.092478,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.660177,
      0,
      NULL,
      NULL,
      1.857187,
      1,
      2.157556,
      0,
      2.829998,
      1.833598,
      NULL,
      0.155803,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.182633,
      NULL,
      3.160800,
      NULL,
      43.929821,
      NULL,
      2.167083,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      0.780586,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.617611,
      NULL,
      1,
      NULL,
      1.137250,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.083683,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.103278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.136922,
      0.093646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749579,
      0.581551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.650630,
      NULL,
      0.855612,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.420398,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292040,
      0.614931,
      3.317221,
      4,
      3,
      0,
      2,
      NULL,
      5.374778,
      2.991665,
      2.281107,
      2.202744,
      0,
      NULL,
      NULL,
      1.649310,
      3,
      NULL,
      0,
      3.119012,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      0.834405,
      0.327035,
      0,
      0,
      1,
      0,
      0.854953,
      0.782768,
      0,
      1.160444,
      1.603495,
      1,
      0.743574,
      1.796672,
      NULL,
      1,
      1,
      0.916404,
      0.458754,
      3,
      3,
      1.291477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.525363,
      1,
      1.636499,
      1,
      1.908225,
      1,
      NULL,
      8.781642,
      1,
      0.936357,
      1,
      2,
      62,
      12,
      3,
      2.169367,
      3,
      '04343',
      '12404',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


