set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.914413,
      NULL,
      4.838989,
      NULL,
      1,
      0,
      2,
      3.626864,
      '122',
      '10102410',
      51,
      NULL,
      '1032033',
      NULL,
      1,
      0,
      2,
      '1224',
      0,
      0.087114,
      NULL,
      NULL,
      NULL,
      11,
      72,
      NULL,
      0.661057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 8-1984',
      3,
      0,
      0,
      0.625528,
      2.469001,
      3,
      NULL,
      1.394591,
      0.844647,
      2,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.277359,
      1.388314,
      NULL,
      0.000954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.086028,
      NULL,
      9.216514,
      1.256915,
      0,
      NULL,
      1.159913,
      1,
      7.882976,
      4,
      4.151550,
      0.201077,
      0.142819,
      NULL,
      9,
      1.849647,
      1,
      2.571343,
      2,
      1.782011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      3,
      0.199461,
      NULL,
      1.718419,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.884914,
      NULL,
      NULL,
      3.752369,
      1,
      0,
      0.882794,
      0,
      5,
      NULL,
      NULL,
      0.205944,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      0.462556,
      0.751233,
      1,
      0.953521,
      0.340732,
      1.744963,
      NULL,
      1.880739,
      0,
      NULL,
      0,
      1.711459,
      NULL,
      NULL,
      1,
      0,
      0.976980,
      NULL,
      1,
      4,
      7,
      NULL,
      2,
      0.924329,
      NULL,
      4.366043,
      4,
      0,
      1.847993,
      5.073115,
      3.083415,
      7.444710,
      2,
      NULL,
      7,
      NULL,
      4,
      1,
      0,
      1,
      0,
      ' 0- 3-1979',
      NULL,
      ' 2-20-2000',
      NULL,
      0.372116,
      0.592173,
      0.226437,
      5.538774,
      1.242904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.474554,
      NULL,
      1.204161,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495859,
      7,
      2,
      NULL,
      NULL,
      1.806102,
      NULL,
      NULL,
      NULL,
      1.194648,
      1,
      1.609336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.918569,
      2,
      NULL,
      3,
      2,
      1.670700,
      NULL,
      0.996201,
      2.368194,
      3,
      2.764008,
      2.144325,
      1.013774,
      3.510671,
      5,
      1.983496,
      0.918404,
      0,
      1.863563,
      1,
      0,
      1.228658,
      0.221482,
      1,
      1,
      0.710301,
      0,
      1,
      1.476340,
      NULL,
      NULL,
      9,
      NULL,
      8.410157,
      1,
      NULL,
      NULL,
      3,
      4.214549,
      3,
      3.544997,
      1.218432,
      63,
      0,
      1.853762,
      6.594876,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4.016955,
      '03341',
      '14124',
      '',
      0.592638,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      0.112730,
      59.407760,
      4.125208,
      NULL,
      2.708194,
      5,
      10,
      3,
      NULL,
      2,
      3,
      0.441932,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.799822,
      NULL,
      1.724481,
      NULL,
      NULL,
      NULL,
      1.330853,
      NULL,
      NULL,
      0,
      2.460888,
      0,
      3.574903,
      1,
      0,
      2,
      0.129257,
      0.516609,
      1.369124,
      1.702848,
      NULL,
      3.081152,
      NULL,
      1.908926,
      3.532253,
      NULL,
      NULL,
      10,
      9,
      NULL,
      NULL,
      0.243074,
      NULL,
      NULL,
      NULL,
      0,
      0.329123,
      2,
      3,
      3.412983,
      2.626438,
      1.813960,
      2.459029,
      2,
      0,
      1,
      0,
      2,
      0.626226,
      1,
      1.661182,
      1.041031,
      0.578575,
      1.615748,
      1,
      NULL,
      1,
      0.559749,
      0,
      1.000250,
      2.659228,
      0,
      2,
      0,
      1.864356,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.017555,
      NULL,
      1.740643,
      2,
      2,
      NULL,
      NULL,
      0.326751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.152656,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      1,
      1.464184,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.953547,
      NULL,
      NULL,
      1.971536,
      NULL,
      NULL,
      1.241137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482979,
      NULL,
      NULL,
      2,
      1.546373,
      2,
      1.056662,
      NULL,
      NULL,
      NULL,
      4.800789,
      3.681708,
      4,
      NULL,
      5,
      0.526378,
      NULL,
      NULL,
      0.046561,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.457022,
      2.480174,
      1,
      0.995019,
      5.681338,
      1.632118,
      NULL,
      2.206893,
      2.579555,
      0,
      NULL,
      NULL,
      0.585553,
      1.026828,
      0,
      NULL,
      NULL,
      4.446300,
      NULL,
      6,
      0.412577,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.828405,
      1.191782,
      1,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.432211,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.130595,
      NULL,
      NULL,
      0.298500,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.083329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.181368,
      3.511400,
      0,
      1.209554,
      1,
      3.084841,
      1,
      NULL,
      7.803757,
      1,
      NULL,
      NULL,
      6.838949,
      NULL,
      NULL,
      NULL,
      3.557531,
      NULL,
      NULL,
      NULL,
      0.341924,
      NULL,
      NULL,
      NULL,
      0.250318,
      NULL,
      NULL,
      NULL,
      0.651829,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.285670,
      NULL,
      NULL,
      3.759791,
      2.716948,
      NULL,
      NULL,
      2.349145,
      1,
      NULL,
      NULL,
      NULL,
      1.310111,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.638288,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.046747,
      NULL,
      NULL,
      3.180675,
      0.536279,
      NULL,
      NULL,
      3.812714,
      1.599259,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.435121,
      0.509963,
      NULL,
      NULL,
      NULL,
      0.378161,
      NULL,
      NULL,
      3,
      3.451535,
      NULL,
      3.344929,
      1.458350,
      NULL,
      20,
      9,
      2,
      5,
      1.643779,
      NULL,
      NULL,
      NULL,
      0,
      2.394776,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.078727,
      NULL,
      0,
      0.968446,
      0,
      3,
      1.476924,
      NULL,
      NULL,
      3,
      NULL,
      1.287294,
      NULL,
      1.505972,
      0.798447,
      1,
      0.692407,
      1.841912,
      1,
      2.862113,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.318332,
      NULL,
      17,
      NULL,
      1.683870,
      NULL,
      3.682808,
      2.723195,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.493687,
      NULL,
      1,
      NULL,
      0.706148,
      NULL,
      2.939881,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.735173,
      NULL,
      3,
      NULL,
      0.205290,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512265,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.345753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.514385,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.512151,
      3.934103,
      NULL,
      2,
      2.308817,
      0,
      13,
      0.842727,
      1,
      1,
      1,
      2,
      2.292564,
      0,
      0,
      3,
      1,
      1.909595,
      NULL,
      0,
      3,
      NULL,
      0.317956,
      1.713270,
      0.504582,
      0,
      0.965280,
      0.317221,
      1,
      NULL,
      NULL,
      NULL,
      0.419920,
      0.898678,
      1.578787,
      0.240461,
      0.884490,
      0,
      NULL,
      3.256502,
      1,
      0.227363,
      NULL,
      NULL,
      2.758090,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.357480,
      4.446040,
      11.066823,
      3.349619,
      3.291741,
      1,
      NULL,
      55,
      0,
      3.041288,
      NULL,
      2.575884,
      NULL,
      '13003',
      '',
      0.202088,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      NULL);
commit;
end;
/


