set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9035420';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4341124',
      NULL,
      1,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      ' 6-29-1987',
      5.631494,
      NULL,
      NULL,
      3.724631,
      0.364946,
      ' 7- 3-1975',
      25.229276,
      0,
      188,
      NULL,
      0,
      NULL,
      ' 7-23-1984',
      ' 6-23-1993',
      0.573136,
      3,
      NULL,
      1,
      1,
      NULL,
      1,
      0.241691,
      NULL,
      NULL,
      NULL,
      4.210024,
      1,
      3.042254,
      10.573752,
      3,
      NULL,
      3,
      4.483518,
      NULL,
      0,
      2.681371,
      0,
      0.202960,
      0.093392,
      0.601548,
      1,
      NULL,
      NULL,
      1,
      0,
      1.339906,
      2.125857,
      2.554750,
      2,
      0.448897,
      1,
      NULL,
      1.586340,
      1.854006,
      0.773237,
      NULL,
      NULL,
      1.837550,
      5.882270,
      1.782317,
      4,
      NULL,
      0.170467,
      2.544077,
      0,
      3,
      1.136747,
      NULL,
      NULL,
      1.132642,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.375461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886107,
      NULL,
      0,
      0.580031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458620,
      NULL,
      1,
      0,
      0,
      1.667105,
      1.554049,
      1,
      0,
      0,
      1.335251,
      1,
      1,
      1.375692,
      0,
      1.461971,
      1.857398,
      1,
      NULL,
      1.525512,
      1,
      4.867725,
      1.411280,
      1.987032,
      NULL,
      2.631983,
      1,
      0,
      NULL,
      NULL,
      1.544961,
      0.793178,
      0.747932,
      4.958357,
      0,
      0,
      1.429660,
      NULL,
      NULL,
      NULL,
      1.674239,
      2,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.170382,
      3.324461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      0.169978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451817,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038724,
      NULL,
      1.457817,
      3.521007,
      1,
      0.141803,
      5,
      0.522533,
      NULL,
      0,
      2,
      NULL,
      0,
      1,
      5,
      1,
      3,
      7.787794,
      0.958170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.138781,
      NULL,
      NULL,
      1,
      1.607210,
      0.527556,
      0.122032,
      NULL,
      NULL,
      NULL,
      0.325863,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      1.302847,
      2.355099,
      2.179810,
      0,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      NULL,
      7,
      0.034775,
      0,
      4.838657,
      NULL,
      1,
      1,
      0,
      0.955042,
      0,
      0.056523,
      NULL,
      1,
      1,
      2.362935,
      1,
      6,
      NULL,
      NULL,
      NULL,
      3.775911,
      0,
      5.100413,
      2,
      7,
      0,
      0.793811,
      3.371300,
      25,
      2,
      3,
      NULL,
      48.735694,
      NULL,
      54.732735,
      6.305583,
      1.092043,
      4,
      '44134',
      '43423',
      '',
      0.722377,
      NULL,
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      1.000165,
      30.588829,
      NULL,
      18.690672,
      1.903700,
      32,
      4.922130,
      1.277538,
      2.566829,
      2.856441,
      3,
      NULL,
      0.484874,
      1,
      1,
      0.093899,
      1.013072,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.610812,
      1.196647,
      2.280684,
      1.996466,
      1.353024,
      3,
      1.838440,
      NULL,
      1.153754,
      NULL,
      NULL,
      0.300110,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.281432,
      4.925591,
      3,
      0.606924,
      0.299477,
      NULL,
      NULL,
      NULL,
      0.265381,
      2.595982,
      1.139305,
      3,
      1.360204,
      0.245790,
      0,
      1.392531,
      1,
      NULL,
      NULL,
      0.037397,
      0,
      0.281231,
      0,
      1,
      2.226707,
      2.830465,
      0.113279,
      NULL,
      2.593475,
      0,
      NULL,
      2,
      0,
      1,
      1.131405,
      3.630065,
      1.730589,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.953973,
      0.837310,
      3,
      0.802984,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841519,
      NULL,
      NULL,
      NULL,
      0.896970,
      NULL,
      NULL,
      0.492920,
      1,
      1.813016,
      3.931915,
      NULL,
      0.993766,
      0.555714,
      NULL,
      NULL,
      8,
      0.832339,
      0.953621,
      1.525255,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.214544,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.198847,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.425490,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.660603,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.690405,
      NULL,
      NULL,
      0.724731,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.086680,
      2.876460,
      0.812756,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      1.029196,
      NULL,
      2,
      0.411218,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.052526,
      NULL,
      1.915689,
      5,
      NULL,
      0.298359,
      3,
      0,
      0.597561,
      1,
      1,
      NULL,
      NULL,
      0.642615,
      1,
      NULL,
      NULL,
      0.136456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864871,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936988,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.933622,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.656780,
      0.033137,
      0.066055,
      0,
      6,
      NULL,
      NULL,
      NULL,
      177,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.906193,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.464386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.352214,
      NULL,
      3.611481,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.317203,
      0.173129,
      NULL,
      1,
      NULL,
      3.433662,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      2.977871,
      NULL,
      NULL,
      1.508277,
      1.875010,
      NULL,
      3,
      0.082836,
      1.577116,
      NULL,
      NULL,
      1,
      9.332584,
      NULL,
      11.979393,
      NULL,
      2.262703,
      NULL,
      3.954686,
      0.284309,
      5,
      3,
      0.186973,
      30,
      12,
      0.249514,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      15,
      16,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      48.828509,
      5.090360,
      2,
      0,
      1,
      0.716302,
      2.673693,
      NULL,
      2.689304,
      1.977473,
      0.843265,
      NULL,
      2.183413,
      NULL,
      NULL,
      1,
      0.681045,
      NULL,
      1,
      1.937612,
      1.006252,
      NULL,
      0,
      NULL,
      0.700174,
      NULL,
      1.733281,
      NULL,
      0.509734,
      NULL,
      102.387934,
      NULL,
      NULL,
      NULL,
      36.880707,
      NULL,
      0.709314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680390,
      NULL,
      1.072058,
      NULL,
      0,
      NULL,
      0.786495,
      NULL,
      0.457319,
      NULL,
      1.142442,
      NULL,
      NULL,
      NULL,
      0.223542,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039598,
      0.354427,
      1,
      2,
      0,
      0,
      3,
      3.001387,
      1.425282,
      0.898104,
      NULL,
      1.487032,
      1.231653,
      1.404432,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      0,
      1.333801,
      NULL,
      2,
      3.628112,
      1.738835,
      1.303332,
      1,
      NULL,
      0.477909,
      1,
      NULL,
      1.051508,
      0.458691,
      1.358905,
      1.564863,
      NULL,
      1.429385,
      0.840910,
      1.615214,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      0.592114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078969,
      0,
      NULL,
      NULL,
      0.415144,
      1.477613,
      3,
      7,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900311,
      NULL,
      1,
      NULL,
      '23013',
      '',
      0,
      '33113',
      '',
      NULL,
      0.205872,
      '',
      '',
      '');
commit;
end;
/


