set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      '2333403',
      3.975460,
      0,
      3,
      3,
      '2041',
      0.867747,
      NULL,
      NULL,
      NULL,
      ' 7-25-1977',
      NULL,
      49,
      NULL,
      3.789367,
      NULL,
      ' 5-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      0.469949,
      ' 8-19-1993',
      ' 6- 1-1985',
      '10- 8-1975',
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.337762,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.516360,
      3.114618,
      1,
      1,
      1.637039,
      NULL,
      1,
      1.696812,
      1,
      NULL,
      1,
      3,
      5.288192,
      3.215083,
      3.582531,
      1,
      0,
      1.058336,
      0.632839,
      1.106616,
      0,
      0.136853,
      NULL,
      0.326816,
      0.863832,
      0.985407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219878,
      6.402693,
      2.677505,
      1.234316,
      0.039451,
      0,
      1,
      0.609479,
      2,
      1.274939,
      1,
      1.045319,
      0,
      NULL,
      1,
      1,
      2,
      0,
      1,
      0,
      1.353022,
      NULL,
      1.422962,
      NULL,
      1.319498,
      NULL,
      1.676156,
      NULL,
      NULL,
      1.323892,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.816871,
      1.723892,
      1,
      0,
      1,
      0,
      0,
      0.869355,
      NULL,
      0.142647,
      1.946568,
      1.066990,
      1,
      1.841637,
      1,
      NULL,
      NULL,
      1.053344,
      0.591755,
      1,
      1.642876,
      0,
      NULL,
      NULL,
      5,
      1.541797,
      1.168840,
      4.606890,
      0.733623,
      0.865768,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.605145,
      2.127733,
      NULL,
      1.952703,
      0.223025,
      NULL,
      0,
      0.923737,
      0.580087,
      NULL,
      NULL,
      11.272468,
      ' 3- 3-2002',
      2,
      1.546219,
      1.304487,
      1.605911,
      8.367933,
      1.122325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884055,
      0.878737,
      NULL,
      1,
      NULL,
      0.330224,
      0.432014,
      1.358605,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6.499176,
      0.860629,
      0,
      4,
      3,
      1.192453,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.847516,
      0,
      3.883146,
      5,
      0.859984,
      NULL,
      NULL,
      NULL,
      0,
      1.790077,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.471885,
      0,
      NULL,
      0.303155,
      1.915044,
      1.058770,
      0.830110,
      1.370167,
      7.250521,
      0.321175,
      NULL,
      NULL,
      NULL,
      NULL,
      3.148355,
      0,
      1.411155,
      2.709642,
      2.734966,
      3,
      NULL,
      2.087395,
      1,
      2,
      2,
      1,
      0,
      2.221571,
      3,
      1,
      0,
      1,
      1.323739,
      0,
      1.708280,
      0,
      NULL,
      NULL,
      0.421384,
      NULL,
      0,
      1.695426,
      1,
      NULL,
      NULL,
      0,
      3,
      6,
      4.263639,
      8,
      8,
      6.704474,
      NULL,
      0.643368,
      5.410207,
      3,
      3.223606,
      3.549447,
      NULL,
      NULL,
      NULL,
      75.627406,
      NULL,
      70.974752,
      62,
      5,
      NULL,
      2.179407,
      NULL,
      '22230',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      0.486056,
      NULL,
      '',
      NULL,
      2,
      30,
      17.447109,
      31.575849,
      2,
      2,
      0.864090,
      1.386223,
      4,
      3,
      1.957601,
      1.623467,
      0.732320,
      NULL,
      NULL,
      0.203600,
      NULL,
      NULL,
      3,
      0.847565,
      NULL,
      0.172316,
      NULL,
      NULL,
      1.386139,
      NULL,
      NULL,
      3,
      1,
      1.608763,
      2,
      0,
      0,
      1.364242,
      3,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.636598,
      NULL,
      1.971645,
      1.395884,
      NULL,
      NULL,
      NULL,
      2.285825,
      0.430689,
      NULL,
      1,
      3,
      NULL,
      0.489313,
      0.404220,
      NULL,
      NULL,
      1,
      1.950818,
      1,
      2.162083,
      0.053334,
      0,
      3.496982,
      1.841362,
      3.670128,
      1,
      0.112649,
      1,
      NULL,
      2.697704,
      NULL,
      0.361855,
      2.655486,
      1,
      1.011234,
      1.110339,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.806744,
      1.005287,
      1.499559,
      6.213733,
      1.206596,
      1.212117,
      1.848736,
      1.614837,
      NULL,
      NULL,
      NULL,
      NULL,
      1.487084,
      2,
      1,
      0.614469,
      NULL,
      NULL,
      2,
      3,
      0.913232,
      1,
      2.752997,
      0.774896,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.278131,
      0,
      NULL,
      NULL,
      0.828034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.057771,
      NULL,
      NULL,
      0.000477,
      NULL,
      NULL,
      0.274377,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      0,
      0.345254,
      NULL,
      NULL,
      2.955259,
      1.441163,
      1.695743,
      4,
      5.734366,
      0,
      1,
      NULL,
      NULL,
      1.982381,
      2.425461,
      3,
      1.005995,
      3.184510,
      0.287373,
      1,
      NULL,
      0.921973,
      0.455132,
      4.500949,
      2,
      3,
      0.322705,
      3.309610,
      3,
      3.997537,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398402,
      NULL,
      NULL,
      0.063415,
      5,
      5,
      5.050488,
      5,
      1,
      1.891357,
      3,
      2,
      0,
      NULL,
      1.105795,
      0.047954,
      0,
      0.157425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103317,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.736556,
      NULL,
      NULL,
      0.997493,
      NULL,
      NULL,
      0.445954,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2.886421,
      NULL,
      0.562474,
      2,
      1.155404,
      NULL,
      NULL,
      1.917654,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      24.446426,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.641380,
      NULL,
      NULL,
      NULL,
      2.159082,
      NULL,
      0.621339,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.303413,
      NULL,
      1.231667,
      NULL,
      0.461475,
      NULL,
      0,
      NULL,
      0.665203,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.483680,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.341377,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2.447895,
      NULL,
      NULL,
      NULL,
      2.286453,
      NULL,
      0,
      NULL,
      10,
      NULL,
      7,
      NULL,
      3,
      2.215584,
      0.311150,
      2.737009,
      0.754361,
      NULL,
      0,
      2871.482274,
      0,
      NULL,
      1677.247808,
      0.846426,
      NULL,
      NULL,
      0.963312,
      NULL,
      NULL,
      1.067555,
      3,
      101,
      0,
      NULL,
      NULL,
      0.076633,
      NULL,
      NULL,
      288.717580,
      NULL,
      NULL,
      0,
      0.883155,
      0,
      NULL,
      1,
      NULL,
      1.700673,
      NULL,
      0.836812,
      0.323376,
      1.939294,
      1,
      1,
      1,
      1.181988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.157821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697081,
      0,
      NULL,
      2,
      NULL,
      2.651282,
      NULL,
      12.843865,
      NULL,
      2.831403,
      1,
      0,
      3,
      NULL,
      1.597557,
      NULL,
      34,
      NULL,
      NULL,
      NULL,
      0.769961,
      NULL,
      1,
      NULL,
      NULL,
      3,
      12,
      NULL,
      0.642638,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.918003,
      0,
      0,
      NULL,
      0.434740,
      3,
      NULL,
      1.835187,
      3,
      NULL,
      NULL,
      0.228884,
      1,
      1,
      1,
      1,
      0.936622,
      0.662460,
      1,
      0.669946,
      NULL,
      1,
      1.406187,
      0.642176,
      NULL,
      1.098981,
      1.226122,
      0,
      NULL,
      0.304508,
      1.610999,
      0,
      0,
      0,
      0,
      NULL,
      0.385853,
      1,
      0.758577,
      0.397742,
      0.214091,
      1,
      1.622228,
      2,
      1.160258,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.434619,
      1,
      0,
      NULL,
      0.845160,
      NULL,
      3,
      0.028666,
      NULL,
      NULL,
      NULL,
      84,
      NULL,
      3,
      NULL,
      2,
      '11002',
      '21001',
      '',
      1.459118,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


