set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '1022023',
      3.353617,
      NULL,
      4,
      2,
      '4134',
      3.689268,
      0,
      NULL,
      NULL,
      ' 5-23-1979',
      5.468684,
      NULL,
      4.199614,
      1.310589,
      1,
      ' 9-19-1990',
      43,
      3.978450,
      152.080001,
      118.489966,
      NULL,
      ' 1-16-1980',
      NULL,
      ' 3-12-1995',
      3.603584,
      0,
      2.349650,
      0,
      0.584335,
      0,
      3,
      0.866231,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      6.361543,
      12,
      1.038089,
      3.406895,
      3,
      0.960559,
      NULL,
      0.606898,
      0,
      0.255078,
      1,
      0.471555,
      0.975278,
      1.500926,
      NULL,
      1,
      NULL,
      2,
      3.356746,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.760883,
      2.008733,
      4.270071,
      3,
      2,
      NULL,
      0,
      0.621282,
      6,
      NULL,
      3.634664,
      0,
      0,
      0.900552,
      NULL,
      NULL,
      1.185835,
      NULL,
      NULL,
      1,
      0.580177,
      1.333504,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.138289,
      2.117499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.435441,
      1.931891,
      0,
      NULL,
      5,
      NULL,
      NULL,
      6,
      0.603351,
      0,
      1.037062,
      0,
      1,
      NULL,
      1.484336,
      5.807815,
      3.981321,
      1.280547,
      4,
      5,
      NULL,
      5.962225,
      0.786897,
      0,
      0,
      NULL,
      1,
      3,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1.283045,
      1,
      3.688387,
      0.684836,
      2,
      0.609540,
      NULL,
      0.608173,
      ' 6-15-1980',
      57,
      ' 6-18-1976',
      13.817538,
      NULL,
      0,
      1.927178,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.246282,
      3.806783,
      2,
      1,
      1,
      0.061910,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.624502,
      3,
      8.025994,
      NULL,
      0.836106,
      0.903582,
      0.945091,
      2,
      1.036600,
      6,
      0.795281,
      7.660408,
      3.352894,
      2,
      4.839903,
      4.358878,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0.108367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.954077,
      NULL,
      0,
      NULL,
      0,
      2,
      29.700203,
      1,
      1.440483,
      NULL,
      NULL,
      NULL,
      3.851316,
      1.137603,
      0,
      0,
      NULL,
      4.742918,
      3,
      4.573314,
      5.747673,
      5,
      1,
      3.901566,
      NULL,
      0.831306,
      2,
      1,
      4,
      1,
      0.836558,
      9,
      3,
      NULL,
      0.544352,
      1,
      0,
      0.073516,
      1.837717,
      NULL,
      0,
      1,
      NULL,
      0.528805,
      4,
      8.872493,
      NULL,
      7.311924,
      2.272931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      31,
      NULL,
      0.152805,
      NULL,
      NULL,
      9.767745,
      46,
      4,
      NULL,
      2,
      NULL,
      '',
      '',
      1.505778,
      NULL,
      '',
      '',
      0.522591,
      '',
      NULL,
      '',
      3.341448,
      21,
      30.178139,
      20.919380,
      2,
      27,
      3.840554,
      NULL,
      1,
      1,
      1,
      0.775513,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.165350,
      NULL,
      NULL,
      1.634825,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.448166,
      NULL,
      NULL,
      NULL,
      NULL,
      1.892836,
      NULL,
      NULL,
      1.036334,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.840638,
      0,
      NULL,
      NULL,
      NULL,
      1.225475,
      NULL,
      NULL,
      NULL,
      1.140005,
      NULL,
      NULL,
      1.375260,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249442,
      NULL,
      NULL,
      0.979530,
      NULL,
      NULL,
      0,
      2,
      1.996655,
      2.536392,
      NULL,
      0.360845,
      0,
      0.873714,
      NULL,
      NULL,
      NULL,
      0.395244,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.025494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028924,
      NULL,
      NULL,
      2.224345,
      1,
      0.856323,
      NULL,
      1.275467,
      0.982743,
      4.676351,
      0.410976,
      2.572244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.654811,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.025750,
      NULL,
      1,
      NULL,
      NULL,
      3,
      5,
      1.194353,
      0.500002,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.863459,
      0,
      1.816193,
      NULL,
      NULL,
      NULL,
      4.238298,
      3.001759,
      NULL,
      1.299954,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.130653,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.051044,
      1.335337,
      3,
      NULL,
      NULL,
      1.632238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.087954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.130685,
      NULL,
      NULL,
      0.850907,
      NULL,
      NULL,
      2.967789,
      NULL,
      NULL,
      0.708205,
      NULL,
      NULL,
      4.099760,
      NULL,
      NULL,
      1.768756,
      NULL,
      1,
      NULL,
      1.494537,
      0.405505,
      0.883881,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.071596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.771423,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.247899,
      1.151072,
      NULL,
      NULL,
      1.141653,
      1.315763,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.665569,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      9,
      7,
      NULL,
      NULL,
      2.613318,
      3.570491,
      7,
      0.599542,
      0.718841,
      29.458225,
      3,
      1.528669,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10,
      3,
      NULL,
      NULL,
      NULL,
      0.863015,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7607,
      6.416346,
      0.277451,
      0,
      0,
      NULL,
      1,
      1.017722,
      0.150177,
      2,
      0.789914,
      NULL,
      1,
      0,
      0.003884,
      1,
      NULL,
      0.384783,
      0.660535,
      1.949824,
      NULL,
      1,
      NULL,
      0.521987,
      NULL,
      1.197951,
      NULL,
      1,
      NULL,
      0.364222,
      NULL,
      NULL,
      NULL,
      1.839289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.032273,
      1.556462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.435618,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752042,
      1.855656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673518,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.468792,
      1.328750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.040797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.361416,
      2,
      NULL,
      2,
      NULL,
      0.084871,
      NULL,
      NULL,
      NULL,
      1.555602,
      NULL,
      NULL,
      NULL,
      0.884436,
      1,
      1.490131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2.725689,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1.187213,
      1.321854,
      2.237384,
      1.063769,
      1.654964,
      0,
      2.320875,
      2.921503,
      NULL,
      0,
      0.840404,
      0.845339,
      1,
      0.285628,
      NULL,
      1,
      2.295881,
      3.343201,
      1.070143,
      3.229322,
      2.307767,
      NULL,
      0,
      0.197396,
      1.121132,
      1.955818,
      1,
      1,
      1.220529,
      0.357470,
      1.582736,
      1,
      0,
      1,
      0.129608,
      0.671101,
      2,
      3.006241,
      1.020016,
      1.319696,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.840816,
      NULL,
      1.132167,
      NULL,
      0.362495,
      NULL,
      1,
      NULL,
      0.142174,
      11,
      NULL,
      273.659629,
      1,
      NULL,
      1.741912,
      NULL,
      1,
      NULL,
      0.618587,
      NULL,
      2.663027,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.685569,
      NULL,
      1.969819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.376995,
      NULL,
      1,
      502,
      1.764646,
      0.870234,
      0,
      0,
      0.647704,
      1,
      0.736254,
      NULL,
      1,
      1.489669,
      NULL,
      NULL,
      NULL,
      111.599991,
      4.335356,
      0,
      2.730647,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


