set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '3', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      6,
      1,
      0.061243,
      2.753450,
      0,
      NULL,
      '241',
      NULL,
      29,
      38,
      NULL,
      4,
      0,
      2,
      0,
      '3414',
      5,
      1,
      NULL,
      NULL,
      ' 7-28-1991',
      NULL,
      109.353324,
      NULL,
      0.260205,
      0,
      ' 0-12-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      3.030271,
      NULL,
      ' 3- 2-2003',
      NULL,
      0.734651,
      3.459258,
      NULL,
      3.301142,
      0.059098,
      0.750239,
      2.387385,
      0.758419,
      0.870438,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.893666,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      1,
      4,
      0.093812,
      0,
      0,
      0.728554,
      1.240539,
      1.989647,
      NULL,
      0.513228,
      0.615001,
      0,
      8.508159,
      1,
      3,
      2.631428,
      0.906032,
      0.310242,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.797488,
      NULL,
      0.569097,
      1.618824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.866581,
      0.493090,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.993368,
      3.791402,
      0.936059,
      4.028708,
      7.710283,
      1,
      NULL,
      1.345442,
      NULL,
      0,
      0.546870,
      1.432527,
      NULL,
      0,
      1,
      NULL,
      0.546852,
      1,
      NULL,
      NULL,
      1.014091,
      4.703376,
      1,
      1.456009,
      NULL,
      2,
      5,
      0.717249,
      1,
      0.589339,
      0,
      0,
      4.709937,
      1,
      0.927302,
      NULL,
      4,
      5,
      5.814380,
      5,
      6,
      6.244838,
      6,
      1,
      0,
      0.355235,
      1.508160,
      '10-26-1976',
      128,
      ' 6- 9-1991',
      0,
      1,
      1,
      1.151134,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.579226,
      0,
      1.776519,
      0.766408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980449,
      NULL,
      2.454159,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      2.069458,
      3.849959,
      NULL,
      3.683080,
      0.316579,
      3.350277,
      0,
      2.617017,
      1.764219,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.725104,
      NULL,
      0,
      0.251274,
      1,
      1,
      0.761050,
      3,
      0.101406,
      0.466793,
      NULL,
      NULL,
      NULL,
      7.365541,
      0.608266,
      1.545294,
      0.846496,
      NULL,
      0.620053,
      3.971397,
      7,
      NULL,
      0,
      6,
      NULL,
      1.334433,
      0.844919,
      NULL,
      2,
      7,
      1.962764,
      0.132460,
      NULL,
      3,
      1.457322,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.876693,
      0,
      4.404836,
      1.129042,
      NULL,
      9.945494,
      4.763673,
      NULL,
      4,
      5,
      4,
      1,
      0.190386,
      2.646081,
      2,
      1.673345,
      54,
      3,
      1.267480,
      25,
      NULL,
      5,
      43.252109,
      3,
      3,
      2.583875,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0.626291,
      8.879819,
      124.778301,
      35,
      2.305751,
      46,
      4,
      1.368468,
      4,
      2,
      0,
      0.714201,
      NULL,
      NULL,
      NULL,
      0.669637,
      NULL,
      NULL,
      0.933435,
      NULL,
      NULL,
      1.200466,
      NULL,
      NULL,
      0.313578,
      NULL,
      NULL,
      1,
      2,
      1.296958,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      1.185175,
      NULL,
      NULL,
      0.739431,
      NULL,
      NULL,
      1.043717,
      NULL,
      NULL,
      NULL,
      6.017466,
      0.913491,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.648097,
      NULL,
      NULL,
      NULL,
      0.510593,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.016777,
      NULL,
      NULL,
      1.827523,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.953955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035398,
      NULL,
      NULL,
      0.619693,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144437,
      1.285131,
      NULL,
      NULL,
      0,
      1,
      1.929778,
      1,
      NULL,
      0.828403,
      1.050778,
      NULL,
      0.793555,
      6,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.106669,
      3.502537,
      1,
      1.228626,
      NULL,
      NULL,
      5,
      0.356199,
      1.457930,
      2.709013,
      3,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1.118716,
      1.240220,
      0.020717,
      0,
      1,
      NULL,
      2,
      1.704232,
      3.032341,
      NULL,
      0.008958,
      0.595310,
      0,
      0,
      NULL,
      0.292456,
      0.741352,
      0,
      0,
      5.586675,
      2.038810,
      1.844131,
      NULL,
      3,
      2,
      NULL,
      0,
      1.758296,
      NULL,
      0.279311,
      NULL,
      3.402661,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.010838,
      NULL,
      NULL,
      0.494899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.444282,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307302,
      1.551058,
      1,
      2,
      1,
      NULL,
      0,
      4,
      NULL,
      0.424806,
      5.011023,
      4,
      NULL,
      NULL,
      12.151255,
      NULL,
      NULL,
      1.763619,
      1.060555,
      2.860382,
      NULL,
      3.907536,
      1.808507,
      3.642624,
      NULL,
      0.312607,
      1.496019,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1.389312,
      1,
      NULL,
      2,
      1.075811,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903194,
      NULL,
      0,
      3,
      0.893180,
      NULL,
      NULL,
      0.987364,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.012963,
      3.355113,
      0.475713,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      1.627771,
      3.385242,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.562421,
      6.515017,
      NULL,
      1.803776,
      3.469857,
      5,
      NULL,
      1.367188,
      NULL,
      5,
      3.494209,
      0.453676,
      264,
      NULL,
      0.446648,
      0.626716,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.635569,
      1,
      NULL,
      NULL,
      0.906811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      129.029003,
      18,
      NULL,
      NULL,
      0,
      1.060786,
      NULL,
      1,
      1,
      3,
      0,
      1.976479,
      0.839735,
      NULL,
      1,
      0.889686,
      0.784937,
      1.466935,
      1.811739,
      1.721584,
      NULL,
      1.728719,
      NULL,
      0.753116,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.996336,
      NULL,
      5.035252,
      NULL,
      NULL,
      24,
      NULL,
      0.584544,
      2.724234,
      NULL,
      NULL,
      NULL,
      NULL,
      1.460561,
      NULL,
      0,
      NULL,
      0.245040,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.094418,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.895180,
      NULL,
      1,
      3.581853,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.246357,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.623011,
      NULL,
      0.437884,
      NULL,
      NULL,
      NULL,
      1.468057,
      NULL,
      1,
      NULL,
      0.984701,
      1.442604,
      0.312955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.935049,
      0.990264,
      NULL,
      0.402773,
      1.190663,
      0,
      1.554957,
      0,
      0,
      3,
      2.056695,
      1,
      1,
      0.988792,
      1,
      0.626689,
      0,
      1.040406,
      1.505627,
      1.135299,
      NULL,
      NULL,
      0,
      0.824191,
      3.682361,
      2.910719,
      1.767564,
      0.227038,
      1.225141,
      0.016684,
      0,
      1.984492,
      3,
      0.742642,
      NULL,
      1,
      0.947021,
      3.093150,
      NULL,
      1.541033,
      1.480890,
      NULL,
      0,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.325972,
      1.644133,
      1.928912,
      2.969030,
      0.880281,
      3,
      1.245175,
      NULL,
      NULL,
      7,
      NULL,
      2,
      1,
      NULL,
      NULL,
      '02132',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


