set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8814999';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '4', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.337594,
      2,
      1.945270,
      NULL,
      1.394908,
      NULL,
      0,
      1.019087,
      '421',
      NULL,
      76.835111,
      39,
      '0212321',
      NULL,
      0.805100,
      NULL,
      0,
      '2043',
      5.512772,
      1.845292,
      NULL,
      NULL,
      ' 5-27-1979',
      91,
      3.909325,
      NULL,
      1.057861,
      NULL,
      ' 2-29-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 0-1980',
      3,
      0,
      0.212535,
      1.097057,
      0.720792,
      1.610037,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.764151,
      1.129156,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.995900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.948725,
      NULL,
      1.858492,
      0.334624,
      0.527960,
      1.969470,
      0.325001,
      0.900886,
      1.623925,
      0,
      0.993443,
      1.749032,
      NULL,
      0.251309,
      0.619882,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.403800,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.995245,
      1.802062,
      0.385245,
      1,
      0.767779,
      NULL,
      1.535433,
      1,
      1.669314,
      1.218311,
      0,
      NULL,
      NULL,
      1,
      1.233515,
      0,
      1,
      NULL,
      NULL,
      1.115385,
      1.342305,
      0,
      0.044376,
      1,
      0.597044,
      1.936115,
      0,
      0,
      1.690113,
      1.712153,
      1.789423,
      1,
      1,
      0,
      5,
      0.873991,
      NULL,
      3,
      0,
      0,
      1.344196,
      0,
      NULL,
      NULL,
      3,
      4.893232,
      1.928238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049421,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.025345,
      0.512977,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.233735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      3,
      0,
      1,
      1,
      0.625588,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      1.646055,
      NULL,
      3.498676,
      NULL,
      5,
      NULL,
      3,
      4,
      5.262516,
      1.921405,
      7.057216,
      0,
      1,
      7,
      3,
      0,
      4,
      0.530549,
      0,
      0,
      0,
      1.382055,
      1,
      0,
      0,
      0.187996,
      1.578081,
      3,
      0,
      6,
      8.696240,
      2.648268,
      NULL,
      NULL,
      3,
      1.832405,
      1,
      3,
      2,
      1,
      0.347622,
      57.074110,
      3.377840,
      1,
      37,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.760581,
      '11422',
      '24200',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      NULL,
      108,
      NULL,
      NULL,
      5,
      14.357845,
      2.537371,
      NULL,
      NULL,
      3,
      0.081982,
      NULL,
      NULL,
      NULL,
      1.273486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.370910,
      NULL,
      NULL,
      3,
      0.894197,
      1.963768,
      0.377258,
      NULL,
      NULL,
      2,
      1.746165,
      1.211246,
      0.771296,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.063426,
      NULL,
      NULL,
      11.545636,
      5.897877,
      1,
      0,
      0.040264,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.611876,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.177275,
      0.780418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      1.692174,
      NULL,
      NULL,
      NULL,
      3.141201,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.143358,
      3,
      1,
      NULL,
      6.915927,
      NULL,
      0.296339,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.394405,
      NULL,
      NULL,
      1.292268,
      NULL,
      NULL,
      3.296043,
      2,
      NULL,
      0.563066,
      NULL,
      NULL,
      3,
      4,
      NULL,
      4.429637,
      3.389392,
      0,
      0.498466,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.754364,
      1,
      1,
      3,
      0.647165,
      0.579021,
      NULL,
      1,
      6,
      3.899346,
      2.926086,
      2,
      1.350730,
      1,
      1.074168,
      1.118469,
      0,
      1,
      3.496689,
      NULL,
      NULL,
      7.834034,
      NULL,
      NULL,
      NULL,
      0.547296,
      0,
      1.655370,
      2,
      2.398873,
      1,
      NULL,
      0,
      0.729780,
      0,
      NULL,
      NULL,
      NULL,
      2.056728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.577487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.254964,
      NULL,
      NULL,
      3.061818,
      0.110845,
      0.434546,
      2,
      NULL,
      3,
      2,
      NULL,
      NULL,
      5,
      NULL,
      9,
      NULL,
      6,
      90.356064,
      0,
      NULL,
      1.859344,
      1,
      1,
      NULL,
      1,
      1.056232,
      1.387972,
      NULL,
      1,
      0.206911,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.845277,
      NULL,
      2.309604,
      NULL,
      2.386115,
      NULL,
      3.583241,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.384501,
      NULL,
      NULL,
      1.969553,
      1.029380,
      NULL,
      1.383804,
      1.071021,
      NULL,
      NULL,
      2.640740,
      NULL,
      NULL,
      NULL,
      1,
      0.538029,
      NULL,
      NULL,
      NULL,
      2.314411,
      1.978500,
      NULL,
      1.899125,
      3.201574,
      1.742691,
      NULL,
      0,
      0.922274,
      2,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0.138131,
      13.323895,
      NULL,
      NULL,
      4.285274,
      3,
      NULL,
      2,
      2,
      7.290805,
      NULL,
      2.969880,
      106.028568,
      8.921532,
      0.519556,
      NULL,
      0.358222,
      NULL,
      NULL,
      NULL,
      2.849510,
      NULL,
      8.491828,
      NULL,
      NULL,
      NULL,
      1.407768,
      NULL,
      NULL,
      1,
      NULL,
      1.573847,
      415,
      6.095071,
      1,
      0.089833,
      1.036774,
      0.522043,
      1,
      0,
      0,
      0,
      1,
      0,
      1.920921,
      1,
      1.715874,
      NULL,
      1,
      1,
      0,
      3,
      NULL,
      0.532006,
      NULL,
      1.019994,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.682130,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      42,
      0.809708,
      1.447654,
      0,
      NULL,
      3.453353,
      NULL,
      NULL,
      NULL,
      2.092207,
      NULL,
      0.582864,
      NULL,
      1.677464,
      NULL,
      0.103751,
      NULL,
      0.514514,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.708957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831220,
      NULL,
      1.652877,
      3.723373,
      1.101794,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484043,
      0.754779,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.599120,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.313236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.965868,
      1.147892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.388455,
      0,
      1.733975,
      3.865275,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236978,
      0.121325,
      1,
      0.648315,
      1.546759,
      0,
      1,
      1.454943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921066,
      1.639949,
      1.140366,
      3.769625,
      0.516628,
      0,
      NULL,
      0.459530,
      0.003949,
      3.015155,
      3,
      2,
      1.118541,
      1.474551,
      1.765871,
      3.110968,
      2.100802,
      NULL,
      1,
      0.791953,
      0.559899,
      0,
      1.872610,
      NULL,
      3.901982,
      1.297687,
      2.019600,
      1.256813,
      0,
      0.099095,
      0.715921,
      1.646075,
      0.594219,
      1.261416,
      3,
      3.520821,
      0,
      1,
      3.626608,
      0.514264,
      1,
      0.838821,
      0.086342,
      0,
      1.258507,
      3.039212,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292742,
      0,
      1,
      0,
      0,
      0,
      1.070860,
      7.173256,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      1,
      0.803382,
      3.928389,
      NULL,
      '00411',
      NULL,
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


