set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9405403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '3413133',
      2.827724,
      1.733201,
      0,
      1,
      NULL,
      0.669598,
      1.404128,
      NULL,
      NULL,
      ' 5- 2-1991',
      17.126792,
      NULL,
      1,
      1.201884,
      1,
      ' 2-20-1985',
      25.999018,
      NULL,
      73.560821,
      88,
      5.229890,
      NULL,
      NULL,
      ' 7-18-1994',
      2,
      1.102081,
      0,
      1.997773,
      NULL,
      0,
      0,
      0.794606,
      NULL,
      NULL,
      NULL,
      8.736229,
      5.088153,
      24.971576,
      29.459401,
      NULL,
      0,
      NULL,
      0.932465,
      6,
      0,
      3.578067,
      1,
      NULL,
      1.057402,
      NULL,
      0,
      NULL,
      1.188497,
      1,
      1,
      3.435093,
      5,
      5.332621,
      NULL,
      0,
      0.484523,
      1.595634,
      NULL,
      NULL,
      1.489657,
      1.493544,
      1.777028,
      0,
      1.914745,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.225585,
      1,
      2,
      3.195713,
      1.040032,
      0,
      2.795441,
      0.634325,
      1,
      2.249683,
      2.498702,
      1,
      NULL,
      NULL,
      0.549086,
      NULL,
      1,
      0.390004,
      1,
      0.229869,
      3.335187,
      0,
      8,
      0,
      4.406393,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.269606,
      0,
      0,
      1,
      1,
      NULL,
      0.527191,
      0.941523,
      0,
      1,
      1,
      1.799892,
      0.943135,
      NULL,
      1.880503,
      0,
      1.562310,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.288506,
      NULL,
      0.989453,
      NULL,
      1,
      1,
      1,
      1.666304,
      0,
      1,
      NULL,
      0,
      2,
      1.156961,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      1.767376,
      ' 8-18-1979',
      254,
      ' 7- 6-1977',
      NULL,
      1.037477,
      NULL,
      0.565353,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.063624,
      NULL,
      1,
      1,
      1,
      1.437498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9,
      3.291967,
      NULL,
      NULL,
      1,
      1,
      3.561091,
      1.285867,
      0.644566,
      NULL,
      NULL,
      0.972070,
      1.943130,
      0.093246,
      0.077234,
      NULL,
      NULL,
      4,
      0.151693,
      3,
      1,
      11,
      NULL,
      NULL,
      5,
      0.001221,
      0.228811,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.819447,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      3,
      9,
      0,
      1.659040,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      3,
      0,
      1.455189,
      2.363695,
      0,
      NULL,
      0,
      1.901222,
      0,
      1,
      1,
      1,
      1.902332,
      NULL,
      0,
      0.911884,
      1,
      1,
      0,
      1.875488,
      NULL,
      1,
      0.486304,
      0,
      1.551191,
      1.905125,
      1,
      1,
      1.824178,
      7,
      3,
      11,
      7.780736,
      4.063975,
      1.694708,
      2.734735,
      0.694169,
      3.479479,
      2,
      0,
      66,
      1,
      NULL,
      NULL,
      8.573754,
      NULL,
      NULL,
      0,
      NULL,
      2.263563,
      '41404',
      NULL,
      NULL,
      0.970517,
      '',
      '',
      '',
      0.999181,
      NULL,
      NULL,
      '',
      1,
      6,
      24,
      1.733076,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.123515,
      NULL,
      NULL,
      1.384931,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.107333,
      NULL,
      NULL,
      0.980956,
      NULL,
      NULL,
      1.610621,
      NULL,
      NULL,
      1.920816,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185961,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.573344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.056135,
      NULL,
      1,
      NULL,
      NULL,
      1.551711,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.188866,
      2,
      NULL,
      3.037090,
      NULL,
      1,
      3.248082,
      0,
      0,
      3.372477,
      1,
      1,
      0.953688,
      1,
      NULL,
      NULL,
      3.806584,
      NULL,
      3.587672,
      0.217358,
      NULL,
      NULL,
      4,
      5,
      0,
      0,
      0.920247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452102,
      NULL,
      NULL,
      0.995138,
      NULL,
      NULL,
      1.276442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.389648,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.792500,
      NULL,
      NULL,
      0.268138,
      NULL,
      NULL,
      0.680117,
      NULL,
      NULL,
      1.272146,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475687,
      NULL,
      NULL,
      1.927204,
      NULL,
      NULL,
      1.954673,
      NULL,
      NULL,
      0.809658,
      NULL,
      NULL,
      1,
      2.887539,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.847328,
      2.673578,
      2,
      NULL,
      NULL,
      0.769072,
      NULL,
      NULL,
      3.626205,
      NULL,
      NULL,
      1,
      2,
      2.690011,
      1.182865,
      1.109434,
      1.727806,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.633814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.597571,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.829834,
      1,
      NULL,
      1.202677,
      1,
      3.019551,
      2,
      NULL,
      NULL,
      3.646047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.441610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.253048,
      1.436736,
      NULL,
      NULL,
      0.810405,
      0,
      NULL,
      NULL,
      1.805688,
      1,
      NULL,
      NULL,
      0.503529,
      NULL,
      NULL,
      NULL,
      1.259337,
      1.450000,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.145001,
      NULL,
      NULL,
      NULL,
      1,
      0.073632,
      2.140058,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      187,
      0.242420,
      0,
      0.440318,
      1.840930,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0.575649,
      1,
      0.920458,
      0,
      1.918482,
      0.058318,
      0,
      0.847547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.324452,
      1,
      NULL,
      NULL,
      1.008346,
      1.103010,
      1.640543,
      1,
      2.384283,
      1,
      1,
      0,
      1.332292,
      0,
      0.351763,
      1,
      0.530512,
      1.447977,
      NULL,
      0.419971,
      1,
      NULL,
      0.215460,
      NULL,
      1,
      0.863969,
      0,
      1,
      0.465564,
      0.734820,
      1.587716,
      1,
      0.917011,
      1.713072,
      NULL,
      1.258686,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.492428,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780365,
      1.686787,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.207010,
      0,
      NULL,
      NULL,
      NULL,
      148,
      0.019464,
      NULL,
      3.119852,
      '40131',
      '',
      NULL,
      1.392181,
      '',
      '',
      '',
      NULL,
      '2000',
      '',
      '');
commit;
end;
/


