set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420564';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1430133',
      1,
      0,
      6,
      3,
      '4123',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.650323,
      1.100491,
      NULL,
      ' 3-15-1983',
      31,
      0,
      NULL,
      25,
      1,
      ' 4-13-1993',
      ' 4-22-2000',
      ' 0-13-1996',
      NULL,
      1,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      1.496425,
      13.116913,
      NULL,
      12,
      NULL,
      7.639039,
      NULL,
      NULL,
      21.137960,
      9,
      3.807480,
      NULL,
      NULL,
      5.248664,
      1.894226,
      0,
      1.099392,
      1,
      0,
      1,
      NULL,
      3,
      1.965779,
      2,
      NULL,
      2.807016,
      2,
      7,
      1,
      1,
      1,
      0.643148,
      1,
      5.330965,
      0.038170,
      1,
      1,
      0,
      1.830617,
      2,
      1,
      1,
      NULL,
      1,
      0.057336,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      0,
      0,
      1.749202,
      NULL,
      1.329603,
      0,
      NULL,
      1,
      0,
      0.738648,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      3.978012,
      1.621385,
      4.033443,
      3,
      1,
      2.038832,
      0,
      NULL,
      NULL,
      1.981362,
      NULL,
      NULL,
      1,
      3,
      3,
      1.492695,
      0,
      1.337680,
      0,
      0,
      1,
      0,
      1,
      0.170916,
      1,
      1.023437,
      NULL,
      0.938885,
      NULL,
      0.351803,
      NULL,
      NULL,
      0.889859,
      1,
      0.391089,
      NULL,
      6,
      1.155516,
      3.453090,
      NULL,
      0.312149,
      2,
      0.724579,
      1,
      6.371599,
      1.351598,
      0.356593,
      3,
      4,
      6.236352,
      8,
      8.733901,
      6,
      5.734726,
      NULL,
      2,
      2.178670,
      0.945643,
      NULL,
      NULL,
      NULL,
      7.408382,
      NULL,
      6.536742,
      1,
      1.727159,
      0,
      5.035876,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0.189322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.638447,
      1.151016,
      0.494677,
      1.853250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.979165,
      2,
      1.228374,
      NULL,
      NULL,
      NULL,
      6.987451,
      NULL,
      7.041085,
      3,
      0,
      3.326471,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      1.427794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.937455,
      NULL,
      0,
      1.346276,
      1,
      0.117736,
      0,
      166,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.378337,
      0,
      1,
      4,
      5.505479,
      1,
      NULL,
      1.864685,
      3.243939,
      1,
      2.889882,
      NULL,
      0,
      NULL,
      2.240724,
      NULL,
      0,
      NULL,
      1,
      3,
      1.242021,
      0,
      1,
      1.197452,
      0,
      0.941777,
      0,
      1,
      0,
      0.194544,
      2.762902,
      1,
      11,
      0.612495,
      3,
      7.073142,
      6,
      3,
      0.868974,
      1.193384,
      0,
      NULL,
      2.930608,
      3,
      42,
      NULL,
      NULL,
      NULL,
      37,
      63,
      71.118265,
      3,
      5.820664,
      NULL,
      '24204',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.080978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.385617,
      7,
      0.635004,
      0.303668,
      NULL,
      NULL,
      0.270517,
      NULL,
      NULL,
      0.603481,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.334138,
      NULL,
      NULL,
      0,
      NULL,
      1,
      58,
      NULL,
      1.988851,
      NULL,
      0,
      1,
      1.773143,
      1,
      1.615666,
      1.778674,
      0.228509,
      1,
      1,
      NULL,
      0.029896,
      0,
      1.372251,
      1,
      1.534543,
      1.221701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968454,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.273416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719403,
      0,
      NULL,
      2.768925,
      NULL,
      3.285887,
      NULL,
      4,
      NULL,
      1.737392,
      NULL,
      0.253595,
      NULL,
      0,
      NULL,
      3.672434,
      33.328084,
      28.288903,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355619,
      0.289564,
      NULL,
      4,
      NULL,
      1.311580,
      0,
      2,
      NULL,
      3.997762,
      3,
      1,
      1.525319,
      NULL,
      0,
      0,
      1.285949,
      1,
      1.985854,
      NULL,
      NULL,
      1,
      0.262947,
      NULL,
      0,
      1,
      0.316284,
      1,
      0.476760,
      0.733267,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404259,
      3.903909,
      1.595720,
      1,
      0,
      2,
      0,
      1,
      NULL,
      1,
      3.524123,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.056698,
      1,
      0.331247,
      0,
      NULL,
      7,
      1.085986,
      0.262125,
      NULL,
      NULL,
      74,
      63,
      3,
      4.665223,
      1.956834,
      NULL,
      '24420',
      '',
      0.649108,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


