set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9329516';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-11-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '2120113',
      3,
      0.500721,
      2,
      NULL,
      '3220',
      NULL,
      0,
      NULL,
      NULL,
      ' 7- 0-1984',
      NULL,
      NULL,
      1,
      3.589698,
      0,
      ' 3-25-1976',
      24.949825,
      NULL,
      184,
      121.172070,
      3.818225,
      NULL,
      ' 4-28-1974',
      ' 8-23-1975',
      0.593958,
      2.104411,
      NULL,
      1.212798,
      0,
      1,
      3,
      NULL,
      0.418085,
      NULL,
      4,
      4,
      2.108178,
      NULL,
      25,
      NULL,
      22.052577,
      NULL,
      0,
      2,
      1.841344,
      NULL,
      1.441244,
      0.249193,
      1.062343,
      0.795007,
      0,
      0,
      1,
      0,
      0.007882,
      2.913854,
      1.524811,
      NULL,
      3.050486,
      NULL,
      0,
      1,
      9,
      0.335800,
      0.498962,
      1.263629,
      1.863095,
      1,
      3.677451,
      NULL,
      NULL,
      8,
      0.290497,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.453706,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0.278065,
      3,
      2.202205,
      1.252514,
      3.341622,
      NULL,
      NULL,
      1,
      1.788385,
      1,
      2.800100,
      0,
      0,
      NULL,
      4.444470,
      0.249040,
      2.463830,
      2.456028,
      1.349063,
      NULL,
      NULL,
      0.364816,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      4,
      0.358149,
      3,
      2,
      1,
      NULL,
      0,
      1.626727,
      7.788694,
      NULL,
      NULL,
      0.837366,
      1.515085,
      1,
      NULL,
      1,
      1,
      9,
      0,
      0.770735,
      3.285276,
      4,
      1.539973,
      0.783190,
      0.409641,
      0.153856,
      0.954365,
      1,
      1.427537,
      1.535228,
      1,
      7.496191,
      NULL,
      NULL,
      1.373129,
      3,
      1.108942,
      2.004422,
      2.469372,
      1,
      NULL,
      2,
      2.803896,
      '11-21-1988',
      31.633910,
      '10- 5-1998',
      50.388629,
      0.596882,
      0,
      0.596576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.634301,
      9.728406,
      0.739090,
      NULL,
      0.659496,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.252703,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.885867,
      NULL,
      NULL,
      1.503345,
      0,
      2.232889,
      0.687361,
      NULL,
      NULL,
      NULL,
      1.712861,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863759,
      1.748886,
      NULL,
      1,
      1.099028,
      0,
      NULL,
      NULL,
      6.096254,
      3,
      1.525131,
      NULL,
      NULL,
      NULL,
      1.310197,
      0,
      NULL,
      3.233842,
      0,
      0.802614,
      1,
      2.633336,
      NULL,
      1,
      NULL,
      0.551538,
      NULL,
      3.121775,
      0,
      3,
      1.196976,
      0.898300,
      0,
      2,
      NULL,
      0.962474,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.266583,
      1.207611,
      7.415398,
      6,
      5.078061,
      10,
      4,
      4,
      3.906841,
      3.958598,
      4.132367,
      2.231955,
      NULL,
      2.652666,
      67,
      2,
      0,
      NULL,
      49.157343,
      34,
      7,
      NULL,
      0,
      1.194104,
      '32133',
      '',
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      15,
      NULL,
      NULL,
      0,
      NULL,
      0.799626,
      NULL,
      0.977394,
      0.306481,
      2.231972,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.402488,
      NULL,
      NULL,
      2.250503,
      2.403326,
      0.488550,
      0.573404,
      NULL,
      3.058695,
      NULL,
      3.667345,
      3,
      0,
      NULL,
      NULL,
      0.677775,
      NULL,
      NULL,
      3,
      3.746882,
      1.807466,
      1,
      2.018009,
      0,
      0,
      NULL,
      NULL,
      3.011106,
      7.423135,
      7,
      1.115823,
      0,
      NULL,
      NULL,
      NULL,
      0.266338,
      NULL,
      NULL,
      NULL,
      0,
      3.224735,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.614818,
      0,
      0,
      3,
      2.452853,
      1.209970,
      NULL,
      2,
      1,
      1.544657,
      1,
      NULL,
      1,
      1,
      0,
      2.032529,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.392890,
      0.789038,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.346945,
      2,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.594197,
      1.950982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.279768,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.161116,
      NULL,
      NULL,
      2.666910,
      1,
      1,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.925100,
      NULL,
      NULL,
      1.699047,
      2,
      2,
      1.794825,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.815876,
      1,
      2,
      NULL,
      0,
      0,
      1,
      0,
      1,
      3,
      3.857227,
      3.497531,
      2,
      1.767423,
      2.761952,
      1,
      NULL,
      NULL,
      NULL,
      0.614304,
      NULL,
      1,
      NULL,
      0.873517,
      0.865421,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805708,
      NULL,
      NULL,
      1.657096,
      NULL,
      NULL,
      0.378740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.714808,
      NULL,
      NULL,
      1.219807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399509,
      NULL,
      NULL,
      NULL,
      1.264389,
      0.977495,
      1.517299,
      NULL,
      2.005970,
      0.423791,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.867039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.165649,
      NULL,
      NULL,
      NULL,
      1.532936,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.268418,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.351293,
      NULL,
      2.127884,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.220370,
      0.627210,
      3.198612,
      0.764735,
      0,
      1.540270,
      0,
      1,
      1,
      0,
      1,
      0.362381,
      0.590440,
      0.582351,
      0.221553,
      1.727121,
      1.565846,
      1.551058,
      1,
      0,
      3,
      NULL,
      0,
      NULL,
      1.450454,
      NULL,
      0,
      NULL,
      0.985866,
      NULL,
      0,
      NULL,
      1.372856,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.761103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073562,
      0.736058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410185,
      1.995837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759944,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982345,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.854291,
      0.631815,
      0,
      NULL,
      1.431904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.653382,
      NULL,
      1,
      1,
      2,
      5.031583,
      18.453158,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642317,
      1.687085,
      0.328805,
      NULL,
      0,
      1.793806,
      1,
      0.321122,
      3,
      NULL,
      1,
      0,
      2.744192,
      3.814378,
      NULL,
      1,
      0.542390,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3.341395,
      NULL,
      2,
      2,
      NULL,
      0,
      0,
      NULL,
      1.439150,
      1.367907,
      NULL,
      0.455182,
      2,
      NULL,
      1,
      1.533409,
      NULL,
      1,
      NULL,
      NULL,
      3.915318,
      2,
      NULL,
      3.457898,
      1,
      2.098403,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.841526,
      NULL,
      0.927653,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.929953,
      NULL,
      1,
      NULL,
      NULL,
      1.093045,
      0.318327,
      3.751613,
      0,
      NULL,
      2.830630,
      NULL,
      1.050693,
      NULL,
      1.302318,
      NULL,
      0.273581,
      NULL,
      NULL,
      NULL,
      3.022447,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.258355,
      NULL,
      1.783168,
      NULL,
      NULL,
      NULL,
      14.247906,
      1.940010,
      839.824992,
      0,
      NULL,
      0,
      NULL,
      0.758588,
      NULL,
      0.388731,
      NULL,
      NULL,
      0.391109,
      NULL,
      NULL,
      74,
      40.119617,
      3.055638,
      1,
      2,
      '44101',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '');
commit;
end;
/


