set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9414576';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3303120',
      0.776978,
      NULL,
      NULL,
      3,
      '0131',
      1,
      0,
      NULL,
      NULL,
      ' 2-17-1993',
      57,
      NULL,
      NULL,
      1.446450,
      1.274634,
      ' 9-12-1977',
      29,
      2.825112,
      103.202352,
      105.123479,
      5,
      NULL,
      NULL,
      '11-28-1975',
      1.281244,
      0,
      0.369189,
      1.368341,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      10.566248,
      11,
      9,
      NULL,
      12.146636,
      4.744992,
      25.186381,
      0,
      1,
      6.492168,
      1.026588,
      NULL,
      0.184100,
      NULL,
      0.034702,
      0,
      NULL,
      0.333986,
      1,
      NULL,
      NULL,
      3.733905,
      2,
      1,
      3.457191,
      6,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1,
      NULL,
      0.907949,
      7.859006,
      0,
      1,
      1,
      0.278034,
      0,
      3,
      1.602136,
      NULL,
      NULL,
      0.341919,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.798076,
      0,
      0.978939,
      0.424611,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.086682,
      0.417540,
      0,
      2.817980,
      0.579361,
      0,
      1,
      1.034236,
      6.268538,
      0.239278,
      1,
      NULL,
      0.397044,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.509957,
      2.837732,
      1.711487,
      NULL,
      NULL,
      1.659973,
      1.148762,
      1.447778,
      NULL,
      1,
      1.373613,
      0,
      0,
      0.466478,
      1,
      NULL,
      0.058022,
      NULL,
      NULL,
      1,
      NULL,
      1.662255,
      0.612157,
      NULL,
      1,
      4.406091,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      4.600764,
      1,
      0,
      5.451601,
      1.274672,
      3,
      3,
      1,
      4,
      2.053780,
      NULL,
      1,
      0.454079,
      1.480000,
      0,
      ' 1-29-1980',
      227,
      ' 6-22-1993',
      9,
      1.659017,
      NULL,
      NULL,
      2.739098,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022684,
      0,
      1,
      1.172195,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      190.830113,
      0.320467,
      3.625972,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.235717,
      3,
      0.008073,
      1.955049,
      1.787373,
      0,
      NULL,
      4.263941,
      NULL,
      4.970593,
      2,
      1.856928,
      NULL,
      NULL,
      1.472571,
      1.971390,
      1.042960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.974627,
      0.835371,
      1.465644,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224935,
      1.924769,
      NULL,
      0.404565,
      2.804206,
      1,
      0.837090,
      2,
      NULL,
      1,
      2.202252,
      2,
      0.396138,
      1.105037,
      17,
      5,
      NULL,
      164.786824,
      NULL,
      128,
      NULL,
      115.469297,
      12.296829,
      131,
      197,
      143,
      148,
      53,
      NULL,
      9.218541,
      17.103908,
      1.637090,
      6,
      NULL,
      3,
      6.610753,
      7.009900,
      1.633842,
      2.701407,
      1.660147,
      NULL,
      3,
      NULL,
      0.388672,
      23,
      NULL,
      1,
      65,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      '34202',
      '',
      '',
      0.394152,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      53.628681,
      37,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.636139,
      3.362954,
      0.174271,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.502932,
      2,
      1,
      0,
      3.865526,
      2,
      0,
      NULL,
      NULL,
      0.553760,
      2.389931,
      NULL,
      0,
      1,
      1.051607,
      2,
      0,
      2,
      1.442007,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.042607,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.322159,
      1,
      NULL,
      NULL,
      1.168058,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      NULL,
      0.531324,
      1,
      0.088212,
      NULL,
      2.723642,
      1,
      1,
      1.036845,
      2,
      0,
      3.304779,
      1.860899,
      3.144675,
      2,
      1.081533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1.718321,
      0,
      1.399959,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.472336,
      NULL,
      NULL,
      2.031849,
      1,
      NULL,
      3,
      2.886919,
      2,
      1,
      NULL,
      NULL,
      0.752439,
      NULL,
      4.259259,
      1.877277,
      NULL,
      NULL,
      1.339313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734988,
      NULL,
      NULL,
      0.525238,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.270818,
      NULL,
      NULL,
      0.959141,
      NULL,
      NULL,
      1,
      1.685400,
      0.547686,
      1,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.425767,
      NULL,
      NULL,
      NULL,
      4,
      3.068286,
      1.937250,
      0.739592,
      NULL,
      0.495652,
      3.979768,
      3.696042,
      0,
      3.956352,
      0.194936,
      1,
      1,
      0,
      NULL,
      3,
      5.524524,
      1,
      NULL,
      NULL,
      NULL,
      1.114977,
      2,
      1.077063,
      1.553780,
      0,
      0.970247,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.039965,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.677728,
      NULL,
      NULL,
      1.647308,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.749198,
      0,
      0.461455,
      1.955612,
      1.088707,
      NULL,
      NULL,
      NULL,
      1.989589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.882276,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.830814,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.282051,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.544593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.987295,
      NULL,
      NULL,
      0.106239,
      NULL,
      NULL,
      NULL,
      2,
      31,
      NULL,
      0.784481,
      14,
      2,
      1.537530,
      NULL,
      NULL,
      1.806253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.756415,
      0.689845,
      1.113362,
      NULL,
      1,
      0,
      1.089642,
      0,
      0,
      1,
      1.182074,
      NULL,
      0,
      1.488893,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577128,
      NULL,
      1.591232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946315,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324297,
      1.495636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022273,
      1.927550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.579700,
      1,
      0.841904,
      NULL,
      NULL,
      NULL,
      0.460374,
      0.862886,
      1,
      NULL,
      NULL,
      NULL,
      1.787327,
      0.313863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.259658,
      2.792833,
      NULL,
      5,
      NULL,
      0.776450,
      0,
      3,
      5.682173,
      3,
      NULL,
      3.746088,
      1.504032,
      0.810763,
      1,
      NULL,
      3.038090,
      1,
      NULL,
      3.745233,
      1,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      2,
      2.840544,
      1,
      2,
      2.026588,
      0,
      0.902871,
      0.760013,
      1,
      0.348001,
      NULL,
      1,
      1.159059,
      0,
      0,
      0,
      0,
      0,
      2,
      0,
      0.971951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.171805,
      1.400187,
      1,
      0.591323,
      1,
      3.549030,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      59.032586,
      NULL,
      1,
      NULL,
      '20331',
      '',
      '',
      0,
      '',
      '',
      NULL,
      1.236403,
      '',
      NULL,
      '');
commit;
end;
/


