set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7515184';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '3134122',
      2,
      0.241873,
      NULL,
      2,
      '2030',
      3,
      1.804906,
      NULL,
      NULL,
      '10-25-1983',
      9.017884,
      NULL,
      1,
      0.065539,
      0,
      ' 9-18-1998',
      43,
      3,
      24,
      63,
      0,
      ' 6- 8-1989',
      NULL,
      ' 2-14-1977',
      NULL,
      NULL,
      3,
      1.386221,
      0,
      0.092104,
      1,
      1.150063,
      0,
      NULL,
      12,
      4,
      2.867243,
      9.064054,
      0.810110,
      NULL,
      NULL,
      3.444112,
      7.755901,
      8.061184,
      1.401259,
      1,
      1.362765,
      1,
      0,
      1.015209,
      1.525431,
      0.487055,
      0,
      0,
      0,
      3,
      1,
      3.682577,
      0.022383,
      0.696722,
      1.311475,
      11.035571,
      0,
      0.283984,
      10,
      1,
      7,
      NULL,
      NULL,
      NULL,
      0.938838,
      9,
      4,
      2,
      NULL,
      1.888895,
      0.954377,
      NULL,
      NULL,
      1.839620,
      NULL,
      NULL,
      1.796046,
      3,
      NULL,
      3.997348,
      NULL,
      1.841955,
      NULL,
      0.854968,
      0,
      0.835427,
      1.394823,
      0,
      0.320647,
      NULL,
      0,
      0,
      0.430814,
      0,
      NULL,
      3,
      1,
      1,
      NULL,
      5,
      2.833889,
      1,
      NULL,
      NULL,
      NULL,
      1.056642,
      NULL,
      NULL,
      7.696405,
      11,
      1.389884,
      0,
      11,
      9.293718,
      1,
      NULL,
      3.320630,
      0,
      0.942205,
      0.430820,
      0.728889,
      1.507149,
      1.269647,
      NULL,
      1,
      1,
      0.401310,
      NULL,
      0.732067,
      NULL,
      9,
      NULL,
      NULL,
      1,
      7,
      2.552845,
      1.498513,
      0.275362,
      3,
      0.995647,
      1.074382,
      5,
      0.564906,
      NULL,
      8,
      0.791880,
      6.357354,
      9,
      3.882903,
      5,
      0,
      2,
      3.434307,
      8.141443,
      10,
      1,
      '10- 5-1986',
      7,
      ' 8- 9-1981',
      42,
      2.423558,
      0.420980,
      2,
      6.886393,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.922218,
      0.523745,
      1.924688,
      0.866571,
      0,
      0.706906,
      0.367244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.946093,
      2.243621,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.760310,
      NULL,
      1,
      2.246759,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3.546988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.858032,
      NULL,
      1,
      1.021873,
      0,
      NULL,
      0,
      2.393823,
      2,
      0,
      1.607328,
      10.249283,
      3,
      0.509900,
      1.671549,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867769,
      10.454979,
      11,
      17.191793,
      NULL,
      178.058434,
      1,
      0.076656,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.356556,
      1,
      NULL,
      8.204158,
      0.176340,
      7.995620,
      10.413391,
      5,
      7.964366,
      3,
      2,
      2,
      3,
      4.010995,
      2,
      0,
      3,
      11.749434,
      2.240684,
      2,
      NULL,
      9.548091,
      27.079466,
      16.114160,
      5.202858,
      NULL,
      1,
      '40342',
      '',
      '',
      2.243836,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      3.553996,
      12,
      NULL,
      NULL,
      3,
      33,
      3,
      6,
      3.828385,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      0.056784,
      NULL,
      NULL,
      NULL,
      3.428030,
      0.391084,
      2,
      0,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0.281797,
      NULL,
      NULL,
      0.380991,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1.280184,
      0,
      6,
      1.154057,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.223408,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.296348,
      NULL,
      NULL,
      1.622333,
      1,
      1.635961,
      0.985229,
      0,
      1,
      1,
      0,
      NULL,
      0.379497,
      NULL,
      NULL,
      1.316999,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.268336,
      NULL,
      NULL,
      NULL,
      3.339296,
      7.651050,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.047778,
      NULL,
      NULL,
      NULL,
      0.502889,
      NULL,
      NULL,
      NULL,
      1.475505,
      NULL,
      1.054374,
      NULL,
      NULL,
      1.729251,
      NULL,
      NULL,
      7.204967,
      2,
      6.295332,
      3,
      2.238304,
      2.348522,
      3,
      3,
      3,
      3,
      7.199142,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.434382,
      NULL,
      NULL,
      0.363846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.978768,
      2.054839,
      1.254512,
      4,
      NULL,
      2,
      5,
      6.185979,
      4,
      NULL,
      NULL,
      NULL,
      2.960457,
      0.166917,
      3.112784,
      2.772099,
      1.010992,
      2.241222,
      NULL,
      NULL,
      NULL,
      8.729272,
      NULL,
      NULL,
      2.392062,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1,
      2.831564,
      0,
      3,
      3.575039,
      2.870813,
      6.822970,
      7,
      6.354514,
      3,
      5,
      0,
      2,
      NULL,
      1,
      0.995108,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.961976,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.764202,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.506254,
      NULL,
      NULL,
      0.170433,
      1.344380,
      0,
      1.335629,
      0,
      2.398194,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.492556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.835336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.274047,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.845710,
      5,
      NULL,
      3.802230,
      NULL,
      3,
      2.818666,
      55,
      2.096321,
      0,
      NULL,
      NULL,
      1.757451,
      11.753352,
      2,
      2.253097,
      1.297267,
      2.228093,
      0,
      NULL,
      NULL,
      NULL,
      8,
      1.824703,
      3897.714103,
      1,
      1.683431,
      1,
      1.202260,
      0,
      1.755350,
      0,
      1.675925,
      0,
      1.019819,
      1.331266,
      0,
      1.785087,
      0,
      0,
      1,
      1.406872,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.735216,
      NULL,
      1,
      NULL,
      1,
      2.872862,
      14.128041,
      NULL,
      2,
      1,
      1.869601,
      1.640513,
      NULL,
      0.657958,
      1.379230,
      NULL,
      1.525528,
      NULL,
      NULL,
      0.352945,
      1.706400,
      NULL,
      2.474774,
      2.989005,
      NULL,
      2,
      NULL,
      NULL,
      1.546357,
      NULL,
      NULL,
      NULL,
      0.803610,
      NULL,
      1.377343,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293160,
      NULL,
      NULL,
      2.754472,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450916,
      NULL,
      1.093387,
      NULL,
      2,
      9,
      2,
      0,
      0.257753,
      3.936449,
      NULL,
      48,
      NULL,
      2.212304,
      0.788931,
      NULL,
      '',
      '',
      3,
      '314',
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


