set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8109594';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-3-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '4002212',
      0,
      0.978629,
      1,
      3,
      '2001',
      3,
      1,
      NULL,
      NULL,
      '11-15-2000',
      59,
      NULL,
      3.910247,
      1,
      0,
      ' 9-19-1984',
      NULL,
      2,
      213.138638,
      19,
      NULL,
      ' 4-23-1998',
      ' 6-15-1975',
      ' 3-12-1986',
      3.677435,
      1,
      3.149448,
      1.102794,
      0.463986,
      3,
      2.624905,
      1,
      1,
      NULL,
      0,
      3.581538,
      0,
      191.056923,
      97.942691,
      2.777476,
      19,
      3,
      NULL,
      5.774690,
      NULL,
      0,
      0.369594,
      0.458679,
      NULL,
      0,
      1,
      NULL,
      0.694337,
      53.488309,
      0,
      12,
      NULL,
      10.737393,
      NULL,
      11,
      NULL,
      3.511169,
      0.272335,
      8,
      6.901896,
      3.503318,
      1,
      1,
      1.281047,
      0,
      0.488663,
      9,
      1.161851,
      0,
      4.946802,
      0.125333,
      1,
      NULL,
      NULL,
      1.899637,
      NULL,
      NULL,
      6,
      NULL,
      3,
      1.933157,
      1,
      NULL,
      0,
      NULL,
      0,
      1.105167,
      NULL,
      1,
      1.817520,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0.566933,
      1,
      1.128593,
      4.359874,
      1.119176,
      1.134468,
      NULL,
      0,
      NULL,
      NULL,
      1.522615,
      NULL,
      NULL,
      0.397797,
      NULL,
      5.678646,
      1.575007,
      9.876129,
      3,
      NULL,
      1.960309,
      1,
      4,
      NULL,
      NULL,
      1,
      9,
      1.180407,
      1.436123,
      1,
      1,
      1,
      NULL,
      0.076172,
      1.197666,
      9.431887,
      1,
      2,
      2,
      7.452050,
      3.601052,
      1.941046,
      1.254468,
      2,
      NULL,
      1.539875,
      4.177695,
      NULL,
      4,
      7,
      NULL,
      2.009465,
      2.198052,
      7.657158,
      0,
      2,
      NULL,
      NULL,
      1.226103,
      0,
      3.329701,
      ' 5-28-1990',
      NULL,
      ' 5-17-2001',
      NULL,
      NULL,
      3,
      1.149252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.710445,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      2.991875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344244,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.692742,
      3.363817,
      3,
      NULL,
      0.466017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422587,
      0.310155,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.618378,
      2.813513,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.053512,
      0.693241,
      1.335553,
      1,
      1,
      0.634387,
      NULL,
      1.580482,
      1.673415,
      NULL,
      NULL,
      NULL,
      2,
      1.727149,
      1.912970,
      3,
      0.502959,
      1.789871,
      3,
      3.949056,
      1,
      3.776968,
      0.672574,
      1.455410,
      3.234555,
      1,
      0.639510,
      3.767475,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.788014,
      2,
      0.072593,
      0.488918,
      NULL,
      NULL,
      1,
      0,
      0.186294,
      9,
      NULL,
      11.273334,
      10.717846,
      0,
      1.386840,
      0,
      5.401628,
      NULL,
      1,
      0,
      3.009668,
      1,
      NULL,
      NULL,
      14.005227,
      3,
      NULL,
      6.235284,
      1.466431,
      3.555602,
      '24132',
      '',
      NULL,
      1,
      '',
      '',
      '',
      2,
      NULL,
      '',
      '',
      1,
      NULL,
      115.192003,
      9.697027,
      2.870358,
      38.216724,
      3,
      0.595932,
      0,
      0,
      3,
      0.237453,
      0,
      1,
      1.046584,
      2,
      0,
      1,
      1.916375,
      NULL,
      NULL,
      0.958322,
      1.337088,
      2.482672,
      1.509916,
      NULL,
      NULL,
      1,
      2.040342,
      1.217227,
      0.467189,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.653492,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.814365,
      NULL,
      NULL,
      NULL,
      1,
      2.722835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.695436,
      0.245386,
      0,
      5.067660,
      0.577639,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660060,
      0.623231,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4.674240,
      7.012175,
      NULL,
      1.306337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.138114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.242461,
      NULL,
      NULL,
      0.642817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.535439,
      1.748283,
      NULL,
      NULL,
      1.184558,
      1.033981,
      NULL,
      NULL,
      NULL,
      1.321914,
      1.608451,
      1.696641,
      NULL,
      NULL,
      NULL,
      0.869102,
      0,
      2.715179,
      NULL,
      NULL,
      1.422979,
      3.139792,
      4,
      2,
      1.294311,
      0,
      NULL,
      NULL,
      9,
      NULL,
      4.978300,
      3.456077,
      3,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908903,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.147698,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.525620,
      NULL,
      NULL,
      3.642242,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.561622,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.319411,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.628835,
      NULL,
      NULL,
      1.988386,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.191408,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.978746,
      0.465027,
      NULL,
      NULL,
      NULL,
      1.701336,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.170996,
      1,
      NULL,
      NULL,
      0.694991,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.749620,
      1.864084,
      NULL,
      NULL,
      1.900256,
      NULL,
      NULL,
      1.857487,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      43,
      NULL,
      1.408626,
      0.729348,
      NULL,
      1,
      0,
      0,
      1,
      1.202656,
      1.542911,
      0.035323,
      NULL,
      1.683312,
      NULL,
      1,
      1.540768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.018442,
      3.958111,
      NULL,
      1.597955,
      0,
      3,
      2.304548,
      3.170818,
      NULL,
      NULL,
      3.541478,
      18,
      14,
      0.240859,
      13.419803,
      2.748339,
      0.630363,
      10,
      NULL,
      1,
      1,
      15,
      0,
      14,
      5,
      0,
      2.534826,
      18.346579,
      0.081301,
      NULL,
      18.755405,
      0,
      11.151991,
      11,
      1,
      7.074342,
      2.155392,
      NULL,
      NULL,
      5.580882,
      1,
      6,
      NULL,
      0,
      1.120245,
      2,
      0.146998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.680182,
      6.448628,
      1,
      8,
      0.052165,
      5,
      4,
      1.916271,
      0,
      NULL,
      NULL,
      14,
      NULL,
      5,
      0,
      0,
      NULL,
      '',
      NULL,
      1.244802,
      '',
      NULL,
      '',
      3.786252,
      NULL,
      '',
      '');
commit;
end;
/


