set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228957';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '2134131',
      NULL,
      0.682404,
      NULL,
      1,
      '2103',
      0,
      0.379401,
      NULL,
      NULL,
      ' 2-22-2003',
      NULL,
      NULL,
      1.555628,
      2,
      0.663602,
      NULL,
      2.043368,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11- 6-1986',
      1.239908,
      0,
      1,
      1.787982,
      0,
      2,
      2,
      1.780214,
      0.842385,
      1.914563,
      1,
      4,
      0.021182,
      13.212267,
      7.479491,
      4,
      0,
      3,
      NULL,
      2.671925,
      0,
      3.754528,
      0,
      0,
      1.230291,
      NULL,
      0.363878,
      0.306767,
      1,
      NULL,
      NULL,
      2.135814,
      0.322058,
      NULL,
      NULL,
      3.321600,
      0,
      1,
      2.219238,
      NULL,
      0,
      0,
      NULL,
      0.509830,
      1,
      0.311066,
      0,
      3,
      1,
      3,
      0,
      1.256794,
      0,
      NULL,
      NULL,
      0.542238,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      3.540454,
      1.168283,
      1.732821,
      1,
      1.731799,
      1,
      2,
      3.062854,
      2.760780,
      1,
      0.803392,
      2,
      0,
      NULL,
      NULL,
      0,
      1.495010,
      2,
      NULL,
      0.433906,
      3,
      0,
      0.634595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.377517,
      0.818545,
      3,
      5.446073,
      NULL,
      1,
      0.843282,
      5.754465,
      0.097459,
      0,
      1.812504,
      4.419229,
      1,
      1,
      NULL,
      1,
      1.003224,
      NULL,
      0,
      5.358390,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.184437,
      0,
      2,
      0.075482,
      NULL,
      0,
      1.043537,
      0,
      6,
      NULL,
      0,
      5,
      4,
      1,
      4.518205,
      3.070303,
      NULL,
      1.172263,
      3.547292,
      0.243871,
      ' 8-18-1985',
      53,
      ' 1-26-1988',
      18,
      3.745153,
      1.035769,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.629171,
      0.117637,
      0.978769,
      1.700598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.166653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.796248,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025840,
      2,
      1.662571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.188084,
      1.459556,
      0,
      1.068734,
      1.713847,
      0.117258,
      1.807665,
      1.174467,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.665205,
      1,
      0,
      1,
      1,
      2.950580,
      2.051663,
      0.641963,
      NULL,
      NULL,
      1.260114,
      1.291472,
      0.907541,
      0.709672,
      3.757557,
      1.770127,
      0.053924,
      1,
      0.671241,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.097678,
      1,
      1.199174,
      2.462428,
      NULL,
      4.198914,
      1,
      7,
      NULL,
      NULL,
      1,
      NULL,
      1.532086,
      7.688141,
      2.998371,
      2.945955,
      NULL,
      47.079286,
      0,
      1.497921,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      '30433',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.726917,
      '',
      '',
      '',
      3,
      30,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338368,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.688012,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.249708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.193484,
      NULL,
      NULL,
      1.393547,
      NULL,
      NULL,
      0.356552,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.605616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835632,
      NULL,
      NULL,
      1.925146,
      NULL,
      NULL,
      1.812622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532708,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.468860,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.753160,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.128786,
      NULL,
      NULL,
      0.784411,
      NULL,
      NULL,
      NULL,
      NULL,
      1.291489,
      1.479267,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      2.392001,
      1.937038,
      NULL,
      NULL,
      0.046420,
      NULL,
      NULL,
      3.056142,
      3.377854,
      1,
      3,
      NULL,
      NULL,
      6.562719,
      NULL,
      NULL,
      NULL,
      1.801082,
      0,
      3,
      3.581650,
      0.099066,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      1,
      0.402046,
      5.352014,
      7.258558,
      6.536514,
      2,
      1,
      NULL,
      NULL,
      0.357722,
      NULL,
      0.584168,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.658645,
      1.168266,
      0.803364,
      0,
      1.392220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.306640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731163,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      1.385827,
      1.512591,
      0.448782,
      0.095062,
      0,
      0.148310,
      NULL,
      1,
      NULL,
      NULL,
      0.247328,
      0.648662,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.902780,
      1,
      0,
      5,
      0,
      1,
      1.161468,
      2,
      NULL,
      2,
      1,
      0.326113,
      NULL,
      2.970771,
      NULL,
      NULL,
      0.800955,
      NULL,
      1.382853,
      0.653513,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.734570,
      1,
      NULL,
      0,
      0.386162,
      NULL,
      1.804367,
      1.581566,
      NULL,
      1.002469,
      1.286731,
      NULL,
      0.952324,
      0,
      NULL,
      1,
      1.038129,
      NULL,
      2.420717,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.811311,
      2.290527,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      3,
      NULL,
      0.734341,
      NULL,
      1,
      NULL,
      0.043132,
      NULL,
      0.732339,
      NULL,
      1.024274,
      NULL,
      17,
      0.920979,
      13.770441,
      1,
      NULL,
      0.191084,
      NULL,
      1,
      NULL,
      NULL,
      0.127862,
      NULL,
      1.882968,
      NULL,
      NULL,
      47.382114,
      68.446650,
      NULL,
      0.890575,
      3.892467,
      '00123',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.087386,
      '',
      '',
      '');
commit;
end;
/


