set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9529157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '2140212',
      NULL,
      1.022681,
      0,
      3,
      '4312',
      NULL,
      0,
      NULL,
      NULL,
      ' 9-14-1992',
      NULL,
      NULL,
      3,
      NULL,
      0.423352,
      ' 5-19-1997',
      61,
      2,
      NULL,
      93,
      NULL,
      ' 9-26-1987',
      ' 7-21-1982',
      ' 1-18-1984',
      1,
      1,
      1.922438,
      2.504843,
      1,
      1,
      9.606893,
      1,
      0.779901,
      296,
      1,
      7.426098,
      6,
      NULL,
      4,
      7.012359,
      NULL,
      6.587885,
      2,
      6,
      0.845311,
      0,
      1,
      0.091565,
      NULL,
      0.010591,
      1.969762,
      2.338072,
      0.631184,
      0.057321,
      0.271803,
      2.514113,
      5.983490,
      5,
      NULL,
      1.619323,
      1,
      1.479050,
      NULL,
      1,
      NULL,
      3,
      0,
      1,
      NULL,
      1.038197,
      2.026913,
      NULL,
      3.955599,
      1.235415,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.341421,
      NULL,
      NULL,
      1.472504,
      1.498991,
      0.695449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.703962,
      3.699875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.221224,
      3.710755,
      0.199436,
      0.828004,
      7,
      2,
      5.447401,
      1,
      NULL,
      6.799578,
      NULL,
      NULL,
      NULL,
      2.369832,
      0,
      NULL,
      0.778244,
      NULL,
      1.909836,
      NULL,
      1.091344,
      1,
      4,
      NULL,
      1.320195,
      0,
      1,
      5,
      NULL,
      0,
      5,
      1,
      1.918181,
      NULL,
      NULL,
      2,
      NULL,
      3,
      2,
      5,
      5,
      NULL,
      1.334812,
      4,
      NULL,
      4.359876,
      1.253784,
      3.093720,
      ' 8-13-1996',
      NULL,
      ' 8-10-1974',
      4,
      0,
      1.200320,
      1,
      6.658709,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771130,
      2,
      0,
      NULL,
      7.860678,
      0,
      6,
      NULL,
      1.439139,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.127690,
      0,
      0,
      0,
      3,
      NULL,
      5,
      1,
      0,
      1.061733,
      0.623472,
      1.227047,
      0.536922,
      NULL,
      NULL,
      NULL,
      1,
      4.552535,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.465354,
      0.933465,
      NULL,
      1.014541,
      21,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.549425,
      2,
      2.766374,
      4,
      NULL,
      0,
      3,
      2.582675,
      2.900154,
      0.509519,
      NULL,
      2,
      2.320526,
      1.949815,
      NULL,
      0.028742,
      NULL,
      0,
      NULL,
      0,
      1.580217,
      NULL,
      1,
      70,
      54,
      NULL,
      0,
      3.313930,
      19.864730,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      8.010325,
      NULL,
      NULL,
      1.631014,
      0,
      NULL,
      3,
      3.939056,
      45,
      1.332005,
      1,
      NULL,
      58.678418,
      11,
      46.744140,
      NULL,
      3.887544,
      NULL,
      '14403',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '10443',
      NULL,
      '',
      1.027413,
      17.561924,
      NULL,
      9,
      2.117952,
      32.497801,
      9.931845,
      4.587554,
      0.652482,
      0,
      2.817175,
      1.500733,
      0.307763,
      NULL,
      NULL,
      0,
      NULL,
      0.523535,
      1,
      2,
      NULL,
      NULL,
      1.677563,
      1.331038,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.013794,
      0.593818,
      1.412103,
      0.482959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132066,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.382961,
      1.779516,
      0.237374,
      2.775409,
      2,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      3.471829,
      3.676156,
      0.318799,
      0,
      1,
      0,
      2.964555,
      NULL,
      NULL,
      1.200625,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.308965,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.317033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.817174,
      1,
      0,
      1,
      7.223570,
      NULL,
      1.969305,
      NULL,
      NULL,
      1.895556,
      NULL,
      NULL,
      3.199284,
      0,
      1,
      NULL,
      1.301755,
      2,
      0.138530,
      3,
      2,
      2.375511,
      1,
      0,
      NULL,
      1,
      1.383095,
      NULL,
      1,
      3.906663,
      0,
      1.082460,
      3,
      3,
      NULL,
      NULL,
      1.736537,
      NULL,
      3,
      9.873766,
      3.569443,
      1.155426,
      1.364932,
      0.118577,
      1.266054,
      NULL,
      0.960031,
      0.128764,
      NULL,
      0.301317,
      2.780917,
      NULL,
      NULL,
      4.234303,
      NULL,
      NULL,
      2.006107,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.203926,
      NULL,
      NULL,
      0.847808,
      NULL,
      NULL,
      1.339847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.125599,
      NULL,
      NULL,
      1.323470,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.847721,
      1,
      1.322029,
      1,
      0,
      1.775308,
      2.864875,
      NULL,
      NULL,
      1.825487,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596370,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1.175513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.969701,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.637157,
      NULL,
      NULL,
      NULL,
      3,
      0.567081,
      NULL,
      NULL,
      1.685834,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.302389,
      NULL,
      NULL,
      1.890278,
      1.360651,
      NULL,
      NULL,
      0.964072,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.610866,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      314,
      53.924621,
      0,
      NULL,
      NULL,
      0.371722,
      NULL,
      NULL,
      0.321963,
      NULL,
      NULL,
      2,
      147.299376,
      NULL,
      NULL,
      NULL,
      NULL,
      0.596983,
      NULL,
      1,
      0.264126,
      15.987389,
      NULL,
      NULL,
      1.502411,
      NULL,
      1.255519,
      0,
      0.537357,
      0.085290,
      1,
      1,
      0,
      0.410003,
      0,
      3.502012,
      1,
      1,
      NULL,
      1.545097,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.335604,
      NULL,
      NULL,
      NULL,
      0.113024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.936971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.527763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708439,
      2,
      NULL,
      0,
      NULL,
      0.148228,
      NULL,
      NULL,
      NULL,
      1.226730,
      NULL,
      1.892171,
      NULL,
      1.547996,
      NULL,
      NULL,
      0.764907,
      1.752428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.835909,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.497542,
      0.147121,
      3.008317,
      15.652316,
      24.470812,
      0.830138,
      NULL,
      NULL,
      NULL,
      1.793195,
      0.925033,
      NULL,
      1,
      0,
      1.924416,
      2.290589,
      0,
      4.034290,
      3.466515,
      2,
      0,
      1,
      1.350571,
      0.121625,
      0,
      1.209893,
      1.168252,
      0,
      1.123175,
      0.970502,
      0.092403,
      0,
      0.766882,
      NULL,
      1.484822,
      1.869881,
      0.867454,
      NULL,
      1.740612,
      2,
      2.506731,
      1,
      NULL,
      NULL,
      1,
      1.462018,
      0,
      0.929190,
      1.890204,
      1,
      NULL,
      0.165384,
      0.815418,
      NULL,
      0.299298,
      0.414883,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.481617,
      1.159129,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      68.211694,
      10,
      5,
      NULL,
      3.012920,
      '01323',
      NULL,
      '',
      0.288012,
      NULL,
      '',
      '',
      2,
      '14320',
      NULL,
      '');
commit;
end;
/


