set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9529157';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '21',
      '31',
      NULL,
      NULL,
      '3444003',
      3,
      1,
      1,
      3,
      '4223',
      3,
      NULL,
      NULL,
      NULL,
      ' 4-10-2000',
      NULL,
      0.587425,
      NULL,
      2,
      0.543225,
      ' 1-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 4-18-1974',
      ' 4-22-1980',
      0.736278,
      1.857788,
      0.121967,
      0.609533,
      0,
      1.596581,
      1,
      1,
      1.657936,
      50.680182,
      7,
      18.111269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.716175,
      NULL,
      NULL,
      0,
      0.640845,
      1.769771,
      0,
      0,
      1.669669,
      NULL,
      0.080370,
      NULL,
      NULL,
      1.015955,
      NULL,
      NULL,
      NULL,
      0.991892,
      0.687830,
      1,
      NULL,
      NULL,
      0.579959,
      1.799170,
      0,
      0.205509,
      1,
      1,
      1.527492,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.192440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.236387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.348983,
      3,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1.706502,
      0.312882,
      1,
      1.788195,
      NULL,
      1.079753,
      0.056300,
      1.964135,
      NULL,
      0,
      0.051637,
      NULL,
      0,
      1.519999,
      3,
      0,
      1,
      1.501725,
      3,
      1,
      1.175957,
      0.992486,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      4.249172,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0.611554,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.329554,
      0.728264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.927273,
      3,
      1.250492,
      0.063633,
      0,
      0.743246,
      0.034452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088363,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256146,
      0,
      0.087322,
      1.319114,
      1.960324,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.052586,
      1.887729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.680709,
      1,
      1,
      1.072065,
      NULL,
      0.711859,
      2,
      22,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2.030218,
      1.134819,
      2,
      1.055893,
      NULL,
      5,
      0.145628,
      0,
      NULL,
      1,
      1,
      NULL,
      1.477714,
      2,
      NULL,
      2.397205,
      4.704828,
      0.256220,
      1,
      2,
      2,
      0.426107,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.934127,
      1.057032,
      3.923253,
      0.987298,
      4,
      5,
      3,
      1.249958,
      2,
      2.218895,
      5.869392,
      2.310594,
      NULL,
      1.122943,
      0,
      1,
      32.085715,
      2.413028,
      NULL,
      87,
      NULL,
      59.071073,
      64.329012,
      1,
      NULL,
      3,
      '44230',
      '',
      '',
      1,
      NULL,
      '',
      '',
      4.703555,
      '10130',
      '32330',
      '',
      2.673901,
      24,
      218.594872,
      20.380803,
      0.318466,
      1.190273,
      8.747136,
      3,
      2,
      NULL,
      2.106494,
      NULL,
      1.079749,
      NULL,
      NULL,
      1.337560,
      0.863883,
      0,
      2,
      1.593760,
      3.210859,
      1.241623,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.087649,
      2,
      0.443025,
      0.535576,
      0.777831,
      1.778792,
      NULL,
      NULL,
      0.414969,
      NULL,
      NULL,
      1.374073,
      NULL,
      NULL,
      1.228911,
      NULL,
      NULL,
      9,
      4.173402,
      1.099685,
      0.380337,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.948164,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.599660,
      NULL,
      NULL,
      3,
      3.605994,
      2,
      3,
      1.105407,
      NULL,
      0,
      NULL,
      NULL,
      8.545936,
      0,
      3,
      3.633585,
      3,
      3,
      1.580767,
      2,
      0,
      9,
      5,
      NULL,
      1.730325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.541307,
      2,
      6,
      7,
      2.340493,
      1,
      NULL,
      NULL,
      1.368655,
      NULL,
      NULL,
      1.032342,
      NULL,
      NULL,
      3.159400,
      0.039506,
      1.133984,
      3,
      2,
      1,
      NULL,
      NULL,
      2.816132,
      0,
      0.578052,
      2.188972,
      2,
      0.984700,
      0.082196,
      NULL,
      1,
      1.716486,
      3.426706,
      3.051901,
      3.790352,
      1.587478,
      0.701469,
      2.828804,
      3,
      NULL,
      NULL,
      NULL,
      5,
      3.492039,
      1,
      0.324859,
      3.171649,
      0,
      0,
      3.033546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.669277,
      NULL,
      NULL,
      1.099444,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.731764,
      NULL,
      NULL,
      3.260836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.171666,
      NULL,
      NULL,
      0.528366,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.823555,
      NULL,
      1,
      1.745340,
      2,
      0.088799,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.498416,
      NULL,
      NULL,
      3,
      1.768385,
      NULL,
      NULL,
      NULL,
      0.796925,
      NULL,
      NULL,
      1.615679,
      3.048909,
      NULL,
      NULL,
      2.924183,
      NULL,
      NULL,
      NULL,
      1.576934,
      1.167985,
      NULL,
      NULL,
      1.649925,
      0.391498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277865,
      0,
      NULL,
      NULL,
      1.830190,
      1,
      NULL,
      NULL,
      0.972331,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.890978,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.426022,
      74,
      112.997618,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      7.702113,
      0,
      3,
      0.167900,
      1,
      1,
      0,
      0.930113,
      1,
      NULL,
      0.734200,
      1.383910,
      NULL,
      0,
      3.318529,
      NULL,
      0.151367,
      NULL,
      2.624160,
      NULL,
      NULL,
      NULL,
      1.012808,
      NULL,
      1.628973,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.204945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.995978,
      1.903381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.855622,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.696603,
      NULL,
      1.086952,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.156781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      0.143667,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.147272,
      NULL,
      1.650127,
      NULL,
      3,
      16.262057,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.955962,
      1,
      NULL,
      NULL,
      2.986457,
      1,
      NULL,
      0,
      5.539252,
      3,
      0,
      0.126689,
      NULL,
      1,
      1,
      1,
      1,
      1.600744,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0.035186,
      1,
      1,
      0,
      3,
      3,
      2.935907,
      2.567165,
      0.283099,
      0,
      1,
      NULL,
      1.531312,
      NULL,
      0,
      1.545029,
      0.055074,
      1,
      0,
      0,
      0.801322,
      3.614696,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.970389,
      NULL,
      4,
      5.002184,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      91,
      1,
      3,
      1.171362,
      '02114',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      '01301',
      '01341',
      '');
commit;
end;
/


