set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9877862';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.728141,
      NULL,
      NULL,
      3.756874,
      2,
      2,
      1.180625,
      NULL,
      NULL,
      '13143331',
      79.778406,
      6,
      NULL,
      1.558115,
      1.561242,
      5,
      0,
      '1112',
      0.433938,
      NULL,
      NULL,
      NULL,
      NULL,
      143.042992,
      31.008608,
      NULL,
      NULL,
      NULL,
      ' 0-15-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      2.650846,
      NULL,
      '10-24-1974',
      ' 7- 8-1998',
      3.763114,
      3,
      1.314762,
      2,
      0,
      3,
      2.359124,
      0,
      NULL,
      NULL,
      NULL,
      2.265925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.043910,
      0,
      0,
      0.165857,
      1,
      1,
      0.858157,
      5,
      3,
      2,
      2.740878,
      9.396625,
      1,
      2.807921,
      0.652938,
      1.597191,
      NULL,
      2.616104,
      3,
      7,
      NULL,
      3.575708,
      NULL,
      5.983138,
      0,
      1.801423,
      2,
      0,
      1.440519,
      NULL,
      NULL,
      0.497349,
      NULL,
      NULL,
      5,
      NULL,
      4,
      1.319865,
      0,
      1.077360,
      0.201141,
      2,
      3,
      0,
      2,
      0,
      3.057083,
      0,
      0,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      5.802629,
      3,
      0.753631,
      3.884522,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      7,
      1,
      4,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      0.973155,
      1.386968,
      NULL,
      NULL,
      0.308042,
      5.908478,
      2.260967,
      3,
      5.706839,
      0,
      2,
      9.744982,
      1.625127,
      4.195703,
      NULL,
      NULL,
      4,
      NULL,
      1.221068,
      8.545633,
      6.488103,
      NULL,
      1,
      8,
      NULL,
      9.805703,
      NULL,
      3,
      0,
      2,
      1.258821,
      0.603095,
      ' 9- 8-1996',
      396.406441,
      ' 0-28-1996',
      53,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      3,
      0.654034,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.939452,
      NULL,
      2,
      1.090571,
      1,
      0.542797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.702844,
      0.568096,
      2.674857,
      1,
      2.058596,
      0.241004,
      1,
      0,
      0.556089,
      6,
      4.038112,
      4.557797,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375918,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.967435,
      1.142418,
      1,
      1,
      0.116224,
      0.360884,
      0,
      3.001340,
      3,
      3.150685,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.001650,
      1.965766,
      2.911754,
      1.150359,
      5,
      NULL,
      1.888830,
      3.112540,
      NULL,
      NULL,
      NULL,
      NULL,
      3.041763,
      NULL,
      NULL,
      0,
      1.256808,
      1,
      1,
      1.427399,
      0.872782,
      0.507018,
      1.114322,
      0,
      NULL,
      0,
      0.758510,
      0.846261,
      NULL,
      NULL,
      1,
      9,
      NULL,
      5.533597,
      NULL,
      7.524925,
      7,
      NULL,
      2,
      5.221941,
      2,
      NULL,
      2,
      22,
      1.540037,
      2.651314,
      26.622097,
      NULL,
      1,
      65,
      2,
      2,
      NULL,
      '02433',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.805411,
      '',
      NULL,
      '',
      NULL,
      34,
      123,
      32.233033,
      0.098307,
      NULL,
      NULL,
      NULL,
      NULL,
      2.116329,
      2.147552,
      2.052068,
      1.633864,
      NULL,
      NULL,
      1,
      1.578428,
      1,
      2,
      1,
      0.640646,
      3.984887,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.412487,
      NULL,
      NULL,
      2.526470,
      1.704797,
      NULL,
      0,
      1,
      0,
      2,
      0.850502,
      0.780848,
      3,
      NULL,
      NULL,
      2,
      0.427191,
      1.418733,
      5.462428,
      5,
      0.330684,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.672339,
      0.521377,
      2.798445,
      3,
      NULL,
      2,
      2,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      2,
      0.273744,
      2,
      2.722126,
      3,
      2,
      1.371181,
      0.855360,
      1,
      3.037139,
      3,
      0,
      1.842955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539769,
      NULL,
      7,
      1.166662,
      3,
      1.756269,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.447460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.292897,
      NULL,
      NULL,
      NULL,
      1,
      1.519768,
      1,
      NULL,
      NULL,
      NULL,
      1.675879,
      3.779961,
      0,
      NULL,
      NULL,
      0.737478,
      NULL,
      NULL,
      0.375970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.947240,
      NULL,
      NULL,
      1.146589,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      3.315573,
      0,
      4.426648,
      1.227324,
      0.148765,
      0,
      1.880490,
      NULL,
      NULL,
      1.017488,
      1,
      2,
      NULL,
      NULL,
      0,
      3.719279,
      0.785863,
      0.786966,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      2.309075,
      0,
      1,
      2,
      NULL,
      0,
      1,
      0,
      3,
      3,
      1.295218,
      3.001281,
      0,
      NULL,
      NULL,
      1.073327,
      1.129544,
      4.676535,
      1,
      1,
      0,
      1.736435,
      1,
      0,
      NULL,
      NULL,
      0.435965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.804569,
      NULL,
      NULL,
      0.067661,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.571519,
      NULL,
      NULL,
      4.320730,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      1.114838,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790048,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990494,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.117234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.216580,
      NULL,
      0.884909,
      NULL,
      NULL,
      1.046441,
      NULL,
      NULL,
      2,
      0.571207,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424604,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      93,
      0.242058,
      NULL,
      0.111151,
      1.034828,
      1,
      1,
      1,
      0,
      NULL,
      0.713452,
      NULL,
      0.707155,
      1,
      NULL,
      1.241072,
      NULL,
      1.114315,
      1.068082,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918067,
      0,
      0.901502,
      0,
      1.108933,
      0.003716,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      1.772432,
      2,
      NULL,
      0,
      0.422905,
      NULL,
      1.892872,
      0,
      NULL,
      0.723486,
      0,
      NULL,
      0.628638,
      NULL,
      NULL,
      1.411872,
      0.205840,
      NULL,
      1.490343,
      0.171729,
      NULL,
      1,
      NULL,
      NULL,
      1.944669,
      0.324538,
      1.727041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.862583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.869593,
      2.889375,
      NULL,
      NULL,
      NULL,
      NULL,
      73.023907,
      4,
      4.202033,
      1,
      NULL,
      '',
      '',
      1.837450,
      '',
      '',
      '',
      1.654480,
      NULL,
      '',
      '');
commit;
end;
/


