set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9014854';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '2141424',
      1,
      1,
      2,
      0,
      '2414',
      1,
      0.007836,
      NULL,
      NULL,
      ' 2-28-1974',
      NULL,
      NULL,
      3.784864,
      3,
      0.669697,
      '11-24-1987',
      62,
      1,
      6,
      3,
      NULL,
      ' 3-29-1979',
      ' 9-17-1983',
      NULL,
      NULL,
      1.959132,
      3,
      NULL,
      0.076553,
      NULL,
      2.564859,
      0.668177,
      0,
      44.751617,
      3,
      14,
      3,
      69.228783,
      4.982902,
      3.516866,
      21.589139,
      NULL,
      1,
      NULL,
      1.437435,
      1,
      1.317006,
      0,
      NULL,
      0,
      0.480421,
      0.483918,
      0,
      NULL,
      181,
      NULL,
      9,
      0.904436,
      NULL,
      NULL,
      1,
      0.748818,
      7,
      NULL,
      0.071754,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      0.410273,
      1.718690,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103441,
      1.867416,
      0.332126,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535532,
      0,
      0,
      1.915298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      4.045208,
      NULL,
      5.786577,
      0.990948,
      3,
      3,
      0,
      1.278671,
      1,
      5,
      1.113735,
      1,
      0,
      1.892025,
      1,
      NULL,
      NULL,
      2.382536,
      2,
      0.458981,
      1,
      2.186576,
      NULL,
      5,
      2.534914,
      2.080029,
      0,
      0.670537,
      0.550633,
      7.768515,
      1,
      NULL,
      NULL,
      2,
      9,
      4,
      NULL,
      2.868740,
      3,
      1.025627,
      3,
      4.196228,
      2,
      1.991017,
      ' 9-14-1989',
      1477.937136,
      ' 3- 6-2003',
      1100,
      1.301096,
      1.828059,
      0,
      4,
      0.942766,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.975153,
      1,
      1.658631,
      0,
      2.381582,
      2,
      NULL,
      1.251898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.527472,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.814748,
      NULL,
      5,
      NULL,
      2,
      0.904651,
      NULL,
      NULL,
      NULL,
      1.494485,
      0.277464,
      0.425453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610629,
      NULL,
      NULL,
      NULL,
      1.511946,
      0.161020,
      0.908579,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.587206,
      3,
      NULL,
      1,
      3,
      2.299124,
      1.445464,
      NULL,
      1,
      3.639144,
      NULL,
      NULL,
      NULL,
      0.929644,
      0,
      0.508017,
      0,
      6.374328,
      0.913772,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      4,
      NULL,
      4,
      NULL,
      1.537360,
      1,
      2,
      5,
      0.410582,
      2.402780,
      NULL,
      9.694249,
      3.442963,
      1,
      NULL,
      24,
      NULL,
      NULL,
      4,
      1.132408,
      NULL,
      '42420',
      '33311',
      NULL,
      1.938616,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      3,
      4.557458,
      725,
      0,
      1.432268,
      NULL,
      NULL,
      NULL,
      NULL,
      2.261443,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183673,
      NULL,
      NULL,
      0.936205,
      2,
      2,
      0.090651,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.168826,
      2,
      1.072130,
      1.348701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715537,
      NULL,
      NULL,
      0.642073,
      NULL,
      NULL,
      1.653590,
      NULL,
      NULL,
      5.914962,
      6.260706,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.685421,
      2.718650,
      1,
      8,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3.923378,
      NULL,
      1.178598,
      1.413814,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      1.836547,
      0.559768,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.679699,
      NULL,
      NULL,
      3.741252,
      1.206827,
      1.450917,
      NULL,
      3,
      0,
      1,
      1.729110,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.863145,
      NULL,
      1,
      0,
      NULL,
      NULL,
      4,
      0.295671,
      1.556711,
      3,
      3.211738,
      0,
      0.934850,
      NULL,
      NULL,
      NULL,
      1.719356,
      0.513775,
      NULL,
      NULL,
      NULL,
      1.658173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173100,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.706372,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.621106,
      7,
      NULL,
      NULL,
      5.388653,
      6.875815,
      NULL,
      NULL,
      NULL,
      1.504971,
      NULL,
      NULL,
      1.449655,
      1,
      3,
      1.512855,
      2,
      0.885989,
      6.275825,
      3,
      0.080908,
      0.597883,
      3.316883,
      0.341320,
      1.157372,
      1,
      3.096628,
      2,
      0,
      1.760131,
      0,
      NULL,
      NULL,
      9,
      NULL,
      9.051828,
      5.471634,
      NULL,
      7.547922,
      1.844615,
      0,
      9.514899,
      1,
      0.483962,
      0.947672,
      1,
      1.280072,
      0,
      NULL,
      NULL,
      1.404351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.952241,
      NULL,
      NULL,
      1.760189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381400,
      0,
      0.736179,
      1,
      0,
      1.591260,
      NULL,
      NULL,
      6.753573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254651,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.882568,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.897050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.103695,
      NULL,
      NULL,
      NULL,
      1.480038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.791592,
      NULL,
      NULL,
      NULL,
      0.617836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.580003,
      487.262476,
      NULL,
      1.488083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.520793,
      NULL,
      NULL,
      1.835525,
      NULL,
      NULL,
      0,
      40.909554,
      1,
      5839,
      1733,
      NULL,
      1,
      1.988860,
      0.410130,
      NULL,
      1.207102,
      0,
      NULL,
      1,
      0.836901,
      1.849826,
      0.588637,
      0,
      NULL,
      0.855289,
      1.149028,
      0.762203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422563,
      0,
      1,
      1.715181,
      1,
      1,
      0,
      4,
      5,
      0,
      1.548377,
      1.214197,
      0,
      0.863268,
      NULL,
      2.417492,
      NULL,
      NULL,
      1,
      3.937792,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.293499,
      NULL,
      0,
      0.807794,
      NULL,
      0.862499,
      3,
      NULL,
      0.449453,
      0,
      NULL,
      2.415178,
      1.600365,
      NULL,
      0.522055,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120520,
      NULL,
      1.668240,
      NULL,
      0,
      NULL,
      7.335481,
      8.942452,
      NULL,
      3,
      2,
      0,
      27.461971,
      32.695829,
      5,
      NULL,
      3,
      '42321',
      '40234',
      '',
      NULL,
      '',
      '',
      '',
      2,
      '1310',
      '',
      '');
commit;
end;
/


