set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '0222111',
      3,
      1.262564,
      NULL,
      1,
      NULL,
      NULL,
      0.863466,
      NULL,
      NULL,
      ' 4-18-1974',
      5.793999,
      NULL,
      NULL,
      2.352418,
      1.041116,
      ' 1- 0-2003',
      48,
      NULL,
      32.379546,
      119,
      NULL,
      ' 3-15-1981',
      ' 5- 0-1998',
      ' 3-14-2003',
      3.995009,
      NULL,
      NULL,
      1.276480,
      NULL,
      2,
      1,
      3.642895,
      NULL,
      NULL,
      NULL,
      0.916362,
      5.256797,
      19,
      7.131287,
      2.720499,
      23,
      5,
      3,
      9,
      0.499572,
      1.811632,
      0,
      1,
      1,
      1.557839,
      0.987698,
      1.634230,
      0,
      1.243711,
      0,
      3.979629,
      1,
      0.968207,
      NULL,
      0.224301,
      1,
      1,
      0.859815,
      1.491177,
      1.832730,
      1,
      1.107230,
      0.526057,
      1.421633,
      1.108196,
      0.020838,
      1.353304,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.712763,
      1.292378,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.479577,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      1,
      1.933546,
      NULL,
      0.159622,
      NULL,
      0,
      0.365849,
      0,
      0,
      1,
      0.309793,
      5.346168,
      6,
      NULL,
      4,
      1.131132,
      4.752945,
      1,
      1,
      0.085643,
      1,
      NULL,
      NULL,
      7.067422,
      2.421819,
      9.742798,
      2.562284,
      7.793452,
      5,
      NULL,
      9.118988,
      0.750007,
      0.212437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.643669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110295,
      NULL,
      NULL,
      0.122849,
      NULL,
      1,
      1.129196,
      0.671706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.440184,
      NULL,
      748,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.840650,
      NULL,
      8.275918,
      0.338825,
      2.708755,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.146475,
      2.495808,
      0.669825,
      1.723525,
      1.001758,
      0,
      0.730531,
      2,
      33,
      1,
      1.282081,
      NULL,
      NULL,
      NULL,
      0,
      1.088364,
      1,
      NULL,
      0.684989,
      1.334094,
      NULL,
      1.519476,
      3,
      2.990095,
      2,
      1.227292,
      3,
      NULL,
      NULL,
      0.433525,
      2.234873,
      1,
      0.493408,
      0.965898,
      NULL,
      1,
      1,
      1.871552,
      0,
      0.828644,
      1.960638,
      NULL,
      NULL,
      0.867668,
      5.951148,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457506,
      NULL,
      22.316161,
      NULL,
      7,
      2,
      1,
      3,
      '23340',
      '',
      NULL,
      0.628632,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      2,
      38,
      177,
      50.800042,
      1,
      53.673710,
      NULL,
      3,
      3,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.634540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.405240,
      0.451747,
      NULL,
      1.507374,
      3.114417,
      3.119960,
      1,
      0,
      1.781110,
      NULL,
      NULL,
      0,
      0.831771,
      1,
      0.188650,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      2.078972,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.767495,
      1.593542,
      1.176682,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.488655,
      1,
      0,
      1,
      NULL,
      1,
      1.358438,
      1.749486,
      0.523220,
      NULL,
      0.332760,
      0.018409,
      1,
      1.573245,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.079604,
      NULL,
      NULL,
      6,
      3.854831,
      3,
      0.336591,
      1.572047,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.296260,
      NULL,
      NULL,
      0.738751,
      0.679025,
      1,
      NULL,
      1.018894,
      0,
      1,
      NULL,
      NULL,
      4.551156,
      0.498064,
      0.646491,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7.875062,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.956078,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.533307,
      0.320290,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.827699,
      1,
      4,
      4,
      1.515711,
      1.238266,
      1,
      1,
      0,
      3.228856,
      1.010197,
      1.491492,
      NULL,
      2,
      3,
      9,
      3.121663,
      NULL,
      0.608819,
      1,
      2,
      3,
      0,
      2.120809,
      0.693627,
      2,
      1,
      0.458972,
      2,
      3,
      3.232901,
      2.078707,
      7,
      NULL,
      1.630399,
      0.068868,
      3,
      3,
      2.494189,
      0,
      1.216202,
      1,
      1,
      NULL,
      0.335826,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.544245,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.194668,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.387852,
      1,
      0.902490,
      1.565423,
      NULL,
      NULL,
      5.134016,
      0,
      NULL,
      NULL,
      740.910593,
      96,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.112706,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.951825,
      NULL,
      NULL,
      0,
      0.516366,
      NULL,
      NULL,
      1.968591,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1,
      0.330535,
      NULL,
      NULL,
      0,
      0.222281,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1.829294,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.547531,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.987695,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      4,
      NULL,
      96,
      15,
      0,
      NULL,
      NULL,
      2,
      0,
      1.077897,
      1.758023,
      NULL,
      NULL,
      1.223721,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705949,
      40.669734,
      1.022317,
      0,
      NULL,
      0,
      1.964475,
      NULL,
      0.164070,
      NULL,
      NULL,
      1.060598,
      1,
      1.553157,
      0.019111,
      0.360076,
      1.864113,
      1.304875,
      0,
      0.804088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.346718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      12,
      NULL,
      3,
      0.730204,
      2.442441,
      8.123350,
      0,
      NULL,
      0,
      0.431188,
      1,
      1.542449,
      1,
      NULL,
      0,
      NULL,
      0.595876,
      0,
      0,
      0,
      0,
      0,
      0,
      0.548270,
      NULL,
      1.881758,
      NULL,
      0.008919,
      1,
      NULL,
      0.399226,
      NULL,
      1.647142,
      NULL,
      NULL,
      0.125715,
      0.249094,
      3.833637,
      NULL,
      1.425040,
      1,
      NULL,
      2.001584,
      3,
      1.053816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.296419,
      NULL,
      0,
      1,
      2,
      NULL,
      2.045996,
      2.761441,
      3.959813,
      7.383413,
      NULL,
      19,
      2,
      15.579124,
      1,
      0.333926,
      3,
      3.536344,
      1.972486,
      7.669676,
      3.451918,
      19,
      NULL,
      6.492088,
      NULL,
      NULL,
      0,
      1.213899,
      10,
      3.900907,
      NULL,
      0,
      NULL,
      11.898394,
      3,
      3,
      1.231815,
      3.178776,
      68.710054,
      57,
      0.400982,
      1,
      0.179369,
      '02000',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.366165,
      NULL,
      '',
      '');
commit;
end;
/


