set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5200554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '0324120',
      2,
      1,
      0,
      2,
      NULL,
      3.051672,
      1,
      2,
      16,
      ' 0-20-1975',
      NULL,
      NULL,
      NULL,
      1,
      0.764266,
      NULL,
      58,
      2.980893,
      NULL,
      31,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.217149,
      1,
      5.609044,
      2,
      NULL,
      NULL,
      NULL,
      8.367347,
      NULL,
      16,
      NULL,
      2.035588,
      NULL,
      0.619403,
      5,
      5,
      0.220753,
      0.200848,
      2.317991,
      1,
      1,
      0,
      5.529372,
      0,
      NULL,
      0,
      0.077329,
      2,
      1.800608,
      0,
      1,
      0.245103,
      1.545547,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      0.760921,
      1,
      0.226750,
      NULL,
      2.064196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.175101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925120,
      1.187275,
      1,
      1.499913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268586,
      0,
      3.240143,
      4,
      4,
      5.272313,
      NULL,
      NULL,
      NULL,
      0.046096,
      4.848417,
      0,
      0,
      4,
      NULL,
      NULL,
      0.229969,
      1.028227,
      0.202859,
      NULL,
      1.880834,
      0,
      5.436236,
      0,
      NULL,
      3.779523,
      1,
      2,
      0.767679,
      NULL,
      0.353286,
      4.811897,
      1,
      3,
      NULL,
      2.181371,
      NULL,
      3.963436,
      4.311904,
      0,
      NULL,
      0.108520,
      NULL,
      4,
      5,
      NULL,
      3.393649,
      1.032059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.556949,
      1.002757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004686,
      4,
      0,
      1.156991,
      0.730114,
      1.317201,
      0.264185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.209155,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505510,
      2.584589,
      4.163460,
      3.548747,
      5,
      0.148052,
      NULL,
      NULL,
      NULL,
      0.573234,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.925930,
      0,
      0.114377,
      1,
      0,
      1,
      1.187009,
      NULL,
      NULL,
      0.657953,
      0,
      NULL,
      NULL,
      NULL,
      3.694659,
      0.271128,
      0.222222,
      3,
      2,
      0,
      2.377402,
      1,
      3,
      3,
      1.288403,
      2,
      1.051564,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      11.025774,
      1,
      0,
      6,
      NULL,
      0,
      4.058156,
      1,
      0,
      2.677346,
      2,
      2.727487,
      NULL,
      2.111158,
      6,
      1,
      1,
      11.670178,
      NULL,
      1.441775,
      2,
      0.540100,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      '40342',
      '20302',
      '',
      1.958449,
      '42334',
      '',
      NULL,
      0.248379,
      NULL,
      '',
      '',
      0,
      23.765252,
      515.536404,
      31,
      2,
      13.050618,
      5,
      6.423489,
      3.053210,
      0.375723,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.332473,
      NULL,
      19.640740,
      0.429723,
      NULL,
      NULL,
      0.804401,
      11.191767,
      5,
      0.739756,
      5,
      1,
      NULL,
      NULL,
      NULL,
      1.720633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732114,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.207916,
      NULL,
      NULL,
      1.223561,
      1,
      NULL,
      0.308832,
      1.119075,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11.765140,
      15.343221,
      1.229910,
      NULL,
      NULL,
      0.284082,
      NULL,
      NULL,
      1.368234,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.061477,
      NULL,
      NULL,
      0.969521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.580799,
      9,
      9.289242,
      1,
      3,
      0.500019,
      0.261737,
      0,
      0.224320,
      6.214913,
      0.366505,
      1,
      1.248976,
      NULL,
      2,
      3.412543,
      5.766873,
      3,
      NULL,
      NULL,
      2.905950,
      0,
      NULL,
      NULL,
      1.406935,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.632534,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      15,
      0,
      3,
      2,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0.698282,
      NULL,
      NULL,
      14.885967,
      NULL,
      NULL,
      1.387950,
      12,
      2,
      3.834185,
      17.499595,
      0,
      7,
      1,
      2.832472,
      1.653754,
      9.445362,
      NULL,
      3,
      11,
      3,
      1.796592,
      NULL,
      0.513942,
      2.820869,
      4.949747,
      2,
      1.451907,
      1,
      3.832458,
      5,
      0.833331,
      2,
      1.830663,
      1.528374,
      1,
      1,
      1.122082,
      1,
      1.608500,
      NULL,
      3.004083,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644004,
      NULL,
      NULL,
      1.059081,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1.313339,
      NULL,
      NULL,
      1.319036,
      NULL,
      NULL,
      19,
      NULL,
      NULL,
      1.517576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      0,
      1,
      2,
      1.446416,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484643,
      NULL,
      NULL,
      NULL,
      1.330254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.291508,
      NULL,
      NULL,
      1.721940,
      0.937726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.462248,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      2.317034,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581238,
      NULL,
      NULL,
      1.028134,
      NULL,
      NULL,
      NULL,
      5.127396,
      1,
      NULL,
      1.179615,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      13,
      NULL,
      NULL,
      NULL,
      3.915729,
      104.414155,
      16.774583,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3617.696317,
      1.698282,
      0.955152,
      1.571252,
      1,
      0.936148,
      0.720321,
      0.325864,
      1.043952,
      1.319334,
      NULL,
      1.452131,
      NULL,
      1.436380,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.768440,
      0.950991,
      3,
      5.087673,
      1,
      NULL,
      1.981985,
      2,
      5,
      3,
      2.044366,
      3,
      NULL,
      0,
      NULL,
      1,
      0.959721,
      1.204527,
      3,
      NULL,
      2.685562,
      1,
      NULL,
      1.317494,
      0.227870,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      0,
      3.089230,
      1,
      2,
      0,
      0.937270,
      NULL,
      0,
      1.085311,
      0,
      1.574367,
      1.371496,
      1.421145,
      1.337441,
      1.056097,
      0.189080,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.683423,
      NULL,
      1.944984,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      10.091774,
      0.201673,
      NULL,
      3.490977,
      NULL,
      2.482425,
      1.242398,
      13,
      0,
      0.212219,
      3.079553,
      2,
      2,
      0.666065,
      1.729773,
      1.579894,
      0,
      NULL,
      NULL,
      1.560399,
      0,
      1.348378,
      0.072933,
      2,
      1,
      0.021765,
      2,
      0.171895,
      0,
      3.213401,
      8.658045,
      1,
      NULL,
      0.103074,
      0,
      0.439599,
      1.433966,
      1.852158,
      NULL,
      5,
      NULL,
      5.953822,
      0,
      NULL,
      NULL,
      89.809291,
      6,
      4.820773,
      0,
      2.394910,
      '32401',
      '24224',
      '',
      3.081336,
      '03234',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


