set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7826448';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '1123220',
      3.170514,
      1.992179,
      2,
      NULL,
      NULL,
      0.655940,
      0.086461,
      NULL,
      NULL,
      ' 0-11-1994',
      40.549357,
      NULL,
      0,
      1,
      1,
      ' 4- 6-1976',
      36.553188,
      1.958036,
      NULL,
      77,
      1.300757,
      '10-20-1990',
      ' 3-15-1997',
      ' 1- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      0.468834,
      1.723779,
      0.591925,
      0.237411,
      NULL,
      NULL,
      NULL,
      13,
      2,
      16.575057,
      8.604729,
      4.507582,
      NULL,
      3.526956,
      NULL,
      2,
      NULL,
      2,
      0,
      1.185114,
      0,
      0,
      1.713165,
      3.640445,
      0.694004,
      0,
      1,
      0.395994,
      2,
      3,
      3.750359,
      5,
      1.593822,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.226546,
      0.998827,
      0.286787,
      1,
      1.625351,
      3,
      0.143667,
      0.326876,
      NULL,
      NULL,
      NULL,
      0.544098,
      5.173795,
      NULL,
      7,
      1.328202,
      1,
      1.691310,
      1.131604,
      0,
      0.891274,
      0.929760,
      0,
      1.479881,
      NULL,
      0,
      1.484023,
      1.090954,
      NULL,
      0.295557,
      NULL,
      0.337367,
      0.748710,
      0.563307,
      1,
      1,
      3.076863,
      0,
      3.590697,
      NULL,
      1.594363,
      NULL,
      NULL,
      1.232630,
      4.313852,
      0.358612,
      0,
      1.955998,
      1,
      1.028235,
      1,
      NULL,
      NULL,
      0.254011,
      3.101926,
      0,
      NULL,
      NULL,
      0.250399,
      3.203058,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      2,
      5,
      4.681839,
      9,
      1.450870,
      NULL,
      4.602622,
      2,
      NULL,
      NULL,
      9.995884,
      8.568134,
      5,
      3.333155,
      0.396273,
      NULL,
      4.460340,
      2.278335,
      4.750551,
      3,
      2.378722,
      2.154752,
      3,
      NULL,
      3.702967,
      8,
      3.032685,
      ' 9-20-1984',
      58,
      NULL,
      NULL,
      2,
      4.099846,
      NULL,
      6,
      1.292154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750684,
      1.760521,
      1,
      1.338740,
      0.678859,
      NULL,
      1.417775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.622685,
      NULL,
      4.625023,
      1,
      0.082223,
      NULL,
      NULL,
      5,
      6.487780,
      1.129102,
      0.149791,
      2,
      NULL,
      0.986781,
      NULL,
      3,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1.508489,
      1.667147,
      2,
      5.617622,
      8.515336,
      ' 3-25-2002',
      21.326803,
      NULL,
      1,
      2.945486,
      3,
      0,
      1,
      NULL,
      0.488732,
      3.992826,
      1.464302,
      NULL,
      NULL,
      2,
      NULL,
      3.182679,
      1.060136,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170144,
      0.683119,
      NULL,
      0,
      0.471493,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.458740,
      2.466835,
      3,
      3,
      1.176557,
      1,
      1.010910,
      1.573625,
      0,
      1,
      NULL,
      NULL,
      1,
      1.471262,
      0.011365,
      NULL,
      0,
      NULL,
      1.971639,
      9.473727,
      6.260797,
      5,
      0.738540,
      NULL,
      3.231706,
      2,
      NULL,
      4.799602,
      1,
      0,
      1,
      35,
      NULL,
      2,
      NULL,
      3.177648,
      1,
      24.483645,
      2,
      3,
      2.261305,
      NULL,
      '',
      '',
      1.758694,
      '',
      NULL,
      '',
      NULL,
      '2411',
      '2341',
      '',
      0.467016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      1.429377,
      NULL,
      1.876877,
      NULL,
      NULL,
      2,
      NULL,
      0.562085,
      0.757146,
      NULL,
      NULL,
      0.947989,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546686,
      1.458585,
      NULL,
      1.140330,
      0,
      1,
      NULL,
      1.191467,
      0,
      1.076818,
      0,
      1.041458,
      1.916594,
      0.674616,
      0.355912,
      NULL,
      1.042100,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.901080,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719611,
      0.224628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.211824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673840,
      3.722414,
      NULL,
      1.646677,
      NULL,
      0.385372,
      NULL,
      NULL,
      NULL,
      1.028111,
      NULL,
      1.943966,
      NULL,
      0.127346,
      0.867787,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.605281,
      1.987556,
      3,
      0,
      0.571126,
      3,
      3.526089,
      4,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.651552,
      2.067032,
      NULL,
      3,
      0,
      NULL,
      1,
      1.856708,
      NULL,
      2,
      1,
      NULL,
      0.163230,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.656174,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.321843,
      0.996352,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138911,
      NULL,
      1.336036,
      NULL,
      1,
      NULL,
      1.807391,
      1.446929,
      0.152828,
      1.450590,
      NULL,
      NULL,
      23,
      14,
      3,
      0,
      1.602832,
      '32101',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


