set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9518819';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '0133414',
      1.650351,
      1,
      0,
      2,
      '1311',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      37.070429,
      NULL,
      4.756051,
      0,
      1,
      ' 2-12-1994',
      15.617616,
      3,
      83,
      1.260755,
      3,
      ' 2-13-2001',
      NULL,
      ' 1-14-1990',
      3.741773,
      3.450854,
      2.213938,
      0.757427,
      0,
      2,
      1.584330,
      3.002541,
      NULL,
      NULL,
      NULL,
      2.987600,
      10.885898,
      2,
      6.706669,
      9.381723,
      1.512517,
      0,
      3.276957,
      9,
      1,
      0,
      0,
      0,
      0.944477,
      NULL,
      1,
      5.168384,
      0,
      0.383121,
      0,
      2,
      1.435102,
      5.991687,
      0.290237,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      0.588199,
      1,
      1,
      1.223106,
      0.436530,
      NULL,
      NULL,
      0,
      2.257507,
      3.342041,
      1,
      1.221440,
      4.133236,
      1,
      0.891065,
      0,
      1,
      1,
      1,
      0.350007,
      3,
      0,
      1.192294,
      1,
      0.899552,
      1,
      NULL,
      1,
      1,
      0,
      0.231554,
      0.876135,
      1.107592,
      0.738707,
      2,
      1.993097,
      1.827940,
      NULL,
      NULL,
      0.849436,
      NULL,
      3.909565,
      0.814802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.163294,
      NULL,
      0.660767,
      0.846792,
      NULL,
      0.385856,
      1.424110,
      NULL,
      1,
      1,
      NULL,
      1,
      0.682316,
      NULL,
      0,
      6.300256,
      1.023219,
      0.680303,
      3.651417,
      1,
      6,
      0.269782,
      5,
      2.117604,
      8.979214,
      1,
      2.710944,
      7.980924,
      0.120427,
      3,
      4,
      3,
      6.441214,
      0,
      0.132456,
      5.716293,
      9.590798,
      5.780433,
      1,
      NULL,
      4.915162,
      NULL,
      ' 3-11-1989',
      NULL,
      ' 8-24-1984',
      3.645314,
      1.079989,
      1,
      0.531280,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.159036,
      1,
      0,
      0.182398,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.546533,
      3,
      NULL,
      0.651757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.106294,
      1.834455,
      0.486309,
      0,
      1,
      6.749282,
      NULL,
      NULL,
      5,
      7.550173,
      9.317633,
      NULL,
      2.658761,
      1,
      2,
      4.574940,
      NULL,
      NULL,
      5.588441,
      6.274463,
      9,
      ' 1-26-1992',
      157,
      '11-11-1976',
      10,
      1.422532,
      3,
      NULL,
      2,
      1.139720,
      1,
      0,
      NULL,
      1.574838,
      1.592034,
      2.345457,
      28.454654,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.070524,
      0.793756,
      2.534860,
      0.856743,
      NULL,
      0.189213,
      0,
      0,
      1.050898,
      3,
      0,
      2,
      3,
      2,
      0,
      3,
      7.342183,
      1.920361,
      1.816490,
      1,
      1,
      1,
      1.316988,
      0,
      0,
      0,
      1,
      0,
      0.085205,
      0,
      3,
      1.845315,
      1.861912,
      3,
      NULL,
      NULL,
      8.816647,
      7,
      5.257752,
      0.487976,
      2,
      0.706058,
      1,
      NULL,
      46.361577,
      NULL,
      NULL,
      NULL,
      70,
      NULL,
      86,
      3.944755,
      1.098077,
      3.580300,
      '13040',
      '',
      '',
      0.428180,
      '',
      '',
      '',
      1.670518,
      '',
      NULL,
      '',
      0.334035,
      NULL,
      NULL,
      16,
      0,
      29,
      0,
      1,
      5,
      0.631305,
      3.416773,
      0,
      NULL,
      NULL,
      NULL,
      0.578062,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.130620,
      0,
      1,
      NULL,
      0.178735,
      0,
      0.310678,
      NULL,
      NULL,
      1.163847,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.870809,
      NULL,
      0.228563,
      1.261632,
      0.272593,
      NULL,
      NULL,
      NULL,
      1.023825,
      NULL,
      NULL,
      NULL,
      0.590566,
      0.434301,
      2.872809,
      1,
      NULL,
      NULL,
      3.281248,
      1,
      0.048348,
      2.339532,
      0,
      NULL,
      3.431761,
      0.505877,
      0,
      3,
      0.831233,
      0,
      2.738106,
      2.333708,
      0.231125,
      NULL,
      NULL,
      1.009485,
      0.551687,
      1.627650,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.308395,
      0,
      NULL,
      0.196517,
      0,
      3,
      0.344221,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.653226,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.006209,
      0,
      0.105316,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.942289,
      2.247308,
      2,
      1,
      NULL,
      NULL,
      2,
      2.579948,
      2,
      NULL,
      1.658978,
      NULL,
      2.860111,
      3.204870,
      1,
      0.177867,
      1.729183,
      0.136732,
      1.015604,
      0.088328,
      NULL,
      1.915911,
      NULL,
      NULL,
      2,
      NULL,
      1.696933,
      2,
      NULL,
      2,
      8.256407,
      4,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      0.896099,
      1.975033,
      0.658726,
      0.945009,
      1.492169,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534666,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.946204,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      0.958655,
      1,
      0.923365,
      NULL,
      3,
      NULL,
      9.853729,
      NULL,
      1.079541,
      NULL,
      6.198578,
      NULL,
      5,
      NULL,
      3.508018,
      NULL,
      2.175676,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.675539,
      NULL,
      1.354882,
      NULL,
      1.379209,
      NULL,
      NULL,
      NULL,
      2.869837,
      NULL,
      NULL,
      NULL,
      1.675582,
      NULL,
      NULL,
      NULL,
      0.915568,
      NULL,
      1,
      NULL,
      1.591389,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.152053,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      3,
      NULL,
      2.219208,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.414122,
      NULL,
      9,
      NULL,
      7,
      NULL,
      0.835970,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      2.122868,
      NULL,
      NULL,
      0.532019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.411230,
      NULL,
      1.185445,
      1.032774,
      1,
      1.084517,
      0.919064,
      0,
      1.120233,
      1,
      0.185220,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0.350159,
      NULL,
      0,
      0.930634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720126,
      1,
      0.172558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.800584,
      0.390199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.762708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588253,
      1.403395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.894664,
      NULL,
      NULL,
      1.002577,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.673071,
      1.993765,
      1,
      0,
      0.897273,
      1.896568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      6,
      3,
      NULL,
      3,
      3,
      2,
      0,
      0.401171,
      3.082301,
      3,
      0,
      3,
      0.823894,
      2.558214,
      NULL,
      3.963097,
      NULL,
      1.912913,
      NULL,
      2,
      0.235668,
      2,
      1.582481,
      3.031882,
      NULL,
      NULL,
      NULL,
      1,
      1.116559,
      NULL,
      0,
      1.424410,
      0.340163,
      0,
      1.091260,
      0.251970,
      NULL,
      3.851044,
      1,
      1,
      0.917868,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.051706,
      0,
      1,
      NULL,
      0.414825,
      NULL,
      0.880737,
      3.585212,
      5,
      0.326127,
      NULL,
      NULL,
      NULL,
      148.506836,
      2,
      4,
      1.093130,
      '03341',
      NULL,
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


