set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6225292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      2.474810,
      0,
      3,
      3,
      '0434',
      2,
      1.375410,
      NULL,
      NULL,
      ' 1-24-1975',
      27,
      NULL,
      4.851658,
      0,
      0.365895,
      ' 3- 2-1999',
      38,
      3.410899,
      349.143923,
      3,
      2,
      '10- 0-1975',
      ' 7- 2-1998',
      ' 6- 9-1974',
      0.993607,
      2.948909,
      0.345042,
      1,
      NULL,
      3.615138,
      2.680735,
      0.419055,
      1,
      11,
      10,
      NULL,
      3,
      6,
      15.179135,
      9.343394,
      5.021709,
      0.587802,
      3.229563,
      NULL,
      0.765442,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.319919,
      6.701050,
      3.974039,
      3.099027,
      NULL,
      1.391461,
      1.784821,
      NULL,
      1.392600,
      NULL,
      NULL,
      1.701990,
      1.562671,
      0,
      1.907312,
      4.518577,
      0.375086,
      4,
      1.789706,
      NULL,
      0,
      NULL,
      NULL,
      2,
      5,
      0,
      1,
      1.411333,
      1.378615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.990258,
      1.436525,
      3.920980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.303730,
      NULL,
      0,
      NULL,
      NULL,
      1.076282,
      NULL,
      1,
      1.422169,
      1.282136,
      0.663159,
      NULL,
      NULL,
      0.435477,
      1,
      1.208724,
      NULL,
      0.726779,
      NULL,
      5,
      0.237244,
      1,
      1.169387,
      1.056137,
      NULL,
      NULL,
      4,
      NULL,
      4.314034,
      2,
      NULL,
      0,
      NULL,
      2,
      2,
      1,
      6,
      8,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2.240675,
      1.542984,
      ' 3-28-1993',
      476,
      ' 8-16-1981',
      10.740186,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.951385,
      0.167639,
      1.899157,
      0.666884,
      1.150658,
      0,
      1.364548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148929,
      NULL,
      8.116694,
      2.558303,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.923287,
      3.686615,
      NULL,
      2.430066,
      1.827484,
      0.003458,
      6,
      7,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472047,
      8,
      0,
      3,
      2,
      5.866863,
      1,
      '10-18-1974',
      21,
      NULL,
      5,
      2.112655,
      NULL,
      1,
      NULL,
      0,
      0,
      3.710445,
      0.933031,
      1.063831,
      0.740689,
      3,
      11,
      NULL,
      0.156388,
      NULL,
      NULL,
      NULL,
      0,
      0.183782,
      0,
      2,
      NULL,
      1.372741,
      NULL,
      NULL,
      2.357846,
      1,
      NULL,
      1,
      3.126212,
      0,
      2.481073,
      NULL,
      5,
      1,
      1,
      0.228682,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.603983,
      NULL,
      NULL,
      6,
      0.800979,
      0,
      3.972830,
      1,
      NULL,
      2,
      2,
      1.111831,
      NULL,
      2.468447,
      49.382538,
      NULL,
      0.193971,
      NULL,
      NULL,
      5,
      59,
      NULL,
      0.439948,
      0,
      '44030',
      '',
      '',
      0,
      '12100',
      '',
      '',
      3,
      NULL,
      '1034',
      '4433',
      NULL,
      22,
      846.580669,
      18.014178,
      NULL,
      25.228753,
      NULL,
      0.077907,
      NULL,
      3.945490,
      2,
      3.940474,
      0.611468,
      NULL,
      NULL,
      NULL,
      2,
      1.304016,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.219817,
      NULL,
      0.167974,
      NULL,
      3.200357,
      0,
      NULL,
      NULL,
      NULL,
      0.241963,
      NULL,
      NULL,
      0.934724,
      NULL,
      NULL,
      1.754548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.448869,
      NULL,
      3.515524,
      0.461009,
      0.445280,
      NULL,
      NULL,
      NULL,
      2.567518,
      1.456495,
      1.881887,
      0.856374,
      NULL,
      1.182674,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.043475,
      1,
      1,
      0.610542,
      1,
      1,
      1.599867,
      0,
      2.072977,
      0.064336,
      NULL,
      1.053052,
      1.784309,
      NULL,
      NULL,
      2,
      NULL,
      3.552480,
      0,
      0,
      0.051569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.056497,
      9.444777,
      0,
      0,
      1.407833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.093924,
      NULL,
      NULL,
      NULL,
      3,
      1.712234,
      0,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.034127,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.810940,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010197,
      NULL,
      NULL,
      0.087022,
      NULL,
      NULL,
      3.690115,
      NULL,
      0,
      3.116159,
      3,
      3,
      9.112517,
      2.097702,
      4.030161,
      1,
      NULL,
      6.234656,
      0.028968,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      0.748729,
      0,
      1,
      2.252611,
      3,
      NULL,
      5,
      2.244598,
      2,
      NULL,
      0.261741,
      1.263676,
      1,
      2,
      NULL,
      3,
      3,
      2.539028,
      2,
      NULL,
      1,
      6.634637,
      3,
      3.932694,
      0,
      0,
      1.706448,
      3.913333,
      0,
      1,
      0,
      1,
      0.013017,
      3,
      NULL,
      NULL,
      0.022736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.451181,
      NULL,
      NULL,
      0.233122,
      NULL,
      NULL,
      1.884810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.450210,
      0,
      NULL,
      2,
      0.656664,
      NULL,
      3.288603,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.457136,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1.782806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.482156,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.485316,
      NULL,
      NULL,
      3,
      1.712511,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.979326,
      1,
      NULL,
      0,
      2,
      3,
      NULL,
      2,
      0.007385,
      3.750677,
      NULL,
      3,
      3,
      3.715532,
      NULL,
      NULL,
      0.802222,
      NULL,
      NULL,
      3,
      1,
      2.410382,
      NULL,
      1,
      0,
      3.951528,
      NULL,
      9,
      9.188729,
      0.926157,
      NULL,
      NULL,
      NULL,
      3,
      3.780646,
      4,
      0,
      276.564219,
      55.144000,
      3,
      NULL,
      1.908496,
      NULL,
      NULL,
      NULL,
      3.014876,
      NULL,
      NULL,
      3,
      0.398731,
      1,
      NULL,
      NULL,
      NULL,
      0,
      9,
      1.256545,
      187.079293,
      2,
      1.147796,
      NULL,
      1.399181,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0.859890,
      0,
      0,
      NULL,
      0.151761,
      0.016217,
      0,
      NULL,
      1.016686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.657240,
      3.133852,
      NULL,
      0,
      7.283209,
      4,
      0.690441,
      4,
      0.480510,
      3.104261,
      1.035603,
      1,
      1.941859,
      NULL,
      NULL,
      0,
      3.245307,
      1.049522,
      1.205612,
      3.786847,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0.978957,
      1.669484,
      3,
      NULL,
      2,
      0.825888,
      0.432760,
      0,
      0,
      NULL,
      1.794658,
      3,
      NULL,
      1.806192,
      NULL,
      NULL,
      2.486947,
      0.520727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.562525,
      NULL,
      0.780901,
      NULL,
      3.358850,
      NULL,
      2.071313,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.046678,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      1.662073,
      0,
      2,
      0,
      1.875511,
      3,
      6.510407,
      6.346601,
      0.587197,
      1.400994,
      1.539755,
      NULL,
      64,
      0,
      0.335040,
      3.416868,
      NULL,
      '',
      '',
      0,
      '11323',
      '',
      '',
      NULL,
      '00302',
      NULL,
      '3212');
commit;
end;
/


