set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5806722';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      1.080368,
      0.397774,
      1,
      3,
      '4010',
      0,
      0.040681,
      NULL,
      NULL,
      '11-29-1981',
      19,
      NULL,
      1.218534,
      3.513230,
      0,
      ' 2-16-1988',
      36.521781,
      4,
      NULL,
      62,
      2,
      ' 4- 1-1998',
      NULL,
      ' 4- 2-2002',
      1.451978,
      NULL,
      3.257854,
      1,
      0,
      1.978267,
      1.205126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      75,
      80.807604,
      8.991484,
      5.900589,
      NULL,
      NULL,
      8.349134,
      1.520244,
      NULL,
      0.053537,
      0.533801,
      0,
      NULL,
      1,
      0.366304,
      NULL,
      0,
      0.463687,
      NULL,
      1.068997,
      3,
      1,
      4.359976,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.485504,
      1,
      1.967336,
      1.481212,
      2,
      NULL,
      1.790929,
      2.106937,
      2.407510,
      1.690829,
      1.863670,
      NULL,
      NULL,
      1.471565,
      NULL,
      NULL,
      2,
      5,
      9.738043,
      1,
      2,
      NULL,
      NULL,
      2.802216,
      0.537668,
      0,
      3.882840,
      1.170546,
      2,
      1.853047,
      NULL,
      1.022168,
      NULL,
      2.666901,
      3,
      NULL,
      NULL,
      0.992904,
      5.607308,
      1,
      3.812462,
      3,
      0.804801,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.751665,
      0,
      2.244236,
      1,
      5.823497,
      0,
      3.693844,
      0.970208,
      1,
      0.355641,
      0,
      NULL,
      1.929642,
      0,
      0,
      0,
      1,
      1.127289,
      NULL,
      NULL,
      1.808726,
      0.711966,
      1.494209,
      1.673772,
      0,
      1.647576,
      2.248949,
      NULL,
      0.921345,
      3.095503,
      3,
      1,
      1.149323,
      4.167730,
      0.524657,
      1.962723,
      3,
      NULL,
      2.891532,
      NULL,
      1.229795,
      3.281427,
      NULL,
      3.606354,
      1.601126,
      0,
      NULL,
      1,
      ' 3-28-1974',
      NULL,
      '10-23-1996',
      6,
      0.969738,
      0,
      1.664936,
      0.816445,
      2.147959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345071,
      1.005185,
      1,
      1,
      NULL,
      1.822242,
      0.962130,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.553381,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.854829,
      0,
      NULL,
      3.888502,
      1,
      0.824252,
      NULL,
      0.237086,
      1,
      1.285649,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.806789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851756,
      NULL,
      0.988891,
      1,
      0,
      1.000768,
      1,
      1.812455,
      12,
      0.323457,
      0.487895,
      NULL,
      NULL,
      NULL,
      2.005805,
      NULL,
      3.260257,
      NULL,
      NULL,
      0.645547,
      0,
      1,
      NULL,
      1.157653,
      1.740009,
      2.014373,
      2,
      3,
      7,
      8.628616,
      60.007219,
      40,
      103,
      87,
      94,
      165.946879,
      0.611079,
      0.051869,
      NULL,
      NULL,
      59,
      113,
      0.016724,
      15,
      NULL,
      0.932405,
      NULL,
      NULL,
      3,
      5.234061,
      NULL,
      5.203568,
      1,
      2,
      1,
      2.069132,
      2,
      0.399955,
      NULL,
      NULL,
      0.310744,
      NULL,
      NULL,
      NULL,
      59.972107,
      1,
      0.795647,
      4,
      '42400',
      '32031',
      NULL,
      1,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      0.014775,
      9.288852,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.521173,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0.006792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.249181,
      1.156557,
      NULL,
      NULL,
      0.460030,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.796898,
      1.669724,
      3.137718,
      NULL,
      0.897202,
      3,
      2,
      3,
      2.671466,
      1.051224,
      1,
      NULL,
      NULL,
      NULL,
      1.717997,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      3.806130,
      1.670959,
      1,
      0.085351,
      0.908639,
      NULL,
      0.216301,
      3.981582,
      0,
      2.133645,
      0.798823,
      0,
      3,
      NULL,
      1,
      2.504243,
      0.491919,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.989485,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.596989,
      NULL,
      NULL,
      0.041302,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.293074,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.528902,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.355715,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.934890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.772542,
      NULL,
      NULL,
      2.618364,
      NULL,
      1.103538,
      NULL,
      2.369990,
      2,
      2.713603,
      0,
      1,
      NULL,
      3,
      1.583679,
      NULL,
      2.465684,
      NULL,
      0,
      NULL,
      NULL,
      1.506758,
      NULL,
      NULL,
      0,
      1.405736,
      0.594255,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.112575,
      0.010818,
      1.404409,
      0.392973,
      0.311634,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.661683,
      0.591705,
      NULL,
      0.535469,
      NULL,
      NULL,
      0.761540,
      NULL,
      NULL,
      1.170749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      6.843905,
      2.822466,
      0.089919,
      NULL,
      1,
      1.115417,
      0,
      0.141709,
      0.099882,
      1,
      1.825175,
      1.063479,
      0,
      2.586628,
      1.985062,
      0.833171,
      NULL,
      2,
      NULL,
      2,
      NULL,
      1.871640,
      NULL,
      1.139525,
      NULL,
      2,
      NULL,
      0.103192,
      NULL,
      375.775640,
      NULL,
      1.331728,
      NULL,
      8.328289,
      NULL,
      1.141847,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0.070075,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1.240384,
      NULL,
      0.267346,
      NULL,
      0.492365,
      NULL,
      0.690399,
      NULL,
      1,
      NULL,
      1.245693,
      NULL,
      NULL,
      NULL,
      0.007058,
      NULL,
      2.471070,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.027130,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.990857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.286852,
      NULL,
      NULL,
      1,
      1.744393,
      1.339424,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.354709,
      3,
      4,
      NULL,
      0.153196,
      0,
      3.427123,
      NULL,
      1,
      1.384578,
      NULL,
      1.516555,
      0,
      NULL,
      1.686562,
      1.245441,
      NULL,
      NULL,
      3,
      NULL,
      1.399872,
      1.376630,
      NULL,
      1.441048,
      0.538138,
      NULL,
      0,
      0,
      NULL,
      0.192208,
      0.467248,
      NULL,
      0.363472,
      1,
      NULL,
      0,
      1,
      NULL,
      0.343719,
      0.729357,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.445521,
      1.488199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748087,
      NULL,
      0.626622,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      110,
      NULL,
      5.582641,
      NULL,
      '33333',
      '42042',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


