set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8804734';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '2014210',
      NULL,
      0,
      3,
      NULL,
      '1421',
      1,
      0.584309,
      NULL,
      NULL,
      ' 5-27-1998',
      5,
      NULL,
      3,
      NULL,
      NULL,
      ' 1- 6-1993',
      2,
      1,
      NULL,
      95.098662,
      3,
      ' 4-22-2000',
      ' 1-23-1999',
      ' 5-11-1996',
      1.295594,
      1,
      0,
      1.194079,
      0,
      NULL,
      2.250978,
      0,
      NULL,
      NULL,
      NULL,
      8.286444,
      1.953021,
      NULL,
      145.135374,
      9,
      1,
      12.950287,
      NULL,
      3.212995,
      2.359284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      1.957351,
      2.729598,
      NULL,
      3,
      1.424142,
      1,
      NULL,
      1,
      3,
      0,
      1.301824,
      1.942371,
      0.782498,
      0.498782,
      0,
      NULL,
      0,
      3,
      1,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.330038,
      4,
      NULL,
      0,
      NULL,
      1,
      0.753005,
      1.261075,
      1,
      0,
      0.578412,
      1.580907,
      1,
      1.707299,
      1,
      1,
      1,
      0.725537,
      2,
      1,
      7,
      2.892453,
      0,
      2,
      2.128461,
      0.719590,
      NULL,
      NULL,
      1.249520,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.100852,
      1.460219,
      0,
      NULL,
      0.900248,
      1.513001,
      4,
      0.265441,
      1,
      NULL,
      1.065907,
      1.178662,
      NULL,
      1,
      1.792525,
      2.971268,
      NULL,
      1,
      0.786806,
      NULL,
      1,
      0.786110,
      NULL,
      1.025747,
      1.507549,
      0,
      1.097150,
      0.771192,
      2,
      0,
      0,
      1,
      0,
      0,
      0.150549,
      2.683668,
      7,
      NULL,
      NULL,
      3,
      NULL,
      ' 8- 1-1990',
      589.328105,
      ' 0-24-1997',
      356.834984,
      1.199831,
      0,
      1.040074,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115558,
      1.061671,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.315617,
      1,
      NULL,
      0.269716,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.976316,
      0.159308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.513089,
      1,
      1,
      1.641829,
      0,
      1.014259,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.964254,
      90.703868,
      24,
      2,
      0.273557,
      NULL,
      '23230',
      '23311',
      '',
      1.895068,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2.835808,
      32,
      152,
      32.565760,
      1.315591,
      NULL,
      NULL,
      NULL,
      NULL,
      0.682494,
      3.296138,
      2.773799,
      1,
      NULL,
      NULL,
      1.646768,
      NULL,
      NULL,
      0.947388,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.474653,
      1,
      1.621160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673051,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      4,
      NULL,
      0.645295,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.939488,
      0,
      NULL,
      0.416022,
      NULL,
      NULL,
      1,
      NULL,
      1.276061,
      1,
      1.601072,
      0.354307,
      1.240417,
      0,
      1,
      1,
      1.314422,
      1,
      NULL,
      0.419147,
      1.689013,
      1,
      NULL,
      NULL,
      0.790550,
      0.312203,
      NULL,
      NULL,
      0.325683,
      NULL,
      NULL,
      0.699847,
      NULL,
      NULL,
      8.578314,
      NULL,
      6,
      0.713347,
      NULL,
      NULL,
      NULL,
      NULL,
      0.551306,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.611704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.514689,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.387781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.138250,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.296518,
      2,
      2,
      3.674315,
      0,
      0,
      0,
      2.451018,
      2,
      0.336464,
      NULL,
      0.986750,
      6.653980,
      2,
      3.256625,
      6,
      NULL,
      4.410419,
      NULL,
      0.508876,
      2.441978,
      0,
      NULL,
      NULL,
      1.802808,
      1,
      3.256060,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406779,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.088656,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.981156,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.519917,
      1,
      0.176879,
      NULL,
      0,
      1.138101,
      NULL,
      NULL,
      1.121637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.579334,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.003423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.111457,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.299009,
      NULL,
      NULL,
      1,
      NULL,
      0,
      5009.164458,
      NULL,
      1.692646,
      1,
      0,
      0,
      0,
      1.744133,
      NULL,
      NULL,
      0.285889,
      1,
      NULL,
      0.619611,
      1,
      1,
      1,
      NULL,
      0,
      0.109571,
      NULL,
      1.944644,
      NULL,
      1.380318,
      NULL,
      1,
      NULL,
      0.158580,
      NULL,
      1,
      NULL,
      5,
      NULL,
      1,
      6.540706,
      53.686564,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689706,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.619470,
      NULL,
      1,
      NULL,
      1.255290,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.059676,
      NULL,
      0,
      NULL,
      0.641646,
      NULL,
      0.202335,
      NULL,
      1,
      3,
      1.845652,
      0.656656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.230791,
      0,
      NULL,
      2.099816,
      NULL,
      1.472781,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0.983787,
      1.741106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636317,
      1.034542,
      3,
      4.387752,
      0.545796,
      NULL,
      NULL,
      3,
      3,
      2.483493,
      2.696283,
      0.643846,
      0,
      4.112943,
      NULL,
      1,
      0,
      NULL,
      NULL,
      11.380852,
      NULL,
      13.473406,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      13.407036,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      15.731081,
      NULL,
      10.102173,
      NULL,
      NULL,
      15,
      2.211197,
      NULL,
      14.368460,
      7.918785,
      NULL,
      0.506531,
      0.238101,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.349706,
      NULL,
      0,
      NULL,
      0.962255,
      NULL,
      0.040562,
      NULL,
      NULL,
      NULL,
      46.835958,
      89.700290,
      7,
      0,
      NULL,
      NULL,
      NULL,
      '',
      1.001482,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


