set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9009166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '3302100',
      3,
      1.436864,
      1,
      NULL,
      '1444',
      1,
      1.964092,
      NULL,
      NULL,
      ' 0-12-1975',
      10.312049,
      NULL,
      4,
      0.668780,
      0.008688,
      ' 4-23-1977',
      24.862271,
      0,
      NULL,
      112.479155,
      2.891612,
      ' 6- 5-1985',
      '11-29-1976',
      NULL,
      1.691873,
      3.178533,
      NULL,
      0,
      NULL,
      0,
      1.415588,
      NULL,
      1.663188,
      2,
      8,
      18,
      NULL,
      NULL,
      23.095272,
      1.946710,
      16,
      4,
      3,
      6,
      0.896774,
      1.763952,
      0.539755,
      NULL,
      1.902945,
      0.468177,
      NULL,
      1,
      NULL,
      2,
      0,
      1.074573,
      0,
      0.530572,
      2,
      0,
      1,
      5.331296,
      1.357772,
      0,
      NULL,
      7.146770,
      0,
      0.101114,
      NULL,
      5,
      1.145936,
      1,
      NULL,
      NULL,
      0.285556,
      4,
      1.633760,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      8.266211,
      NULL,
      1.003228,
      3,
      0,
      2,
      1.197772,
      3.042010,
      2,
      3,
      NULL,
      NULL,
      0.283383,
      0.170145,
      0,
      0,
      0.842920,
      NULL,
      11.461268,
      4.271021,
      NULL,
      NULL,
      1,
      5.338818,
      5,
      1,
      NULL,
      NULL,
      0.224948,
      NULL,
      0,
      0.746454,
      1.880935,
      NULL,
      0.844535,
      NULL,
      1.112039,
      0,
      0.707564,
      0,
      6.358461,
      1.283909,
      0,
      1.611696,
      0,
      0.843280,
      NULL,
      1.539598,
      1.878081,
      0,
      NULL,
      1,
      NULL,
      3.745051,
      2,
      3,
      1,
      3.275473,
      0,
      1,
      1.363040,
      1,
      NULL,
      1,
      3,
      0.771734,
      NULL,
      1.610040,
      1,
      3.014907,
      NULL,
      6,
      NULL,
      5,
      7,
      4.775528,
      2,
      3.817522,
      NULL,
      NULL,
      3,
      ' 5- 4-1982',
      4,
      1.278524,
      3,
      NULL,
      0.629254,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.629972,
      0,
      NULL,
      NULL,
      0.763992,
      NULL,
      1.128412,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      0,
      1,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      1.601834,
      2.042865,
      0,
      NULL,
      0.928026,
      3.321921,
      2,
      6.430839,
      4.917252,
      NULL,
      9.350580,
      0.621458,
      3.405010,
      4,
      1.130637,
      NULL,
      NULL,
      0.521943,
      6.098278,
      2,
      0.349930,
      6.025242,
      1.945525,
      7.419061,
      NULL,
      NULL,
      NULL,
      7,
      1.764209,
      2.444603,
      NULL,
      2,
      1.182967,
      0,
      0.800852,
      1,
      0,
      1.949086,
      NULL,
      NULL,
      0.375931,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      4,
      2,
      0.820936,
      3.899830,
      5,
      NULL,
      7.068320,
      0,
      0,
      NULL,
      0,
      3.761068,
      3,
      3,
      NULL,
      NULL,
      0,
      1.619176,
      0.751954,
      NULL,
      0.389836,
      1.220380,
      0,
      NULL,
      1,
      1,
      0.241615,
      0.006374,
      NULL,
      NULL,
      2.287062,
      NULL,
      1,
      1,
      0,
      NULL,
      0.223163,
      6,
      0,
      1.310508,
      3,
      43,
      2.442614,
      NULL,
      NULL,
      58.806071,
      16.240266,
      56.179381,
      5,
      1.220595,
      NULL,
      '20232',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1.754551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.804524,
      1,
      1.759178,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.352682,
      NULL,
      1,
      1.864328,
      1.952589,
      0.460280,
      1.960328,
      1.395350,
      1.703205,
      0,
      0.527235,
      1,
      0.638503,
      0,
      0,
      0,
      0.602318,
      1,
      0,
      0.701352,
      2,
      NULL,
      1.904553,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.285976,
      NULL,
      1.061725,
      NULL,
      NULL,
      NULL,
      0.951995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810584,
      NULL,
      NULL,
      1.615166,
      NULL,
      1.005193,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.604089,
      NULL,
      0.739264,
      NULL,
      1.089789,
      0.009773,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222136,
      NULL,
      NULL,
      0.263027,
      NULL,
      1.478050,
      NULL,
      NULL,
      NULL,
      0.409935,
      NULL,
      0,
      NULL,
      1.429492,
      1,
      0.962562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187498,
      0,
      NULL,
      2.428355,
      NULL,
      0.412065,
      3.602550,
      0,
      4,
      2,
      0.586802,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.794766,
      0.635709,
      NULL,
      1.730286,
      0,
      NULL,
      NULL,
      2.559704,
      NULL,
      0.463016,
      0.185551,
      NULL,
      1.004382,
      1,
      NULL,
      1.101713,
      NULL,
      NULL,
      0.449440,
      0.882861,
      NULL,
      0.357660,
      1.120934,
      NULL,
      1,
      1.048019,
      NULL,
      0.722742,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886303,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.367406,
      5,
      6.226999,
      NULL,
      NULL,
      NULL,
      78.700595,
      131,
      7,
      0.994908,
      1.840405,
      '04303',
      '',
      '',
      1,
      '',
      '',
      '',
      0.178539,
      '',
      '',
      NULL);
commit;
end;
/


