set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6604658';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '0120111',
      3,
      1,
      6,
      NULL,
      '1412',
      3.308595,
      1,
      NULL,
      NULL,
      ' 1-10-1983',
      49.409502,
      NULL,
      NULL,
      2,
      1,
      ' 8-16-1976',
      47,
      3,
      55.413855,
      NULL,
      NULL,
      ' 0- 0-2003',
      '11-16-1976',
      ' 5- 4-2000',
      2,
      NULL,
      NULL,
      0,
      1.015013,
      0.296317,
      0.822822,
      3.903235,
      NULL,
      NULL,
      NULL,
      7.753598,
      5.986947,
      27.949675,
      12,
      4.275513,
      NULL,
      NULL,
      2,
      3,
      3.112050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260257,
      1,
      1.027126,
      8.039702,
      1.985520,
      2.288845,
      4,
      1,
      NULL,
      4.405346,
      0,
      4,
      1,
      1,
      NULL,
      3,
      1,
      4.475887,
      NULL,
      1,
      1.906282,
      NULL,
      NULL,
      2.575863,
      2,
      1.349845,
      NULL,
      0.351031,
      0,
      0.610382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.358449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461859,
      3,
      0.224602,
      1,
      0.999062,
      4,
      6.426892,
      0,
      0,
      1.483618,
      0,
      2,
      0.182154,
      0.606639,
      NULL,
      1.719818,
      0,
      0.572852,
      1.560580,
      NULL,
      0,
      5.147294,
      5.632323,
      0.265152,
      6,
      2.784260,
      4.453158,
      0.494885,
      0,
      0.862995,
      1.171443,
      0,
      NULL,
      NULL,
      1,
      2.534433,
      NULL,
      1,
      7,
      5.221325,
      NULL,
      3,
      NULL,
      5,
      3,
      1.290575,
      1.110858,
      0,
      ' 6-20-1988',
      NULL,
      ' 0- 2-2000',
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.311469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.984164,
      1.776298,
      0.834386,
      1.131632,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.548151,
      NULL,
      761,
      NULL,
      1.559831,
      NULL,
      0.669575,
      NULL,
      0.212501,
      3.339539,
      1.633461,
      5,
      NULL,
      0,
      NULL,
      0.216377,
      0,
      NULL,
      1.569977,
      1,
      2.133209,
      2,
      2.884425,
      4.455379,
      0,
      NULL,
      NULL,
      0.871853,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.764640,
      0.218009,
      0,
      NULL,
      1.696872,
      1,
      1,
      17.419045,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.964248,
      1.325761,
      0,
      3,
      3.694828,
      2.268667,
      3,
      2,
      5,
      3.166143,
      5.235945,
      3,
      5,
      0,
      0.232534,
      2.508482,
      0.403932,
      0,
      0.658722,
      0,
      0,
      0,
      1.778228,
      1.276646,
      0,
      0,
      1,
      1.411875,
      NULL,
      NULL,
      0.504502,
      10.148264,
      7.760162,
      6,
      NULL,
      4.139887,
      1.386943,
      3.878929,
      2.486457,
      1,
      0,
      1.552179,
      NULL,
      34,
      2.534032,
      2,
      NULL,
      34,
      30.625940,
      43.450220,
      1,
      1,
      NULL,
      '33414',
      NULL,
      NULL,
      1,
      '31142',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.429857,
      NULL,
      0,
      NULL,
      NULL,
      0.160903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.348884,
      NULL,
      NULL,
      1,
      NULL,
      0,
      224.924192,
      6,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1,
      1.126493,
      3,
      0.998602,
      0,
      NULL,
      NULL,
      0.686437,
      1.860318,
      NULL,
      3.979414,
      0,
      0,
      1,
      NULL,
      0,
      1.350120,
      NULL,
      3.800806,
      1,
      3,
      0,
      82,
      1.595373,
      1,
      NULL,
      16,
      0,
      1,
      NULL,
      NULL,
      0.332495,
      NULL,
      0.560568,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.300351,
      NULL,
      0.150940,
      NULL,
      0.235718,
      NULL,
      1.326449,
      NULL,
      0.602547,
      NULL,
      1.443953,
      NULL,
      1.495662,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.278770,
      1.364865,
      2.306331,
      NULL,
      NULL,
      7.997919,
      2,
      1.313868,
      NULL,
      0.319383,
      0,
      NULL,
      0.761846,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3.494858,
      2,
      NULL,
      1,
      2.161189,
      NULL,
      1,
      0.797697,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1.102662,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.160073,
      1,
      NULL,
      3.060582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2.709463,
      NULL,
      3.204667,
      NULL,
      1.888269,
      NULL,
      1.937166,
      NULL,
      1.949067,
      NULL,
      2.914634,
      NULL,
      0,
      NULL,
      32,
      NULL,
      NULL,
      0.432804,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      8.292018,
      3.703221,
      0,
      1.694539,
      NULL,
      NULL,
      2.570636,
      0,
      0.092223,
      '21110',
      '13342',
      '23412',
      NULL,
      '33213',
      '',
      '',
      1.611886,
      '',
      '',
      '');
commit;
end;
/


