set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7004058';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      NULL,
      '2214222',
      3.467559,
      0.331623,
      NULL,
      0,
      '2430',
      1.533148,
      NULL,
      NULL,
      NULL,
      ' 8- 4-1980',
      59.430004,
      NULL,
      1,
      NULL,
      NULL,
      ' 1-22-1974',
      NULL,
      0.247873,
      358,
      98.586409,
      0.947352,
      ' 3-20-1980',
      '10-17-2003',
      '11- 4-1975',
      1.728192,
      1,
      0,
      1.930457,
      0.375888,
      0,
      0.183759,
      0.258004,
      0,
      477.638692,
      0.449985,
      10.216320,
      7,
      NULL,
      114,
      1.367512,
      18,
      NULL,
      0.421476,
      2.922215,
      0.713371,
      1,
      NULL,
      NULL,
      NULL,
      0.832299,
      1,
      1.532881,
      1.001097,
      0,
      119,
      13,
      8.548979,
      NULL,
      NULL,
      1,
      NULL,
      4,
      4.536588,
      5.734729,
      0,
      9,
      NULL,
      NULL,
      0.427336,
      0.262270,
      1.747788,
      4,
      0,
      NULL,
      4,
      0,
      0.734402,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      0.201689,
      6,
      2.611616,
      1.826691,
      0.940379,
      3.616546,
      NULL,
      0,
      1.523039,
      NULL,
      2,
      1.238718,
      1.788846,
      NULL,
      NULL,
      3.885913,
      0,
      3.336818,
      NULL,
      NULL,
      NULL,
      0.446241,
      1.101664,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.676659,
      NULL,
      NULL,
      1,
      7,
      NULL,
      0,
      4,
      1.814014,
      2,
      1.265930,
      NULL,
      2,
      NULL,
      1.285264,
      NULL,
      6,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.297756,
      0,
      1,
      5.930914,
      4.180626,
      NULL,
      1.460838,
      1.731031,
      NULL,
      5,
      2.232182,
      2,
      5,
      7,
      6.920210,
      4.641340,
      0.403192,
      NULL,
      9,
      4,
      10.793569,
      2,
      0,
      1,
      7,
      3.903007,
      ' 2-21-2002',
      1641,
      ' 6-28-2000',
      NULL,
      3.269003,
      1.651402,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666933,
      0.868515,
      NULL,
      7,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448113,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.028061,
      1.224880,
      0,
      0,
      2,
      NULL,
      1.483796,
      7.780721,
      NULL,
      7.809135,
      2,
      3,
      6.687861,
      0,
      NULL,
      NULL,
      NULL,
      2.760890,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.185276,
      0.067755,
      NULL,
      1.509825,
      2,
      0.140858,
      2,
      7824.828720,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.942705,
      0,
      2.836743,
      0,
      2.766078,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.419875,
      1.184979,
      2.003562,
      NULL,
      NULL,
      1,
      1.030797,
      0.060305,
      1.911784,
      NULL,
      1,
      0.920472,
      NULL,
      NULL,
      0.990342,
      0.739201,
      1.543785,
      1.116296,
      0,
      1.979536,
      1.904858,
      11.911253,
      4.429696,
      2,
      1,
      NULL,
      NULL,
      3.534103,
      NULL,
      NULL,
      0.972921,
      2,
      20,
      NULL,
      0.372914,
      NULL,
      20,
      1,
      57.012633,
      NULL,
      1.852404,
      2.385386,
      '00134',
      '',
      '',
      0.136565,
      '',
      '',
      '',
      1.096111,
      NULL,
      '',
      '',
      3,
      25.563892,
      NULL,
      14.339478,
      1,
      NULL,
      NULL,
      1,
      7,
      1.852087,
      3,
      1,
      1.076289,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.063578,
      1,
      1,
      1,
      0,
      3,
      NULL,
      1,
      0,
      0.944178,
      3.307341,
      2,
      1.600817,
      NULL,
      NULL,
      NULL,
      1.990383,
      0.893783,
      NULL,
      NULL,
      NULL,
      3,
      1.502051,
      1,
      0.664541,
      1.159676,
      1,
      7.387516,
      1,
      0.051113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.308244,
      NULL,
      NULL,
      NULL,
      3,
      1.607647,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.924065,
      2,
      1,
      0,
      2,
      1,
      1,
      0.046803,
      1.359697,
      0.335753,
      0,
      0.466106,
      1,
      NULL,
      1,
      1.478084,
      0.412984,
      1,
      NULL,
      NULL,
      2.837617,
      0.503068,
      NULL,
      9.428860,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0.667369,
      NULL,
      1.218856,
      2.292503,
      0.417124,
      NULL,
      NULL,
      4,
      1,
      2,
      3.642255,
      NULL,
      NULL,
      1,
      1.685492,
      1,
      2,
      0,
      NULL,
      1.065840,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.928298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.153048,
      NULL,
      NULL,
      0.020271,
      NULL,
      NULL,
      NULL,
      1.276649,
      1.748294,
      NULL,
      0.093401,
      NULL,
      6,
      1,
      6.922734,
      2,
      6,
      NULL,
      NULL,
      0,
      6,
      3.729479,
      0,
      0,
      2,
      NULL,
      3.459545,
      3,
      1.357642,
      0.688912,
      2,
      NULL,
      NULL,
      0.362135,
      NULL,
      2,
      2.035833,
      1.455507,
      1.112359,
      1.309787,
      0,
      NULL,
      0,
      2,
      2,
      4,
      NULL,
      0.941681,
      2,
      NULL,
      2.692756,
      3.603199,
      NULL,
      9,
      1,
      0,
      0.306568,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243751,
      NULL,
      NULL,
      1.925205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.873540,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.814949,
      NULL,
      NULL,
      0,
      3.025841,
      0,
      NULL,
      NULL,
      0,
      1.842161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.685638,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.883060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016325,
      NULL,
      NULL,
      NULL,
      1.698933,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.032663,
      NULL,
      NULL,
      NULL,
      0.049306,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      9,
      9.645687,
      2.703112,
      3.782216,
      148.850636,
      404.382483,
      1.516335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1044.078149,
      1.453265,
      NULL,
      NULL,
      2,
      705,
      551,
      0,
      20,
      NULL,
      225,
      51.159140,
      NULL,
      0.094641,
      NULL,
      NULL,
      0.385240,
      NULL,
      0.446289,
      NULL,
      1.985361,
      0,
      1,
      1,
      1,
      0,
      1.761639,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.009930,
      2,
      2,
      7,
      0,
      1,
      NULL,
      NULL,
      9,
      3,
      0.180150,
      0,
      0,
      1.399139,
      NULL,
      0.293749,
      0,
      NULL,
      0.425512,
      NULL,
      NULL,
      0.378549,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.615270,
      1,
      NULL,
      0.569105,
      1.337311,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589432,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988603,
      NULL,
      1,
      NULL,
      1.047936,
      NULL,
      1.688435,
      11.283099,
      10.399481,
      0.898332,
      0.409776,
      1,
      28.270635,
      68.266300,
      1.978392,
      NULL,
      NULL,
      '20200',
      '',
      '',
      0.991840,
      '',
      '',
      '',
      NULL,
      '1100',
      NULL,
      '');
commit;
end;
/


