set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8421847';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '3343243',
      2,
      1,
      1,
      2,
      '4441',
      NULL,
      1.687593,
      NULL,
      NULL,
      ' 5- 2-1978',
      38,
      NULL,
      4,
      2,
      0,
      NULL,
      5.997000,
      0,
      193,
      49,
      1.267292,
      ' 5-27-1977',
      ' 8-19-1983',
      ' 9-20-2002',
      NULL,
      NULL,
      2.397800,
      1.614497,
      1,
      2,
      1.258112,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      NULL,
      5,
      0,
      28,
      NULL,
      NULL,
      5.197594,
      0.793013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      NULL,
      6.694564,
      0.789645,
      4.880078,
      5,
      0.112959,
      1,
      NULL,
      1,
      0,
      0,
      6.381495,
      1.577597,
      0,
      0,
      1.807606,
      1,
      NULL,
      NULL,
      2.937228,
      4,
      0,
      NULL,
      5,
      2,
      3.206836,
      0,
      1.881504,
      1.931402,
      1.213754,
      0,
      3.233521,
      3.963587,
      NULL,
      1,
      0.310009,
      1,
      0.729531,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      7.187212,
      1,
      1,
      NULL,
      1.229967,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.913861,
      0.980034,
      1,
      NULL,
      7,
      6.576401,
      NULL,
      0,
      5.302429,
      1,
      1,
      1,
      NULL,
      0,
      1.443439,
      1.117536,
      1.630913,
      NULL,
      NULL,
      1.939328,
      0.090531,
      3.276965,
      0,
      2,
      0,
      3,
      0.744970,
      0,
      1.476910,
      1.111894,
      1,
      2.348138,
      1.823528,
      0.611581,
      0.843234,
      0.046045,
      NULL,
      7.398130,
      7,
      1.163997,
      NULL,
      NULL,
      0.921724,
      2,
      4.280687,
      1.416732,
      3,
      ' 5-17-1999',
      NULL,
      NULL,
      3.661630,
      0.727929,
      1,
      1.114401,
      3.626138,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033917,
      0.298238,
      0.188568,
      1,
      0,
      1.620158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.258330,
      NULL,
      7,
      0.298148,
      1,
      0.673667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      3.051561,
      3,
      4.139724,
      9.525016,
      0.895896,
      NULL,
      NULL,
      0,
      6,
      NULL,
      1,
      1.477734,
      0.273691,
      6,
      ' 6-16-2001',
      1,
      ' 8-22-1993',
      8,
      1.089473,
      0,
      1,
      NULL,
      1.633861,
      1.312092,
      NULL,
      1,
      0.988771,
      0,
      NULL,
      51.701919,
      NULL,
      0.082716,
      NULL,
      NULL,
      NULL,
      1.767643,
      0,
      0.165808,
      NULL,
      2.792327,
      NULL,
      0,
      1.304098,
      3.445473,
      3,
      0.710287,
      3.663984,
      NULL,
      0,
      2,
      0.720695,
      NULL,
      1,
      0.318396,
      0,
      0.718481,
      NULL,
      NULL,
      1,
      1,
      1.704909,
      1.861619,
      1,
      0,
      0.368872,
      0,
      0.491106,
      10.342913,
      NULL,
      4.716531,
      6,
      NULL,
      5,
      4.837327,
      3,
      4.398564,
      1,
      2.788465,
      NULL,
      2,
      NULL,
      2,
      NULL,
      57,
      4,
      94,
      1,
      1,
      2,
      '24131',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.830560,
      28.956885,
      33,
      NULL,
      1.931433,
      11.503222,
      14,
      11.575815,
      5.601129,
      NULL,
      1,
      1.360287,
      1,
      NULL,
      NULL,
      0,
      1.822129,
      0,
      3,
      1,
      1,
      3.038645,
      1.219648,
      1,
      0,
      1.598584,
      1,
      NULL,
      1.888102,
      1,
      0.583527,
      NULL,
      NULL,
      2.259704,
      1,
      0.066045,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0.680186,
      4.537106,
      1.122766,
      2,
      NULL,
      0.618819,
      0,
      3.601736,
      2,
      0.909508,
      0.206399,
      3,
      NULL,
      3.108814,
      2,
      0.306664,
      1.380550,
      0,
      1,
      1.623462,
      2.051864,
      2.315831,
      0.501267,
      NULL,
      2,
      3,
      0,
      2.969293,
      NULL,
      NULL,
      3,
      0.005176,
      3,
      3,
      NULL,
      0.967307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108206,
      NULL,
      NULL,
      9.350705,
      1,
      NULL,
      1,
      3.137664,
      NULL,
      2.218245,
      0,
      1.195723,
      1,
      NULL,
      2.894685,
      0.222812,
      NULL,
      NULL,
      2,
      0.877151,
      1,
      1,
      NULL,
      NULL,
      0.456988,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2,
      0,
      1.406677,
      NULL,
      NULL,
      0,
      5,
      0,
      1.781856,
      1.900877,
      NULL,
      NULL,
      1.807235,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337923,
      NULL,
      NULL,
      2.767061,
      0,
      0,
      NULL,
      0.549821,
      NULL,
      4.737364,
      1.900105,
      NULL,
      3.286881,
      1,
      1.926349,
      5.389149,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.674274,
      1,
      2,
      1,
      NULL,
      0.363584,
      4.587179,
      6.157212,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      0.642903,
      2.180971,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304200,
      NULL,
      1,
      3,
      NULL,
      NULL,
      3.090606,
      NULL,
      0.232063,
      1,
      3,
      2,
      3.149201,
      1,
      0,
      17,
      20.937607,
      NULL,
      NULL,
      3,
      NULL,
      0.764247,
      0,
      NULL,
      0,
      0.681281,
      NULL,
      0.509475,
      1.438159,
      NULL,
      2.864785,
      NULL,
      NULL,
      2.947866,
      1.674558,
      0.853882,
      0,
      3.077895,
      3,
      2,
      2.646954,
      0,
      1.199828,
      3,
      0,
      3.772630,
      3,
      0.037814,
      3,
      0.019260,
      3,
      11,
      13.444640,
      5.303477,
      2.553186,
      NULL,
      2.798814,
      3.935988,
      3,
      2,
      0,
      0,
      3,
      9.768256,
      5.993519,
      2.450386,
      3.387323,
      3,
      16,
      NULL,
      NULL,
      2,
      3,
      3.021204,
      NULL,
      NULL,
      1.523998,
      1.949196,
      NULL,
      0.644343,
      NULL,
      NULL,
      NULL,
      1,
      0.747154,
      NULL,
      NULL,
      0.265196,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.728238,
      3.977316,
      0,
      1,
      NULL,
      1,
      1.932477,
      3,
      NULL,
      1.693176,
      3.604591,
      3.221396,
      1.905334,
      3,
      0.136670,
      0,
      0,
      1,
      1.152670,
      NULL,
      0,
      0.102802,
      NULL,
      0.956531,
      NULL,
      2,
      2,
      2.352396,
      3,
      2.405336,
      NULL,
      0,
      0,
      3.094045,
      NULL,
      NULL,
      NULL,
      0,
      2.488283,
      3,
      0,
      1.968104,
      3.554750,
      0,
      0.566593,
      0.113755,
      12.814664,
      1.407081,
      6.051372,
      9,
      NULL,
      15.034512,
      2,
      8.667945,
      7,
      8.698553,
      NULL,
      135.883805,
      3.309356,
      2.281803,
      1.665171,
      NULL,
      2.539612,
      17.544292,
      3.073092,
      NULL,
      NULL,
      NULL,
      2,
      200.772809,
      40,
      NULL,
      NULL,
      NULL,
      1,
      1.374837,
      1,
      NULL,
      1,
      NULL,
      0.096398,
      1.515524,
      1.825064,
      NULL,
      0,
      0.811697,
      NULL,
      0,
      1.558793,
      0,
      1.918119,
      1.906575,
      1.213477,
      0.663019,
      0.707558,
      0,
      0.781353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.045034,
      3,
      0,
      1.184921,
      3,
      0.084619,
      1,
      NULL,
      2.596495,
      1.629606,
      NULL,
      NULL,
      0.586705,
      NULL,
      0.742291,
      NULL,
      0,
      0,
      0,
      1,
      3.289783,
      1,
      0.383074,
      1,
      0.042265,
      NULL,
      NULL,
      1,
      0.431404,
      1.662689,
      NULL,
      0.379532,
      1,
      0,
      0,
      0,
      0,
      1.639773,
      1.158465,
      1.632210,
      1,
      3.541397,
      1,
      0.551955,
      1,
      2.859373,
      0.699189,
      1.311109,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.555834,
      3,
      NULL,
      2.645547,
      1.446876,
      NULL,
      2,
      0,
      1,
      1,
      0.930635,
      2.951159,
      2.908015,
      3,
      2.098995,
      2.002000,
      1,
      1.585555,
      NULL,
      2,
      1,
      0,
      3,
      3,
      0,
      1.788741,
      1,
      19,
      0,
      NULL,
      0,
      1,
      1.026318,
      2.816236,
      0,
      1,
      7.820408,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      68.163306,
      29.830983,
      NULL,
      1.565668,
      4.197139,
      '13312',
      '34420',
      NULL,
      0,
      NULL,
      '',
      '',
      5.488601,
      '21002',
      NULL,
      '');
commit;
end;
/


