set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7719348';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '1213344',
      3.084021,
      0.229268,
      3,
      1,
      '2001',
      0.675786,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115412,
      NULL,
      1.973248,
      NULL,
      32.208313,
      0.935983,
      NULL,
      NULL,
      NULL,
      ' 5-22-1987',
      NULL,
      NULL,
      2,
      0.664072,
      0.549893,
      1,
      1.613373,
      2,
      0,
      NULL,
      NULL,
      NULL,
      9,
      9,
      0.468837,
      14.747482,
      19,
      4,
      NULL,
      5.704892,
      4.306193,
      1,
      0,
      1,
      NULL,
      0.867740,
      0.573661,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      15,
      4.387510,
      1,
      2.162264,
      NULL,
      1.420947,
      4.121430,
      1,
      2,
      4.751571,
      NULL,
      0,
      5.765572,
      0,
      1,
      1.281887,
      NULL,
      1.660980,
      2.894660,
      4.518919,
      1.932859,
      0.899407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772774,
      7,
      1,
      1,
      1,
      2,
      2,
      NULL,
      NULL,
      0.397749,
      3.121429,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1.773068,
      1.484110,
      7.594070,
      0.259107,
      0,
      NULL,
      1.694562,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.716062,
      6.384174,
      2.044989,
      3.805284,
      9.144863,
      0,
      8.338014,
      1,
      0.189652,
      3,
      0.361999,
      0,
      1.010352,
      2.474516,
      1.420355,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.507655,
      5,
      1,
      3.917855,
      7.019996,
      3.932679,
      NULL,
      3,
      1,
      2.722493,
      4,
      5.427562,
      5,
      1.375882,
      NULL,
      NULL,
      0.500379,
      1.791294,
      2,
      4,
      8.288700,
      NULL,
      NULL,
      NULL,
      3.398029,
      NULL,
      NULL,
      2.144971,
      NULL,
      290,
      '10-16-1978',
      1025.004213,
      2,
      0.580510,
      2,
      7.158041,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198046,
      0.692077,
      0,
      1,
      1,
      1,
      1,
      1.764379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.241307,
      8.039135,
      0,
      0.102715,
      0.192328,
      4,
      1.823358,
      NULL,
      NULL,
      1.701689,
      0.070291,
      0.614401,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.389121,
      NULL,
      1.629972,
      0.916986,
      NULL,
      1.924551,
      0,
      0,
      NULL,
      0.913078,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.735140,
      1,
      0.131749,
      0.972781,
      0,
      2.810544,
      0.842784,
      3.300987,
      2.192982,
      0.190164,
      1.347166,
      3.324906,
      1.334605,
      NULL,
      1,
      0,
      1.582951,
      0,
      NULL,
      1.929094,
      1.610158,
      0,
      0.245488,
      1,
      0,
      0,
      0.785901,
      1,
      3.083545,
      NULL,
      0,
      NULL,
      6,
      2.745633,
      0,
      10,
      1,
      0,
      NULL,
      4,
      NULL,
      NULL,
      3,
      31.233538,
      1.921715,
      3,
      NULL,
      1.879242,
      18.726196,
      56,
      4,
      0.021605,
      NULL,
      '41311',
      '22424',
      '',
      1.853272,
      '',
      '',
      '',
      4,
      '3130',
      '2343',
      '44342',
      2.092900,
      7.975312,
      NULL,
      17,
      1.983806,
      6.907502,
      NULL,
      53,
      11,
      0.391988,
      0.775236,
      0.992600,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232596,
      1.494066,
      3,
      NULL,
      NULL,
      3,
      0,
      2.633537,
      3,
      0,
      2.010402,
      2,
      3,
      1.535104,
      1.045508,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      0.322863,
      0.325620,
      1.206212,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9.715393,
      0,
      9,
      0.804519,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543568,
      NULL,
      NULL,
      NULL,
      1.526362,
      0.442770,
      1,
      0,
      NULL,
      NULL,
      0.067582,
      NULL,
      NULL,
      2,
      2,
      3.053499,
      3.297432,
      3,
      3,
      3,
      3.184934,
      1,
      NULL,
      3,
      1.709044,
      3,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.356830,
      1,
      2,
      0,
      1.635889,
      NULL,
      NULL,
      NULL,
      0.455460,
      NULL,
      NULL,
      NULL,
      0.467542,
      NULL,
      NULL,
      NULL,
      0.285992,
      NULL,
      1.990582,
      3,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1.580548,
      2.103347,
      0.519771,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      0.700535,
      NULL,
      NULL,
      0.876683,
      NULL,
      NULL,
      0.102868,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976966,
      NULL,
      NULL,
      3.235487,
      0,
      NULL,
      NULL,
      1,
      3.015254,
      3.830014,
      6.424375,
      1,
      NULL,
      1.974261,
      NULL,
      5.579659,
      NULL,
      1,
      0.240686,
      NULL,
      NULL,
      3.055699,
      NULL,
      NULL,
      2,
      1.706140,
      NULL,
      8,
      3,
      5,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2.050074,
      0,
      3,
      2.671965,
      2.836736,
      2.613748,
      2,
      1.835721,
      2.929650,
      9.732618,
      9.932179,
      0,
      7.431164,
      1,
      2,
      3,
      0.337894,
      1.378241,
      NULL,
      0.161211,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565158,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142673,
      NULL,
      NULL,
      0.425963,
      NULL,
      NULL,
      1.107138,
      NULL,
      NULL,
      0.524558,
      NULL,
      NULL,
      1,
      0.188790,
      0,
      1,
      0.147258,
      3,
      0,
      NULL,
      NULL,
      0.591355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.514520,
      NULL,
      NULL,
      NULL,
      1.118874,
      NULL,
      NULL,
      NULL,
      3.556635,
      NULL,
      NULL,
      NULL,
      1.951857,
      NULL,
      NULL,
      NULL,
      6.055998,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      196.376253,
      57.404358,
      1,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.903672,
      NULL,
      0.198358,
      NULL,
      15.859142,
      3.738863,
      48.648336,
      NULL,
      NULL,
      NULL,
      1,
      28,
      4.768385,
      1.628571,
      NULL,
      1.731994,
      1,
      0.613977,
      1,
      0,
      1.519505,
      0.550019,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.304063,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133711,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.135010,
      1.304672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.538215,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.463239,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.023010,
      0.023400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      245.829563,
      NULL,
      0.059122,
      NULL,
      0.197767,
      NULL,
      NULL,
      1.790155,
      NULL,
      NULL,
      33,
      1.710295,
      NULL,
      NULL,
      NULL,
      1.872543,
      3,
      3.200231,
      8,
      0,
      6,
      NULL,
      NULL,
      NULL,
      3.381504,
      0,
      0.061945,
      NULL,
      NULL,
      NULL,
      0.107044,
      2,
      NULL,
      2,
      NULL,
      NULL,
      0.686602,
      NULL,
      NULL,
      1.841935,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.868322,
      NULL,
      NULL,
      0,
      NULL,
      0.226975,
      1.433293,
      NULL,
      3.238991,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.393790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.332453,
      NULL,
      0,
      NULL,
      NULL,
      2.920614,
      6,
      3.138030,
      0,
      3,
      10,
      29.905884,
      1.326975,
      1,
      1,
      '24434',
      '40112',
      '41110',
      0,
      '',
      '',
      '',
      6,
      '3433',
      '2421',
      '14041');
commit;
end;
/


