set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6100037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1243143',
      1.895208,
      1,
      NULL,
      2,
      NULL,
      2.317693,
      1.547484,
      NULL,
      NULL,
      ' 6-18-1992',
      11,
      NULL,
      5.689468,
      0,
      NULL,
      ' 9- 2-2003',
      35.240114,
      2.083865,
      255,
      NULL,
      1,
      ' 2-13-1994',
      ' 6-23-1985',
      NULL,
      2.863789,
      2,
      0.201085,
      1,
      0.038117,
      2,
      3,
      NULL,
      0,
      78,
      5,
      12.378960,
      7,
      21,
      8,
      5.075571,
      7,
      NULL,
      NULL,
      NULL,
      0.429365,
      0,
      2.016302,
      1.217201,
      0,
      1.234368,
      NULL,
      1,
      0.925099,
      NULL,
      1,
      3.948458,
      2.121078,
      1,
      3.554145,
      7,
      0.242941,
      0.483355,
      1,
      1,
      0.263147,
      1,
      0,
      1.736221,
      1.649762,
      0,
      NULL,
      2,
      1,
      0.873494,
      1.826733,
      0.366684,
      1.997345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.639808,
      1.926075,
      0.095378,
      1.858553,
      1,
      1,
      NULL,
      0,
      3,
      1.108518,
      3.676457,
      1,
      1,
      0,
      3,
      0,
      1,
      0.910280,
      1,
      0.320016,
      NULL,
      0.809644,
      3.136076,
      1.287194,
      1.397218,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.912845,
      NULL,
      1,
      4.596698,
      6,
      1,
      1,
      7.606321,
      0.443150,
      1,
      0.003663,
      7.181573,
      1.128202,
      0.595487,
      0.490322,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.424343,
      3,
      NULL,
      NULL,
      0,
      0.931432,
      0,
      5,
      1,
      0.345278,
      4.245588,
      NULL,
      NULL,
      2.636526,
      NULL,
      NULL,
      1,
      2.341532,
      NULL,
      1,
      2.123928,
      5,
      1,
      6.162745,
      2.367747,
      ' 7- 9-1993',
      0,
      ' 6- 9-1982',
      3.802899,
      1.479577,
      3.901259,
      1.037842,
      6,
      1.040286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.177979,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.471418,
      0,
      NULL,
      2,
      NULL,
      2.849260,
      2.757977,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.142916,
      1.695284,
      1,
      0,
      1.708079,
      1.998707,
      0.197922,
      3.281985,
      68.709621,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      3,
      1,
      1.449418,
      0,
      1.852555,
      0,
      1,
      3,
      2.020878,
      0.990695,
      0.349794,
      0,
      3.491744,
      0.765795,
      0.554196,
      0,
      0.283238,
      1.126394,
      1,
      NULL,
      0.116290,
      0,
      1.916673,
      0.143100,
      2.193395,
      0.596458,
      0.828304,
      9.416232,
      3,
      6.600616,
      NULL,
      4,
      1.114035,
      NULL,
      3,
      3.196852,
      3.060618,
      2.805820,
      3,
      NULL,
      NULL,
      3.287752,
      NULL,
      17.601514,
      10.829648,
      NULL,
      0.484601,
      1,
      0,
      '44102',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      2.030384,
      38,
      246,
      44.404132,
      3,
      21.183171,
      11,
      2,
      NULL,
      3.869543,
      2.699854,
      NULL,
      0.568168,
      NULL,
      NULL,
      0.440125,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.509566,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625482,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620698,
      NULL,
      NULL,
      3.022322,
      3.260107,
      0,
      0.531732,
      0.725514,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.588459,
      0.565514,
      1.335272,
      0.873147,
      NULL,
      NULL,
      0.161951,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.404476,
      NULL,
      0,
      0,
      2.567816,
      1,
      1,
      NULL,
      NULL,
      3,
      3.197409,
      0.821283,
      0.425929,
      0,
      NULL,
      NULL,
      0.177379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0,
      0.292318,
      NULL,
      NULL,
      NULL,
      1.979300,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.566679,
      NULL,
      2.792459,
      NULL,
      1.262482,
      1,
      NULL,
      NULL,
      2,
      2,
      3,
      2.345324,
      NULL,
      NULL,
      0.154363,
      NULL,
      NULL,
      NULL,
      1.064547,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676206,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.927628,
      NULL,
      NULL,
      3.774848,
      0.928296,
      1,
      1.004688,
      NULL,
      NULL,
      3,
      0.738033,
      1,
      5,
      0,
      0,
      4,
      NULL,
      0.098710,
      0,
      NULL,
      NULL,
      0.510332,
      2,
      1.781257,
      0,
      NULL,
      NULL,
      3,
      4,
      NULL,
      0,
      3.768426,
      0.998624,
      0.130203,
      3.068125,
      NULL,
      1,
      3,
      1.609754,
      1.575463,
      2,
      NULL,
      6,
      NULL,
      2.801534,
      3,
      1,
      NULL,
      NULL,
      1,
      1.782524,
      0.790012,
      1,
      1,
      NULL,
      0.106774,
      1.899017,
      NULL,
      NULL,
      1.619316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.386676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.660036,
      NULL,
      NULL,
      1.656881,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.320584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.592154,
      0.111962,
      NULL,
      0.653392,
      0.874295,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      NULL,
      2.039080,
      2,
      NULL,
      NULL,
      0.708480,
      0,
      NULL,
      NULL,
      1.278041,
      1.733313,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260916,
      1.768462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998779,
      NULL,
      NULL,
      1.037089,
      1.869642,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.465000,
      0.089256,
      NULL,
      NULL,
      1.100520,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.658646,
      NULL,
      NULL,
      NULL,
      2.768226,
      0.410069,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      52,
      6.227825,
      0.777465,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.055302,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.883274,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      27.905329,
      7,
      0,
      0,
      NULL,
      1,
      0.106085,
      1.828492,
      1.551000,
      1.166328,
      1.730603,
      0,
      0,
      1,
      0,
      0.290441,
      0,
      NULL,
      0,
      1.877740,
      NULL,
      1,
      NULL,
      1.999769,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.110754,
      2.961118,
      NULL,
      1,
      0.558063,
      NULL,
      NULL,
      0.681607,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.044536,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.144664,
      NULL,
      0.558785,
      NULL,
      0.261266,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611713,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.792122,
      2.568020,
      NULL,
      3.516043,
      NULL,
      1.830852,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.225055,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.194197,
      NULL,
      1.961516,
      NULL,
      NULL,
      NULL,
      2.400154,
      NULL,
      1.337086,
      NULL,
      0.145697,
      NULL,
      1.858800,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265121,
      1.096580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0.213572,
      NULL,
      0.704443,
      NULL,
      NULL,
      NULL,
      2.128033,
      NULL,
      0,
      NULL,
      1.025868,
      1.806410,
      1.791193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244234,
      0.597686,
      0.989278,
      5,
      3.793984,
      2.367034,
      3.014277,
      NULL,
      2,
      0,
      0.817547,
      0.552278,
      0.993803,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.065398,
      1.596703,
      NULL,
      0.562131,
      0,
      1.503554,
      0,
      1.650033,
      1.125911,
      1,
      NULL,
      1,
      1.071438,
      1,
      1.248386,
      NULL,
      0,
      1.519851,
      1.131813,
      0,
      1.243790,
      0,
      3,
      1.548927,
      1,
      0.498571,
      1.933690,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980024,
      NULL,
      1.574080,
      0.666241,
      0,
      NULL,
      NULL,
      NULL,
      10,
      3.164342,
      NULL,
      3.043077,
      34.630087,
      NULL,
      NULL,
      4.929074,
      3,
      '22044',
      '33432',
      '',
      0,
      '',
      '',
      '',
      0.132410,
      '',
      NULL,
      NULL);
commit;
end;
/


