set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8825603';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '2430130',
      1.484541,
      0.303110,
      NULL,
      NULL,
      '4440',
      3.081517,
      NULL,
      NULL,
      NULL,
      ' 4-23-1979',
      44.245039,
      NULL,
      0,
      3.225018,
      0,
      '10- 6-2000',
      45.673313,
      3.995698,
      2,
      NULL,
      1,
      ' 4-26-2001',
      NULL,
      '11-16-1985',
      1.372442,
      2.513266,
      3.837637,
      0,
      NULL,
      0.551215,
      2.360717,
      1.623111,
      0,
      41,
      NULL,
      1.582234,
      1,
      14.579859,
      2.565503,
      7.429982,
      17,
      2,
      1,
      9,
      2.068112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904440,
      4.669848,
      7,
      3,
      4.926884,
      4.173161,
      0,
      0.044158,
      0,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      3.944769,
      1.486038,
      0.063317,
      0,
      NULL,
      1.505622,
      NULL,
      NULL,
      0,
      3,
      2,
      5,
      1.992024,
      1,
      3.895183,
      0,
      1.592490,
      0,
      NULL,
      1.373563,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.955795,
      1,
      1,
      1.385591,
      0,
      3.493399,
      0,
      NULL,
      0.879579,
      1,
      1.498206,
      1,
      1.746639,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1.160822,
      1,
      0,
      NULL,
      0,
      0.196675,
      0.605873,
      1,
      NULL,
      0,
      0.184039,
      1,
      1.496291,
      1.524912,
      1,
      0.168233,
      1,
      1,
      NULL,
      1,
      4,
      2,
      0.141195,
      3.541370,
      NULL,
      8.413972,
      0,
      0,
      1.078923,
      5.755941,
      NULL,
      NULL,
      1,
      1,
      2,
      7,
      0.917911,
      8.474824,
      6,
      8.613468,
      NULL,
      10.486956,
      9.660300,
      5,
      5.736815,
      6.107303,
      0.969828,
      ' 8-16-2003',
      NULL,
      ' 0- 1-1990',
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.526986,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      16,
      1,
      0.601022,
      3.746654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920961,
      0,
      2.454459,
      3,
      3.761497,
      1,
      7.617563,
      1.426058,
      4,
      4,
      3,
      6.110333,
      NULL,
      1.355447,
      NULL,
      NULL,
      3.869187,
      12,
      0,
      0.396598,
      NULL,
      NULL,
      8,
      ' 6-12-1997',
      1459.728904,
      ' 6- 4-1982',
      5.427359,
      1,
      NULL,
      0.739621,
      2,
      1.850095,
      0.607588,
      NULL,
      1.641842,
      NULL,
      0.730317,
      1,
      22.064110,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10,
      7,
      7.288051,
      2.126497,
      3.968195,
      5.879042,
      1,
      1.094724,
      NULL,
      3,
      NULL,
      1,
      15.007283,
      2,
      3,
      NULL,
      60.386106,
      18.512655,
      NULL,
      NULL,
      0.953202,
      NULL,
      '21020',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      3,
      NULL,
      371.732909,
      9,
      2,
      17.591926,
      25,
      24.200226,
      3,
      NULL,
      1.203817,
      0,
      3.604053,
      3,
      0.391846,
      NULL,
      8,
      0,
      1,
      2.166824,
      NULL,
      1.111934,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.985556,
      1,
      1.304880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.844780,
      NULL,
      NULL,
      11.574313,
      10,
      NULL,
      0,
      0.778336,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.518216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.930481,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.704680,
      0.485725,
      NULL,
      2.747299,
      0,
      0,
      1.880887,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.062380,
      5.051744,
      0.798009,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.948820,
      NULL,
      NULL,
      1.820675,
      NULL,
      NULL,
      2.858431,
      1.426202,
      0.681195,
      0,
      NULL,
      NULL,
      NULL,
      1.992490,
      1.359386,
      0.673353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.098057,
      NULL,
      NULL,
      0.195092,
      NULL,
      NULL,
      0.131653,
      NULL,
      NULL,
      1.678869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860631,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.317821,
      3,
      0,
      NULL,
      NULL,
      8.630595,
      4.084200,
      7,
      3,
      0,
      1,
      5.114627,
      1.949110,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.876642,
      1,
      1.071253,
      3.479092,
      5,
      5.678353,
      0,
      NULL,
      NULL,
      2,
      3,
      1,
      NULL,
      0.548762,
      1.604449,
      1,
      1,
      1.753863,
      0.271508,
      8,
      1,
      6.743937,
      4.606515,
      5.992997,
      1,
      NULL,
      5,
      5.125016,
      0,
      1.228658,
      0.566009,
      0.718999,
      1.279542,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.802719,
      NULL,
      NULL,
      1.825495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.337385,
      3,
      0,
      1.193058,
      1,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      24,
      NULL,
      NULL,
      0.441236,
      1.846467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838263,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.449965,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.065261,
      NULL,
      NULL,
      NULL,
      3.579546,
      0,
      NULL,
      NULL,
      0.277406,
      NULL,
      NULL,
      NULL,
      3.442154,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.650251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.296907,
      NULL,
      NULL,
      NULL,
      1.368126,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      8.415607,
      NULL,
      NULL,
      2.138771,
      5,
      6,
      NULL,
      NULL,
      235.643243,
      NULL,
      0,
      NULL,
      1.192433,
      0,
      NULL,
      NULL,
      NULL,
      23.391709,
      5,
      3,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.429863,
      36,
      1.721679,
      NULL,
      269,
      0,
      0,
      0,
      0,
      0.663443,
      1.558168,
      1,
      0.698019,
      1,
      NULL,
      0.755233,
      0.332716,
      0.307474,
      1,
      NULL,
      1.174140,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      7.893729,
      3.613596,
      3.116526,
      NULL,
      6,
      4.283286,
      1,
      NULL,
      NULL,
      1.348360,
      NULL,
      1,
      0.957596,
      0.767748,
      1,
      1.865470,
      2,
      1,
      1.782846,
      0,
      1.844539,
      NULL,
      NULL,
      3,
      1.383605,
      NULL,
      NULL,
      0.001670,
      0.316232,
      2.062087,
      NULL,
      1.428510,
      1,
      NULL,
      2.433620,
      0.548368,
      1,
      0,
      1.747249,
      NULL,
      2,
      1.915089,
      0.775678,
      0.743013,
      1.922085,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667956,
      0,
      NULL,
      NULL,
      3.535932,
      NULL,
      2.399867,
      NULL,
      3,
      NULL,
      1.615306,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.385277,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      13,
      0,
      NULL,
      1,
      0,
      NULL,
      0.858928,
      1.775156,
      0.935622,
      NULL,
      NULL,
      9,
      0.951342,
      2,
      0.911109,
      NULL,
      56,
      1,
      1,
      3,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      0.513230,
      '',
      NULL,
      '');
commit;
end;
/


