set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753884';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-8-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.425254,
      NULL,
      NULL,
      1.501200,
      1,
      0.589958,
      5.279741,
      1,
      NULL,
      '03132301',
      18,
      1,
      '0111304',
      1,
      NULL,
      5,
      1,
      '3041',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      97.170155,
      NULL,
      3,
      NULL,
      ' 5- 4-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      3.441264,
      NULL,
      ' 2-18-1976',
      '11-25-2002',
      2.613029,
      2.318166,
      2,
      2.813365,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.029598,
      NULL,
      NULL,
      NULL,
      NULL,
      3.616972,
      0,
      NULL,
      1,
      1,
      NULL,
      1.777883,
      NULL,
      1.539298,
      0.966236,
      1,
      0,
      1.264608,
      NULL,
      NULL,
      0,
      3,
      0.133617,
      NULL,
      1,
      0.051627,
      NULL,
      0.241217,
      0,
      0.877456,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.201785,
      0,
      NULL,
      2.056530,
      1,
      0.144494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.609914,
      0.116567,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.582872,
      1.888172,
      0.828509,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.406054,
      1.448344,
      0,
      2.498726,
      4.824095,
      NULL,
      1,
      2,
      NULL,
      0.971801,
      1,
      0.208113,
      2,
      NULL,
      1.593915,
      0.379369,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      3,
      1.979089,
      2,
      2,
      0.075742,
      5.723240,
      3.109019,
      1.173216,
      0.378634,
      1.808426,
      4.949891,
      NULL,
      6,
      0.708480,
      1,
      2.139073,
      6.640134,
      5,
      NULL,
      1.091016,
      0,
      NULL,
      NULL,
      1,
      '11- 6-1978',
      71.017717,
      '11-19-2000',
      33,
      3,
      0,
      NULL,
      1.946819,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.268034,
      0.625728,
      NULL,
      0.432545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.256238,
      NULL,
      NULL,
      NULL,
      NULL,
      1.325138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.256005,
      NULL,
      2.554378,
      1.808192,
      NULL,
      2.136180,
      1.446835,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.312023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.183985,
      0,
      0.718692,
      0.795417,
      1.429205,
      1.718828,
      17.227059,
      1.730150,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      3.777883,
      0.742747,
      0.371190,
      2,
      3,
      3.187543,
      3,
      0.441715,
      3,
      3.390609,
      NULL,
      1.487192,
      1.507841,
      0,
      1.609417,
      NULL,
      NULL,
      0.644236,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.712523,
      1.924486,
      1,
      3.317720,
      0.578037,
      5,
      7,
      4.473345,
      0,
      1,
      3,
      1,
      NULL,
      7,
      2.216281,
      2,
      NULL,
      41.063110,
      2,
      2.536140,
      NULL,
      NULL,
      8.078304,
      NULL,
      5,
      3,
      2,
      '02012',
      '',
      '',
      1,
      '',
      '',
      '',
      1.637490,
      '',
      '',
      '',
      NULL,
      39.604535,
      NULL,
      39.825719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.141463,
      3.916314,
      0.484635,
      NULL,
      NULL,
      NULL,
      1.746924,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.892649,
      NULL,
      NULL,
      1.247637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.426665,
      0.169875,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.796326,
      NULL,
      2.154261,
      0.882002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.315793,
      4,
      1.632701,
      0.797155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.499253,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966285,
      NULL,
      NULL,
      0.322476,
      NULL,
      NULL,
      0.472396,
      NULL,
      NULL,
      NULL,
      2,
      0.716533,
      0.247468,
      NULL,
      NULL,
      0,
      4.740317,
      3,
      5.483129,
      2.726781,
      4.355959,
      2,
      NULL,
      5.615155,
      1.636773,
      NULL,
      NULL,
      3.003818,
      0,
      NULL,
      1.174810,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.815374,
      NULL,
      1.656893,
      2.291815,
      0,
      NULL,
      0,
      0.818985,
      NULL,
      2,
      0,
      0.399677,
      0.298171,
      NULL,
      4,
      3.460072,
      3,
      NULL,
      1.584243,
      3,
      7,
      NULL,
      NULL,
      1.324938,
      0.239930,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.968830,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.969338,
      1.727209,
      1,
      1.361290,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.710730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738334,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.220735,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1.328703,
      NULL,
      NULL,
      NULL,
      3.543926,
      1.705378,
      1,
      NULL,
      0.153345,
      1.751036,
      NULL,
      NULL,
      NULL,
      1.633767,
      NULL,
      NULL,
      0.463043,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.934716,
      NULL,
      1.708992,
      23.524115,
      5.470873,
      0,
      0,
      NULL,
      0,
      1.290384,
      1.455072,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.990903,
      0,
      0,
      0.693169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.485320,
      1,
      0.684874,
      0,
      1.515268,
      1.680247,
      1,
      1.607430,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.816066,
      NULL,
      0.207454,
      0,
      NULL,
      1.336278,
      2.391802,
      NULL,
      0.429503,
      0.784002,
      NULL,
      1.275697,
      1,
      NULL,
      NULL,
      1.938019,
      NULL,
      NULL,
      1.862205,
      NULL,
      1,
      1.503211,
      NULL,
      0.894455,
      0,
      0.585922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588690,
      NULL,
      1,
      NULL,
      0.383681,
      NULL,
      1,
      1,
      3.233394,
      1,
      NULL,
      NULL,
      25,
      54,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '',
      1.326950,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


