set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9630571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      '31',
      NULL,
      3.224708,
      '2431233',
      NULL,
      0,
      NULL,
      0,
      '3034',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-27-2002',
      35,
      6,
      NULL,
      1,
      0.867837,
      '10-25-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 4-14-1994',
      ' 7-27-1988',
      2.004297,
      1.730542,
      0,
      1,
      NULL,
      2.692955,
      0,
      0.229589,
      0.600239,
      NULL,
      0.841079,
      16.740849,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      5.441762,
      1,
      NULL,
      1.242600,
      0,
      0,
      0.689567,
      NULL,
      0,
      0,
      0,
      0.102623,
      0,
      NULL,
      1,
      4,
      NULL,
      1,
      10,
      0,
      9,
      5,
      7.164867,
      6,
      5,
      1,
      4,
      NULL,
      2,
      NULL,
      0.551036,
      1.591348,
      3,
      4.058142,
      NULL,
      0.125059,
      NULL,
      NULL,
      0.588689,
      NULL,
      3.743875,
      6.289226,
      3.856719,
      6,
      2.921021,
      2.716153,
      2.992804,
      1.693416,
      0.249303,
      3,
      3.379241,
      NULL,
      0.035031,
      NULL,
      0,
      0,
      NULL,
      1,
      2.348548,
      2.132712,
      NULL,
      1.150612,
      8,
      NULL,
      0.823531,
      0,
      4.105883,
      1.002711,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694750,
      0,
      1,
      1.749661,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.653961,
      0.285465,
      1,
      3.604472,
      1.255841,
      1,
      NULL,
      1.941774,
      NULL,
      NULL,
      3.693451,
      7,
      1,
      3,
      6.698986,
      1.154601,
      9,
      9,
      2,
      NULL,
      9.793048,
      NULL,
      5.778489,
      8,
      2.430965,
      9,
      6.965059,
      11.252619,
      11.767999,
      NULL,
      6.829843,
      NULL,
      1.526419,
      2.185459,
      2.446113,
      NULL,
      7,
      2,
      '10- 9-1998',
      103,
      ' 8-16-1985',
      582.271937,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.891116,
      1.021165,
      1.500268,
      3.134832,
      1,
      7,
      1,
      2.875915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.005852,
      NULL,
      NULL,
      2,
      0.379326,
      NULL,
      1,
      NULL,
      1,
      2.163232,
      4,
      7,
      1.359296,
      1.518097,
      1,
      NULL,
      1.890422,
      0,
      1.809785,
      NULL,
      3.406088,
      7.506001,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.521184,
      3.836389,
      1,
      1.242002,
      9,
      0.548046,
      NULL,
      ' 8-16-1985',
      NULL,
      ' 7-18-1975',
      2,
      NULL,
      1.269437,
      NULL,
      1,
      NULL,
      NULL,
      3.863801,
      0.687424,
      1,
      1.830031,
      NULL,
      26,
      0.810516,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500851,
      NULL,
      3.745980,
      1,
      2.676662,
      0.140599,
      1.881033,
      2,
      3,
      2.531059,
      NULL,
      0,
      3,
      3.869891,
      3.387292,
      NULL,
      2,
      1,
      NULL,
      3,
      0.331841,
      0.536734,
      0,
      1.165569,
      NULL,
      0.093921,
      1.814306,
      0.710426,
      0,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.990803,
      1,
      2,
      1.001688,
      1.983872,
      NULL,
      2,
      NULL,
      3.372658,
      NULL,
      NULL,
      NULL,
      28,
      NULL,
      18,
      50,
      0,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.022806,
      11,
      190.370884,
      29,
      3.211030,
      27,
      15,
      7,
      1.341587,
      0.016163,
      3.737912,
      1.774574,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      2.587293,
      0.479687,
      1,
      3,
      0.149477,
      0,
      3,
      0,
      0.745961,
      1.841552,
      0,
      0.702094,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.725072,
      0.940318,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      3.390250,
      7.717915,
      3.113633,
      NULL,
      NULL,
      NULL,
      NULL,
      3.975811,
      NULL,
      1,
      0,
      1.216951,
      0.570878,
      3,
      1.909947,
      NULL,
      NULL,
      2,
      2.141774,
      1,
      1.941467,
      1,
      1.310609,
      3,
      3.504449,
      0,
      0,
      1.891139,
      2.260514,
      1.819660,
      1,
      3,
      1.521774,
      3.998231,
      1,
      1,
      NULL,
      0,
      1.015241,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      9.454160,
      1.338858,
      NULL,
      5.404852,
      0,
      NULL,
      NULL,
      NULL,
      2.097456,
      3.649065,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.856704,
      2.084109,
      1,
      NULL,
      0,
      1.519548,
      1,
      NULL,
      NULL,
      0.485265,
      0,
      2.690116,
      3.554685,
      2.650331,
      1,
      0,
      NULL,
      NULL,
      3,
      1.950777,
      0,
      NULL,
      2,
      1.122695,
      1,
      NULL,
      NULL,
      1.599495,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1.894778,
      3,
      NULL,
      NULL,
      1.921640,
      NULL,
      6.486668,
      2,
      1.793449,
      1.745828,
      1,
      7,
      4.687142,
      1,
      0,
      3.847495,
      NULL,
      0,
      NULL,
      2.296337,
      0,
      2,
      NULL,
      1,
      9,
      NULL,
      0,
      2.369177,
      3,
      2.632121,
      0.811311,
      2.248926,
      0.124121,
      0.191639,
      1.335022,
      NULL,
      0.012086,
      2,
      0,
      8,
      3,
      4,
      NULL,
      1,
      3,
      3.965385,
      1.323469,
      3,
      1,
      1.254671,
      NULL,
      0,
      NULL,
      0.907424,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.888947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.484482,
      NULL,
      NULL,
      1.734444,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      2.700301,
      2.200845,
      1.431030,
      NULL,
      6.736578,
      0,
      NULL,
      NULL,
      NULL,
      13.737021,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.631408,
      2,
      NULL,
      NULL,
      1.972954,
      1.288253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.629676,
      NULL,
      NULL,
      2,
      2.472844,
      NULL,
      NULL,
      0,
      2.927560,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.354245,
      1.414839,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.703744,
      1,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.137577,
      0.865443,
      NULL,
      NULL,
      0.376289,
      3,
      NULL,
      NULL,
      1.152344,
      NULL,
      NULL,
      NULL,
      4.774733,
      1,
      NULL,
      NULL,
      3.579425,
      1.922543,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      5.876439,
      5052.232650,
      NULL,
      NULL,
      NULL,
      0,
      31,
      23328,
      NULL,
      27,
      2661,
      1.637093,
      28.784072,
      918.085937,
      0.251631,
      NULL,
      1,
      320.658734,
      2978,
      1.144107,
      1,
      0,
      1.395450,
      NULL,
      0,
      1,
      0,
      1,
      1,
      0.445798,
      NULL,
      1,
      0.814063,
      1,
      1.260731,
      0,
      1.351193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.521408,
      NULL,
      0.547649,
      1.860150,
      0.598946,
      1.871608,
      0,
      NULL,
      1,
      1.828572,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.093246,
      2.544279,
      NULL,
      0.464041,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.849514,
      1.817147,
      NULL,
      0.702241,
      0.856062,
      NULL,
      1,
      0,
      NULL,
      1.876561,
      0,
      NULL,
      0.619684,
      0,
      NULL,
      1,
      NULL,
      0.551836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319768,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.114090,
      4,
      3.090877,
      1,
      0,
      30.160557,
      66,
      2,
      3,
      0.251271,
      '41332',
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


