set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8927024';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '2112312',
      0.561152,
      NULL,
      3,
      0,
      '4301',
      0.782581,
      0.439749,
      NULL,
      NULL,
      NULL,
      47,
      NULL,
      0,
      NULL,
      1.227583,
      ' 6- 2-1984',
      10.245713,
      0.031971,
      15.487649,
      127,
      0.129460,
      ' 9-17-2002',
      ' 1-10-1992',
      ' 2-11-1986',
      NULL,
      3.323595,
      NULL,
      0.455150,
      NULL,
      0,
      2.638318,
      0.738298,
      1.862417,
      82.184529,
      7.075666,
      4,
      4.293739,
      9,
      4,
      NULL,
      18,
      2.035708,
      1,
      7.600910,
      1.620337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      5.024381,
      NULL,
      3.385877,
      1.851542,
      1.275270,
      1,
      NULL,
      0.458859,
      1.312623,
      2.965706,
      0,
      1,
      0.358012,
      1.575356,
      0,
      7.695931,
      0.629186,
      1.052590,
      0.133255,
      0,
      0,
      NULL,
      NULL,
      1.941105,
      NULL,
      NULL,
      1,
      0.944979,
      0,
      1.584069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395555,
      0.369316,
      1.116990,
      1.677247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.774504,
      0,
      NULL,
      NULL,
      1.734271,
      NULL,
      1,
      0,
      0.042289,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.533941,
      0.345559,
      0,
      1,
      NULL,
      0.500501,
      0,
      NULL,
      1,
      1.912855,
      0,
      1,
      7,
      0,
      1,
      0,
      NULL,
      3.428800,
      0.917043,
      NULL,
      0.172104,
      NULL,
      0.160931,
      2.579795,
      4.378223,
      4.058471,
      1,
      0,
      1.701739,
      0,
      0,
      NULL,
      2,
      '10- 2-1978',
      896.614910,
      NULL,
      NULL,
      NULL,
      0.109198,
      NULL,
      9,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.606479,
      0.183803,
      0,
      1.778539,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.019469,
      NULL,
      NULL,
      1.245788,
      2,
      NULL,
      1.278274,
      NULL,
      1,
      0,
      5.375740,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898492,
      1,
      1.097645,
      1.443613,
      0.787411,
      5,
      NULL,
      0.929992,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.851274,
      2,
      NULL,
      0.391824,
      1.130640,
      NULL,
      NULL,
      NULL,
      1.593465,
      0,
      0,
      1.810195,
      2,
      NULL,
      NULL,
      0.203113,
      NULL,
      2,
      2,
      3,
      NULL,
      1,
      NULL,
      3,
      0.639347,
      NULL,
      1.106546,
      2,
      NULL,
      0.877402,
      0,
      NULL,
      NULL,
      1.022247,
      0.441325,
      1,
      1,
      1.602343,
      0,
      1,
      NULL,
      3,
      1.911016,
      11,
      10.307771,
      7,
      3,
      3.484160,
      5.101592,
      0.310431,
      1.554914,
      0,
      23.412211,
      1.654012,
      0,
      NULL,
      72.578717,
      15,
      107,
      1,
      1.170990,
      NULL,
      '21232',
      '31230',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      4.108526,
      192,
      12.940808,
      1,
      4,
      NULL,
      10.109118,
      4.208428,
      1,
      NULL,
      1,
      3,
      2.531284,
      1.585665,
      1.498094,
      0.034581,
      0.965313,
      0,
      0,
      0,
      2.816759,
      1,
      NULL,
      3.656688,
      1,
      0,
      2.462142,
      2.930588,
      3.089266,
      1,
      NULL,
      NULL,
      0.732088,
      NULL,
      NULL,
      1,
      1,
      1,
      1.820301,
      0.301700,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      4.982030,
      5.557466,
      0.170502,
      1,
      NULL,
      NULL,
      NULL,
      0.127906,
      NULL,
      NULL,
      NULL,
      2.622223,
      0.414105,
      0,
      1.409789,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.657916,
      0,
      1.471178,
      NULL,
      1,
      0,
      1,
      1.744407,
      1.280418,
      NULL,
      NULL,
      1.020921,
      0.222301,
      0,
      0,
      1.137227,
      NULL,
      NULL,
      2,
      NULL,
      1.575303,
      NULL,
      3.748748,
      1.836739,
      7,
      3,
      0,
      1.626095,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.277741,
      1.825425,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.607882,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.829817,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1.428483,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.364703,
      NULL,
      NULL,
      1,
      NULL,
      0.582947,
      3.679752,
      1.582969,
      2.996464,
      NULL,
      3.890770,
      0.533848,
      1,
      3.335027,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.484657,
      3,
      2,
      1,
      2,
      5,
      1.767617,
      1.850639,
      2,
      5,
      2,
      1,
      1,
      0.167503,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.571070,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.810929,
      NULL,
      NULL,
      0.450589,
      1.442203,
      0,
      NULL,
      0.211769,
      2,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.367082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.300597,
      NULL,
      NULL,
      NULL,
      1.659068,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.913677,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078761,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.748025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.150054,
      NULL,
      NULL,
      NULL,
      1.654592,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.542583,
      3,
      3,
      1.587991,
      1.453735,
      43,
      167.101809,
      0.125620,
      12.120760,
      8.236660,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643356,
      NULL,
      NULL,
      3,
      1.596277,
      0.470127,
      587.528015,
      NULL,
      0.301532,
      1,
      1.806098,
      1,
      1.306815,
      NULL,
      1.474467,
      0,
      0.448827,
      NULL,
      0,
      1.836962,
      1.064828,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.759005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748055,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.198594,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.168050,
      1.524316,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312654,
      3.398052,
      NULL,
      1.598548,
      NULL,
      1.843171,
      NULL,
      NULL,
      NULL,
      1,
      1.314251,
      1.979072,
      NULL,
      3,
      NULL,
      3.053792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.648426,
      1,
      0.438983,
      NULL,
      NULL,
      3,
      0,
      1,
      1.154080,
      3,
      NULL,
      2,
      9,
      2.668525,
      NULL,
      NULL,
      NULL,
      10.614226,
      NULL,
      3.488547,
      0.020950,
      NULL,
      1.180355,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.296830,
      NULL,
      NULL,
      3.480001,
      NULL,
      0,
      0.070259,
      NULL,
      0.565682,
      1,
      NULL,
      0.350655,
      1.107103,
      NULL,
      1,
      1.171225,
      NULL,
      1,
      NULL,
      0.718904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      0.815248,
      NULL,
      0,
      NULL,
      1.464103,
      NULL,
      0,
      NULL,
      2.945949,
      NULL,
      1,
      NULL,
      0.640923,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.774110,
      NULL,
      NULL,
      NULL,
      11,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      0.805583,
      NULL,
      0,
      4,
      5,
      1,
      1.249990,
      0,
      89,
      14,
      4.927151,
      NULL,
      2.596612,
      '32441',
      '23122',
      '',
      1.008066,
      '',
      '',
      '',
      1.227295,
      '',
      NULL,
      '');
commit;
end;
/


