set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7635068';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '2220143',
      1.695260,
      0,
      NULL,
      3,
      '0322',
      2,
      0.902366,
      NULL,
      NULL,
      ' 4- 1-1984',
      13,
      NULL,
      1,
      2,
      1.692173,
      NULL,
      139,
      0,
      62.694340,
      7.025651,
      0.085838,
      NULL,
      NULL,
      ' 5- 1-1981',
      NULL,
      2,
      0.932753,
      NULL,
      0,
      0.901477,
      8.059370,
      NULL,
      2,
      NULL,
      NULL,
      4.436914,
      NULL,
      86,
      198,
      6,
      NULL,
      9,
      2.312275,
      0.724229,
      0,
      1.537935,
      1,
      0.436292,
      0,
      0.475794,
      1.886092,
      0,
      0.418695,
      1,
      NULL,
      15,
      8,
      4.133489,
      2.098275,
      4,
      1.264517,
      6.481179,
      0,
      9.989993,
      3,
      1.687066,
      1.505534,
      0,
      NULL,
      1.045267,
      NULL,
      5.656731,
      NULL,
      NULL,
      0.029686,
      1.043289,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.036495,
      1.006489,
      1.933062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.496549,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.445688,
      4,
      1.481189,
      NULL,
      0,
      4,
      0,
      1.780473,
      1,
      1,
      NULL,
      1,
      3,
      0.056740,
      0,
      0.524962,
      0.701187,
      NULL,
      NULL,
      NULL,
      1.515001,
      7,
      0,
      1,
      7.991179,
      1.205961,
      NULL,
      1.665495,
      2,
      4.101563,
      NULL,
      0.083543,
      6.373506,
      0.124729,
      0.946952,
      3.479452,
      2,
      NULL,
      7,
      11.506200,
      8,
      NULL,
      NULL,
      0.813696,
      8,
      3.385565,
      0.326208,
      ' 6- 8-2001',
      NULL,
      NULL,
      152,
      2,
      0.981304,
      1.928310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.937685,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.461593,
      NULL,
      7.048702,
      NULL,
      6.422202,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.259599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.237137,
      0,
      1.741184,
      NULL,
      1.392086,
      0,
      0,
      2.663304,
      NULL,
      NULL,
      0,
      26,
      1147,
      806,
      2.716001,
      0,
      2.821098,
      0,
      0.093174,
      1.209109,
      0.353275,
      3,
      2,
      2,
      0.461765,
      NULL,
      0.187649,
      NULL,
      NULL,
      NULL,
      144,
      126.013758,
      147.095994,
      80,
      56,
      146.758673,
      0.744867,
      0,
      0.404213,
      0.141130,
      0,
      1.058843,
      1.571929,
      3.385660,
      NULL,
      1,
      5.352446,
      4,
      3,
      5,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.667248,
      3,
      16,
      0.970115,
      2,
      NULL,
      49,
      50.300548,
      29.699881,
      2.786115,
      1.461916,
      2,
      '30302',
      '',
      NULL,
      3,
      '14121',
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      NULL,
      15.287627,
      21.990052,
      2,
      48,
      0.243902,
      20,
      2.333716,
      3.799956,
      1.817132,
      NULL,
      0.907120,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.997712,
      NULL,
      1.150234,
      NULL,
      NULL,
      NULL,
      1.808484,
      1.481765,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.405045,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.429530,
      NULL,
      NULL,
      NULL,
      7.686461,
      0,
      0,
      0.601583,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.807381,
      NULL,
      NULL,
      1.784390,
      NULL,
      NULL,
      1.834831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.265972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134620,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.515341,
      1.544490,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180922,
      0.764193,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      7,
      9,
      0,
      6.393118,
      0,
      2,
      2.699779,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.048244,
      NULL,
      0,
      1.710150,
      1.304744,
      3,
      0,
      0,
      1.192307,
      3,
      0.757699,
      NULL,
      4,
      3.901326,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.629048,
      NULL,
      1,
      1.251071,
      1.473483,
      NULL,
      0,
      NULL,
      NULL,
      0.551166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.642393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.587557,
      1,
      0,
      3.352908,
      1.528655,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.219277,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.277849,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.208427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.048934,
      445,
      396,
      1.159483,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.432900,
      1558.760556,
      1073,
      1,
      NULL,
      NULL,
      0.175486,
      NULL,
      NULL,
      0,
      1990,
      1.110324,
      8.004507,
      0.250405,
      0,
      1,
      1.699233,
      1.556520,
      0,
      1,
      0,
      0,
      0.810505,
      1,
      1.114774,
      NULL,
      1.869486,
      1.541652,
      0,
      0.528980,
      1.436906,
      1.058341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.630432,
      7,
      7.613701,
      1,
      2,
      6,
      1,
      0,
      NULL,
      3.789134,
      3.195498,
      NULL,
      0.548091,
      1.743110,
      NULL,
      NULL,
      0.446886,
      NULL,
      1,
      0,
      NULL,
      0,
      1.871600,
      NULL,
      0,
      1.622697,
      NULL,
      NULL,
      0.046666,
      NULL,
      2,
      NULL,
      NULL,
      1.325835,
      1.178708,
      NULL,
      1.197123,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.679309,
      0.579189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.234634,
      NULL,
      NULL,
      NULL,
      0.327260,
      3.314552,
      11,
      NULL,
      1.318552,
      0,
      62,
      92.460400,
      1,
      0.061243,
      1,
      NULL,
      '',
      NULL,
      3,
      '01411',
      '',
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


