set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9766478';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.263257,
      4,
      1,
      0,
      1.491389,
      0,
      3.327256,
      3.106608,
      '304',
      '04140111',
      55.721379,
      6.631759,
      '2040342',
      2.227648,
      1,
      0,
      1,
      NULL,
      4,
      0.323924,
      NULL,
      NULL,
      ' 3- 5-1985',
      33.160545,
      71,
      NULL,
      2,
      NULL,
      ' 4-24-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-23-1990',
      ' 4-28-1974',
      ' 0- 0-1997',
      NULL,
      1.192809,
      2,
      2.352709,
      1,
      3,
      3,
      1.277306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      NULL,
      1.903584,
      2,
      NULL,
      1,
      NULL,
      0,
      1.420759,
      2,
      1,
      NULL,
      1.835952,
      NULL,
      3.557614,
      1,
      2,
      5,
      1.024333,
      NULL,
      1.765719,
      1,
      1,
      5.525476,
      0.960054,
      2,
      2.494602,
      4,
      NULL,
      7.822006,
      0,
      NULL,
      1.624530,
      1,
      NULL,
      NULL,
      NULL,
      0.170247,
      NULL,
      NULL,
      7,
      0.010396,
      0,
      1,
      0.025039,
      0,
      3,
      NULL,
      1,
      0.103418,
      3,
      1.416423,
      1,
      3.352230,
      0.503686,
      1.847315,
      0,
      NULL,
      2.741516,
      1,
      NULL,
      1,
      3.606841,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.926483,
      0.665782,
      0.178723,
      NULL,
      NULL,
      1,
      1.493638,
      1.146932,
      1.796112,
      NULL,
      0,
      NULL,
      0,
      0.708655,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.988891,
      1,
      4.510900,
      6.425970,
      0.997168,
      5.111334,
      1.860761,
      NULL,
      6.623634,
      NULL,
      NULL,
      NULL,
      7.670494,
      1.015921,
      0.494003,
      1,
      0.582899,
      0.049084,
      3.719658,
      7,
      5,
      8,
      5,
      4.370535,
      1,
      0.773805,
      0,
      NULL,
      115,
      ' 0-17-1996',
      15.284651,
      0,
      0.215113,
      1.357718,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.739882,
      1,
      2.284382,
      0.062325,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747445,
      NULL,
      NULL,
      2,
      NULL,
      1.021013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.534087,
      1.875296,
      2.407508,
      0.873728,
      2,
      0,
      0,
      5.990243,
      3,
      1,
      1,
      2,
      2,
      0.826336,
      NULL,
      NULL,
      1,
      5.147997,
      1.574465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.258456,
      0.048858,
      0,
      NULL,
      NULL,
      0.708539,
      0.912353,
      2.829202,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.380624,
      1,
      NULL,
      1,
      3,
      2.767197,
      0.931406,
      NULL,
      3,
      3,
      1.237080,
      3.210856,
      2,
      3.057655,
      5.511248,
      2,
      0,
      1.584491,
      0.886472,
      5,
      0.852086,
      0,
      1.880513,
      1,
      1,
      0.139702,
      1.028860,
      0.262432,
      0.002012,
      NULL,
      2.803887,
      1.660551,
      5,
      6.779160,
      4.209917,
      6,
      5,
      NULL,
      5,
      0.974851,
      5.603059,
      2,
      0,
      2.746823,
      NULL,
      3,
      1,
      33.825968,
      NULL,
      30.379117,
      NULL,
      5,
      0.772505,
      0.404706,
      NULL,
      '',
      '',
      1.912190,
      '',
      '',
      '',
      1.973509,
      NULL,
      '',
      '',
      NULL,
      22,
      32.517403,
      17.006728,
      1.268233,
      11.524575,
      NULL,
      0,
      1,
      0,
      2.773783,
      2.281597,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.054825,
      0,
      3.606324,
      0.472052,
      NULL,
      NULL,
      0.130947,
      3,
      NULL,
      1.874655,
      1.332176,
      3,
      1.574153,
      NULL,
      3.405659,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.418286,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.561878,
      0.688299,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      1,
      0,
      1,
      0,
      0.680361,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      7.262313,
      0,
      0.908532,
      0.933423,
      NULL,
      NULL,
      NULL,
      1.291375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195499,
      0.669842,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062282,
      NULL,
      NULL,
      4,
      2.973440,
      3,
      2,
      3.520129,
      1.884373,
      1,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1.720106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.813694,
      NULL,
      NULL,
      1.937398,
      NULL,
      NULL,
      1.894617,
      NULL,
      NULL,
      0.374341,
      NULL,
      0.076669,
      0,
      NULL,
      NULL,
      4,
      7.974113,
      0.397554,
      0,
      7.997511,
      4.224569,
      1.545535,
      NULL,
      NULL,
      1.939189,
      NULL,
      NULL,
      NULL,
      1.109626,
      1.545153,
      NULL,
      NULL,
      NULL,
      NULL,
      6.162847,
      NULL,
      NULL,
      3,
      2.197932,
      1.549339,
      0.064738,
      0.861834,
      1,
      1.831437,
      3.438874,
      0,
      NULL,
      1,
      NULL,
      1.855639,
      NULL,
      4.544388,
      4.091410,
      0.424584,
      0.952387,
      5,
      NULL,
      1,
      NULL,
      1.195687,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.179302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.079038,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.522443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.260254,
      0.297450,
      0.108115,
      NULL,
      2.287652,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.207601,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625835,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.389426,
      NULL,
      NULL,
      NULL,
      0.276651,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.232070,
      0.084443,
      NULL,
      3,
      1.912265,
      0.394270,
      NULL,
      NULL,
      0.822618,
      NULL,
      NULL,
      0.784269,
      NULL,
      NULL,
      0.364828,
      NULL,
      NULL,
      0,
      NULL,
      0.862979,
      NULL,
      NULL,
      1,
      0.447071,
      1.651938,
      0,
      0,
      0,
      1,
      0,
      0,
      1,
      1.806943,
      NULL,
      0,
      1.273269,
      0.320339,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.416154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.013783,
      0.832833,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021425,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.406435,
      1.244909,
      1.201642,
      1,
      NULL,
      1.901894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      5.919360,
      1.014630,
      3.547348,
      0.573132,
      6,
      0,
      2.223688,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2.524336,
      NULL,
      1,
      1.290975,
      NULL,
      1.509262,
      3,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      0.735829,
      1.023693,
      NULL,
      1.072896,
      2.659396,
      NULL,
      0,
      2,
      NULL,
      0.622356,
      3.195239,
      NULL,
      0.679049,
      1,
      NULL,
      0.240413,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519501,
      NULL,
      0.609907,
      NULL,
      NULL,
      NULL,
      6,
      6,
      NULL,
      NULL,
      0,
      3,
      NULL,
      92.900213,
      2.154276,
      1,
      3,
      NULL,
      '21010',
      '',
      1,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


